/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.moderation;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;

public class OpenProxyModerationPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)OpenProxyModerationPlugin.class);
    public static final String BLOJSOM_OPEN_PROXY_PLUGIN_MESSAGE = "BLOJSOM_OPEN_PROXY_PLUGIN_MESSAGE";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._logger.debug((Object)"Initialized open proxy moderation plugin");
    }

    protected void checkOpenProxy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String remoteIP = httpServletRequest.getRemoteAddr();
        String[] ipAddress = remoteIP.split("\\.");
        StringBuffer reversedAddress = new StringBuffer();
        reversedAddress.append(ipAddress[3]).append(".").append(ipAddress[2]).append(".").append(ipAddress[1]).append(".").append(ipAddress[0]);
        try {
            InetAddress inetAddress = InetAddress.getByName(reversedAddress + ".list.dsbl.org");
            if ("y".equalsIgnoreCase(httpServletRequest.getParameter("comment")) && user.getBlog().getBlogCommentsEnabled().booleanValue()) {
                Map commentMetaData = context.containsKey("BLOJSOM_PLUGIN_COMMENT_METADATA") ? (Map)context.get("BLOJSOM_PLUGIN_COMMENT_METADATA") : new HashMap();
                if ("true".equalsIgnoreCase(user.getBlog().getBlogProperty("comment-moderation-enabled"))) {
                    commentMetaData.put("BLOJSOM_COMMENT_MODERATION_PLUGIN_APPROVED", Boolean.FALSE.toString());
                    context.put("BLOJSOM_PLUGIN_COMMENT_METADATA", commentMetaData);
                    this._logger.debug((Object)"Marking comment as requiring approval");
                } else {
                    commentMetaData.put("BLOJSOM_PLUGIN_COMMENT_METADATA_DESTROY", Boolean.TRUE.toString());
                    this._logger.debug((Object)"Marking comment to be destroyed");
                }
                context.put("BLOJSOM_PLUGIN_COMMENT_METADATA", commentMetaData);
            }
            if ("y".equalsIgnoreCase(httpServletRequest.getParameter("tb")) && user.getBlog().getBlogTrackbacksEnabled().booleanValue()) {
                Map trackbackMetaData = context.containsKey("BLOJSOM_PLUGIN_TRACKBACK_METADATA") ? (Map)context.get("BLOJSOM_PLUGIN_TRACKBACK_METADATA") : new HashMap();
                if ("true".equalsIgnoreCase(user.getBlog().getBlogProperty("trackback-moderation-enabled"))) {
                    trackbackMetaData.put("BLOJSOM_TRACKBACK_MODERATION_PLUGIN_APPROVED", Boolean.FALSE.toString());
                    this._logger.debug((Object)"Marking trackback as requiring approval");
                } else {
                    trackbackMetaData.put("BLOJSOM_PLUGIN_TRACKBACK_METADATA_DESTROY", Boolean.TRUE.toString());
                    this._logger.debug((Object)"Marking trackback to be destroyed");
                }
                context.put("BLOJSOM_PLUGIN_TRACKBACK_METADATA", trackbackMetaData);
            }
            this._logger.debug((Object)("Failed open proxy check for comment/trackback submission for IP: " + inetAddress.getHostAddress() + "/" + inetAddress.getHostName()));
            context.put(BLOJSOM_OPEN_PROXY_PLUGIN_MESSAGE, "Failed open proxy authentication check.");
        }
        catch (UnknownHostException e) {
            return;
        }
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        this.checkOpenProxy(httpServletRequest, httpServletResponse, user, context, entries);
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

