/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.referer;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.blojsom.plugin.referer.BlogReferer;

public class BlogRefererGroup {
    private Map _groups = new HashMap(25);
    private int _grouptotal = 0;
    private boolean _hitcount = false;
    private Date _lasthit;

    public BlogRefererGroup(boolean ishitcount) {
        this._hitcount = ishitcount;
    }

    public void addReferer(String flavor, String url, Date date) {
        if (this._groups.containsKey(url)) {
            BlogReferer br = (BlogReferer)this._groups.get(url);
            br.increment();
            br.setLastReferral(date);
        } else {
            this._groups.put(url, new BlogReferer(flavor, url, date, 1));
        }
        ++this._grouptotal;
    }

    public void addHitCount(Date date) {
        this.addHitCount(date, 1);
    }

    public void addHitCount(Date date, int count) {
        if (this._lasthit == null) {
            this._lasthit = date;
        }
        if (date.compareTo(this._lasthit) > 0) {
            this._lasthit = date;
        }
        this._grouptotal += count;
    }

    public void addReferer(String flavor, String url, Date date, int total) {
        if (this._groups.containsKey(url)) {
            BlogReferer br = (BlogReferer)this._groups.get(url);
            br.setLastReferral(date);
            br.setCount(total);
        } else {
            this._groups.put(url, new BlogReferer(flavor, url, date, total));
        }
        this._grouptotal += total;
    }

    public int size() {
        return this._groups.size();
    }

    public Object get(Object key) {
        return this._groups.get(key);
    }

    public Set keySet() {
        return this._groups.keySet();
    }

    public int getReferralCount() {
        return this._grouptotal;
    }

    public boolean isHitCounter() {
        return this._hitcount;
    }

    public Date getLastReferralDate() {
        return this._lasthit;
    }
}

