/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.textile;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.textile4j.Textile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class TextilePlugin
implements BlojsomPlugin {
    public static final String METADATA_RUN_TEXTILE = "run-textile";
    public static final String TEXTILE_EXTENSION = ".textile";
    private Textile _textile;
    private Log _logger = LogFactory.getLog((Class)TextilePlugin.class);

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._textile = new Textile();
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        for (int x = 0; x < entries.length; ++x) {
            BlogEntry entry = entries[x];
            if (!entry.getPermalink().endsWith(TEXTILE_EXTENSION) && !BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)METADATA_RUN_TEXTILE)) continue;
            this._logger.debug((Object)("Textile processing: " + entry.getTitle()));
            entry.setDescription(this._textile.process(entry.getDescription()));
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

