/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.trackback;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;

public class TrackbackModerationPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)TrackbackModerationPlugin.class);
    public static final String TRACKBACK_MODERATION_ENABLED = "trackback-moderation-enabled";
    public static final String BLOJSOM_TRACKBACK_MODERATION_PLUGIN_APPROVED = "BLOJSOM_TRACKBACK_MODERATION_PLUGIN_APPROVED";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._logger.debug((Object)"Initialized trackback moderation plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        this.moderateTrackback(httpServletRequest, httpServletResponse, user, context, entries);
        return entries;
    }

    protected void moderateTrackback(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        Blog blog = user.getBlog();
        if ("true".equalsIgnoreCase(blog.getBlogProperty(TRACKBACK_MODERATION_ENABLED)) && "y".equalsIgnoreCase(httpServletRequest.getParameter("tb")) && user.getBlog().getBlogTrackbacksEnabled().booleanValue()) {
            Map trackbackMetaData = context.containsKey("BLOJSOM_PLUGIN_TRACKBACK_METADATA") ? (Map)context.get("BLOJSOM_PLUGIN_TRACKBACK_METADATA") : new HashMap();
            trackbackMetaData.put(BLOJSOM_TRACKBACK_MODERATION_PLUGIN_APPROVED, Boolean.FALSE.toString());
            context.put("BLOJSOM_PLUGIN_TRACKBACK_METADATA", trackbackMetaData);
            this._logger.debug((Object)"Marking trackback as requiring approval");
        }
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

