/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.trackback;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.blog.Trackback;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.common.VelocityPlugin;
import org.blojsom.plugin.email.EmailUtils;
import org.blojsom.plugin.trackback.event.TrackbackAddedEvent;
import org.blojsom.plugin.trackback.event.TrackbackResponseSubmissionEvent;
import org.blojsom.util.BlojsomMetaDataConstants;
import org.blojsom.util.BlojsomUtils;

public class TrackbackPlugin
extends VelocityPlugin
implements BlojsomMetaDataConstants {
    private Log _logger = LogFactory.getLog((Class)TrackbackPlugin.class);
    private static final String TRACKBACK_PLUGIN_EMAIL_TEMPLATE = "org/blojsom/plugin/trackback/trackback-plugin-email-template.vm";
    private static final String DEFAULT_TRACKBACK_PREFIX = "[blojsom] Trackback on: ";
    public static final String TRACKBACK_PREFIX_IP = "plugin-trackback-email-prefix";
    public static final String TRACKBACK_THROTTLE_MINUTES_IP = "plugin-trackback-throttle";
    public static final String TRACKBACK_DAYS_EXPIRATION_IP = "plugin-trackback-days-expiration";
    private static final int TRACKBACK_THROTTLE_DEFAULT_MINUTES = 5;
    public static final String TRACKBACK_PARAM = "tb";
    public static final String TRACKBACK_TITLE_PARAM = "title";
    public static final String TRACKBACK_EXCERPT_PARAM = "excerpt";
    public static final String TRACKBACK_URL_PARAM = "url";
    public static final String TRACKBACK_BLOG_NAME_PARAM = "blog_name";
    public static final String BLOJSOM_TRACKBACK_PLUGIN_ENABLED = "BLOJSOM_TRACKBACK_PLUGIN_ENABLED";
    public static final String BLOJSOM_TRACKBACK_RETURN_CODE = "BLOJSOM_TRACKBACK_RETURN_CODE";
    public static final String BLOJSOM_TRACKBACK_MESSAGE = "BLOJSOM_TRACKBACK_MESSAGE";
    public static final String BLOJSOM_TRACKBACK_PLUGIN_METADATA_IP = "BLOJSOM_TRACKBACK_PLUGIN_METADATA_IP";
    private static final String TRACKBACK_SUCCESS_PAGE = "/trackback-success";
    private static final String TRACKBACK_FAILURE_PAGE = "/trackback-failure";
    public static final String BLOJSOM_TRACKBACK_PLUGIN_BLOG_ENTRY = "BLOJSOM_TRACKBACK_PLUGIN_BLOG_ENTRY";
    public static final String BLOJSOM_TRACKBACK_PLUGIN_TRACKBACK = "BLOJSOM_TRACKBACK_PLUGIN_TRACKBACK";
    public static final String BLOJSOM_PLUGIN_TRACKBACK_METADATA = "BLOJSOM_PLUGIN_TRACKBACK_METADATA";
    public static final String BLOJSOM_PLUGIN_TRACKBACK_METADATA_DESTROY = "BLOJSOM_PLUGIN_TRACKBACK_METADATA_DESTROY";
    private Map _ipAddressTrackbackTimes;
    private BlojsomConfiguration _blojsomConfiguration;
    private BlojsomFetcher _fetcher;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        this._blojsomConfiguration = blojsomConfiguration;
        this._ipAddressTrackbackTimes = new HashMap(10);
        String fetcherClassName = blojsomConfiguration.getFetcherClass();
        try {
            Class<?> fetcherClass = Class.forName(fetcherClassName);
            this._fetcher = (BlojsomFetcher)fetcherClass.newInstance();
            this._fetcher.init(servletConfig, blojsomConfiguration);
            this._logger.info((Object)("Added blojsom fetcher: " + fetcherClassName));
        }
        catch (ClassNotFoundException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (InstantiationException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String[] bannedIPList;
        Blog blog = user.getBlog();
        context.put(BLOJSOM_TRACKBACK_PLUGIN_ENABLED, blog.getBlogTrackbacksEnabled());
        if (!blog.getBlogTrackbacksEnabled().booleanValue()) {
            this._logger.debug((Object)("blog trackbacks not enabled for user: " + user.getId()));
            return entries;
        }
        Boolean _blogEmailEnabled = blog.getBlogEmailEnabled();
        Boolean _blogTrackbacksEnabled = blog.getBlogTrackbacksEnabled();
        String _emailPrefix = blog.getBlogProperty(TRACKBACK_PREFIX_IP);
        if (_emailPrefix == null) {
            _emailPrefix = DEFAULT_TRACKBACK_PREFIX;
        }
        if (entries.length == 0) {
            return entries;
        }
        if (!_blogTrackbacksEnabled.booleanValue()) {
            return entries;
        }
        String bannedIPListParam = blog.getBlogProperty("blog-banned-ip-addresses");
        if (bannedIPListParam == null) {
            bannedIPList = null;
            this._logger.info((Object)"Blog configuration parameter not supplied for: blog-banned-ip-addresses");
        } else {
            bannedIPList = BlojsomUtils.parseCommaList((String)bannedIPListParam);
        }
        String remoteIPAddress = httpServletRequest.getRemoteAddr();
        if (this.isIPBanned(bannedIPList, remoteIPAddress)) {
            this._logger.debug((Object)("Attempted trackback from banned IP address: " + remoteIPAddress));
            return entries;
        }
        String category = httpServletRequest.getPathInfo();
        if (category == null) {
            category = "/";
        } else if (!category.endsWith("/")) {
            category = category + "/";
        }
        if (category.startsWith("/" + user.getId() + "/")) {
            category = BlojsomUtils.getCategoryFromPath((String)category);
        }
        category = BlojsomUtils.urlDecode((String)category);
        String url = httpServletRequest.getParameter(TRACKBACK_URL_PARAM);
        String permalink = httpServletRequest.getParameter("permalink");
        String title = httpServletRequest.getParameter(TRACKBACK_TITLE_PARAM);
        String excerpt = httpServletRequest.getParameter(TRACKBACK_EXCERPT_PARAM);
        String blogName = httpServletRequest.getParameter(TRACKBACK_BLOG_NAME_PARAM);
        String tb = httpServletRequest.getParameter(TRACKBACK_PARAM);
        if (permalink != null && !"".equals(permalink) && tb != null && "y".equalsIgnoreCase(tb)) {
            block41: {
                if (url == null || "".equals(url.trim())) {
                    context.put(BLOJSOM_TRACKBACK_RETURN_CODE, new Integer(1));
                    context.put(BLOJSOM_TRACKBACK_MESSAGE, "No url parameter for trackback. url must be specified.");
                    httpServletRequest.setAttribute("page", (Object)TRACKBACK_FAILURE_PAGE);
                    return entries;
                }
                String trackbackThrottleValue = blog.getBlogProperty(TRACKBACK_THROTTLE_MINUTES_IP);
                if (!BlojsomUtils.checkNullOrBlank((String)trackbackThrottleValue)) {
                    int trackbackThrottleMinutes;
                    try {
                        trackbackThrottleMinutes = Integer.parseInt(trackbackThrottleValue);
                    }
                    catch (NumberFormatException e) {
                        trackbackThrottleMinutes = 5;
                    }
                    this._logger.debug((Object)("Trackback throttling enabled at: " + trackbackThrottleMinutes + " minutes"));
                    remoteIPAddress = httpServletRequest.getRemoteAddr();
                    if (this._ipAddressTrackbackTimes.containsKey(remoteIPAddress)) {
                        Calendar currentTime = Calendar.getInstance();
                        Calendar timeOfLastTrackback = (Calendar)this._ipAddressTrackbackTimes.get(remoteIPAddress);
                        long timeDifference = currentTime.getTimeInMillis() - timeOfLastTrackback.getTimeInMillis();
                        long differenceInMinutes = timeDifference / 60000L;
                        if (differenceInMinutes < (long)trackbackThrottleMinutes) {
                            this._logger.debug((Object)("Trackback throttle enabled. Comment from IP address: " + remoteIPAddress + " in less than " + trackbackThrottleMinutes + " minutes"));
                            context.put(BLOJSOM_TRACKBACK_RETURN_CODE, new Integer(1));
                            context.put(BLOJSOM_TRACKBACK_MESSAGE, "Trackback throttling enabled.");
                            httpServletRequest.setAttribute("page", (Object)TRACKBACK_FAILURE_PAGE);
                            return entries;
                        }
                        this._logger.debug((Object)"Trackback throttle enabled. Resetting date of last comment to current time");
                        this._ipAddressTrackbackTimes.put(remoteIPAddress, currentTime);
                    } else {
                        Calendar calendar = Calendar.getInstance();
                        this._ipAddressTrackbackTimes.put(remoteIPAddress, calendar);
                    }
                }
                if (!(url = url.trim()).toLowerCase().startsWith("http://")) {
                    url = "http://" + url;
                }
                title = BlojsomUtils.checkNullOrBlank((String)title) ? url : title.trim();
                if (excerpt == null) {
                    excerpt = "";
                } else {
                    if (excerpt.length() >= 255) {
                        excerpt = excerpt.substring(0, 252);
                        excerpt = excerpt + "...";
                    }
                    excerpt = BlojsomUtils.stripLineTerminators((String)excerpt);
                }
                if (blogName == null) {
                    blogName = "";
                } else {
                    blogName = blogName.trim();
                    blogName = BlojsomUtils.stripLineTerminators((String)blogName);
                }
                if (!category.endsWith("/")) {
                    category = category + "/";
                }
                BlogCategory blogCategory = this._fetcher.newBlogCategory();
                blogCategory.setCategory(category);
                blogCategory.setCategoryURL(user.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)category));
                HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                fetchMap.put("FETCHER_CATEGORY", blogCategory);
                fetchMap.put("FETCHER_PERMALINK", permalink);
                try {
                    BlogEntry[] fetchedEntries = this._fetcher.fetchEntries(fetchMap, user);
                    if (fetchedEntries.length <= 0) break block41;
                    BlogEntry entry = fetchedEntries[0];
                    if (BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)"blog-entry-trackbacks-disabled")) {
                        this._logger.debug((Object)("Trackbacks have been disabled for blog entry: " + entry.getId()));
                        context.put(BLOJSOM_TRACKBACK_MESSAGE, "Trackbacks have been disabled for this blog entry");
                        context.put(BLOJSOM_TRACKBACK_RETURN_CODE, new Integer(1));
                        httpServletRequest.setAttribute("page", (Object)TRACKBACK_FAILURE_PAGE);
                        return entries;
                    }
                    String trackbackDaysExpiration = blog.getBlogProperty(TRACKBACK_DAYS_EXPIRATION_IP);
                    if (BlojsomUtils.checkNullOrBlank((String)trackbackDaysExpiration)) break block41;
                    try {
                        int daysExpiration = Integer.parseInt(trackbackDaysExpiration);
                        int daysBetweenDates = BlojsomUtils.daysBetweenDates((Date)entry.getDate(), (Date)new Date());
                        if (daysExpiration > 0 && daysBetweenDates >= daysExpiration) {
                            this._logger.debug((Object)("Trackback period for this entry has expired. Expiration period set at " + daysExpiration + " days. Difference in days: " + daysBetweenDates));
                            return entries;
                        }
                    }
                    catch (NumberFormatException e) {
                        this._logger.error((Object)("Error in parameter plugin-trackback-days-expiration: " + trackbackDaysExpiration));
                    }
                }
                catch (BlojsomFetcherException e) {
                    this._logger.error((Object)e);
                }
            }
            HashMap<String, String> trackbackMetaData = new HashMap<String, String>();
            trackbackMetaData.put(BLOJSOM_TRACKBACK_PLUGIN_METADATA_IP, remoteIPAddress);
            if (context.containsKey(BLOJSOM_PLUGIN_TRACKBACK_METADATA)) {
                Map metaData = (Map)context.get(BLOJSOM_PLUGIN_TRACKBACK_METADATA);
                Iterator metaDataKeys = metaData.keySet().iterator();
                while (metaDataKeys.hasNext()) {
                    Object key = metaDataKeys.next();
                    Object value = metaData.get(key);
                    trackbackMetaData.put((String)key, (String)value);
                }
            }
            Trackback trackback = this._fetcher.newTrackback();
            trackback.setBlogEntry(entries[0]);
            Integer code = new Integer(1);
            this._blojsomConfiguration.getEventBroadcaster().processEvent((BlojsomEvent)new TrackbackResponseSubmissionEvent(this, new Date(), user, httpServletRequest, httpServletResponse, blogName, title, url, excerpt, trackbackMetaData));
            if (!trackbackMetaData.containsKey(BLOJSOM_PLUGIN_TRACKBACK_METADATA_DESTROY)) {
                code = this.addTrackback(title, excerpt, url, blogName, trackbackMetaData, trackback, user, context);
                context.put("BLOJSOM_LAST_MODIFIED", new Long(new Date().getTime()));
                HashMap<String, Object> emailTemplateContext = new HashMap<String, Object>();
                emailTemplateContext.put("BLOJSOM_BLOG", blog);
                emailTemplateContext.put("BLOJSOM_USER", user);
                emailTemplateContext.put(BLOJSOM_TRACKBACK_PLUGIN_BLOG_ENTRY, entries[0]);
                emailTemplateContext.put(BLOJSOM_TRACKBACK_PLUGIN_TRACKBACK, trackback);
                String emailTrackback = this.mergeTemplate(TRACKBACK_PLUGIN_EMAIL_TEMPLATE, user, emailTemplateContext);
                if (_blogEmailEnabled.booleanValue()) {
                    this.sendTrackbackEmail(_emailPrefix, entries[0].getTitle(), emailTrackback, context, (String)entries[0].getMetaData().get("blog-entry-author"), blog);
                }
            } else {
                this._logger.info((Object)"Trackback meta-data contained destroy key. Trackback was not saved");
            }
            context.put(BLOJSOM_TRACKBACK_RETURN_CODE, code);
            if (code == 0) {
                httpServletRequest.setAttribute("page", (Object)TRACKBACK_SUCCESS_PAGE);
                try {
                    entries[0].load(user);
                }
                catch (BlojsomException e) {
                    this._logger.error((Object)e);
                }
                this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new TrackbackAddedEvent((Object)this, new Date(), trackback, user));
            } else {
                httpServletRequest.setAttribute("page", (Object)TRACKBACK_FAILURE_PAGE);
            }
        }
        return entries;
    }

    private Integer addTrackback(String title, String excerpt, String url, String blogName, Map trackbackMetaData, Trackback trackback, BlogUser blogUser, Map context) {
        excerpt = BlojsomUtils.escapeMetaAndLink((String)excerpt);
        trackback.setTitle(title);
        trackback.setExcerpt(excerpt);
        trackback.setUrl(url);
        trackback.setBlogName(blogName);
        trackback.setTrackbackDateLong(new Date().getTime());
        trackback.setMetaData(trackbackMetaData);
        try {
            trackback.save(blogUser);
        }
        catch (BlojsomException e) {
            context.put(BLOJSOM_TRACKBACK_MESSAGE, e.getMessage());
            return new Integer(1);
        }
        return new Integer(0);
    }

    public void sendTrackbackEmail(String emailPrefix, String title, String trackback, Map context, String author, Blog blog) {
        String recipientEmail = blog.getAuthorizedUserEmail(author);
        EmailUtils.notifyBlogAuthor(emailPrefix + title, trackback, context, recipientEmail);
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

