/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.weather;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.weather.Weather;
import org.blojsom.plugin.weather.WeatherFetcher;
import org.blojsom.plugin.weather.WeatherPluginUtils;
import org.blojsom.plugin.weather.beans.NWSInformation;
import org.blojsom.plugin.weather.beans.WeatherInformation;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class WeatherPlugin
implements BlojsomPlugin,
BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)WeatherPlugin.class);
    private static final int DEFAULT_POLL_TIME = 3200;
    public static final String PLUGIN_WEATHER_POLL_TIME = "plugin-weather-poll-time";
    public static final String PLUGIN_WEATHER_CONFIGURATION_IP = "plugin-weather";
    public static final String PROPERTY_WEATHER_CODE = "weather-station-code";
    public static final String PROPERTY_WEATHER_PROVIDER = "weather-provider";
    public static final String DEFAULT_WEATHER_PROVIDER = "org.blojsom.plugin.weather.beans.NWSInformation";
    public static final String DEFAULT_WEATHER_CODE = "KSJC";
    private WeatherChecker _weatherThread;
    private boolean _finished = false;
    private int _pollTime;
    private ServletConfig _servletConfig;
    private BlojsomConfiguration _blojsomConfiguration;
    private Map _userWeatherMap;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._userWeatherMap = new HashMap(10);
        String weatherPollTime = servletConfig.getInitParameter(PLUGIN_WEATHER_POLL_TIME);
        if (BlojsomUtils.checkNullOrBlank((String)weatherPollTime)) {
            this._pollTime = 3200;
        } else {
            try {
                this._pollTime = Integer.parseInt(weatherPollTime);
            }
            catch (NumberFormatException e) {
                this._logger.error((Object)"Invalid time specified for: plugin-weather-poll-time");
                this._pollTime = 3200;
            }
        }
        this._servletConfig = servletConfig;
        this._blojsomConfiguration = blojsomConfiguration;
        this._weatherThread = new WeatherChecker();
        this._weatherThread.setDaemon(true);
        this._weatherThread.start();
        this._logger.debug((Object)"Initialized weather plugin.");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        WeatherInformation info = (WeatherInformation)this._userWeatherMap.get(user.getId());
        if (info != null) {
            context.put("BLOJSOM_WEATHER_INFORMATION", info);
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
        this._finished = true;
    }

    private class WeatherChecker
    extends Thread {
        private WeatherFetcher _fetcher = new WeatherFetcher();

        private WeatherInformation collectWeatherData(Weather weather) {
            WeatherInformation result = null;
            try {
                WeatherPlugin.this._logger.info((Object)("Fetching forecast for " + weather.getStationCode()));
                NWSInformation nws = new NWSInformation(weather.getStationCode());
                result = this._fetcher.retrieveForecast(nws);
                WeatherPlugin.this._logger.info((Object)result);
            }
            catch (IOException e) {
                WeatherPlugin.this._logger.error((Object)e);
            }
            return result;
        }

        public void run() {
            try {
                while (!WeatherPlugin.this._finished) {
                    WeatherPlugin.this._logger.debug((Object)"Weather plugin is waking up and looking for updated forecasts");
                    String[] users = WeatherPlugin.this._blojsomConfiguration.getBlojsomUsers();
                    for (int i = 0; i < users.length; ++i) {
                        String user = users[i];
                        BlogUser blogUser = null;
                        try {
                            WeatherInformation info;
                            blogUser = WeatherPlugin.this._blojsomConfiguration.loadBlog(user);
                            Weather weather = WeatherPluginUtils.readWeatherSettingsForUser(WeatherPlugin.this._blojsomConfiguration, WeatherPlugin.this._servletConfig, blogUser);
                            if (weather == null || !weather.isEnabled() || (info = this.collectWeatherData(weather)) == null) continue;
                            WeatherPlugin.this._userWeatherMap.put(blogUser.getId(), info);
                            continue;
                        }
                        catch (BlojsomException e) {
                            WeatherPlugin.this._logger.error((Object)e);
                        }
                    }
                    WeatherPlugin.this._logger.debug((Object)"Weather plugin off to take a nap");
                    WeatherChecker.sleep(WeatherPlugin.this._pollTime * 1000);
                }
            }
            catch (InterruptedException e) {
                WeatherPlugin.this._logger.error((Object)e);
            }
        }
    }
}

