/**
 * Copyright (c) 2003-2005 , David A. Czarnecki
 * All rights reserved.
 *
 * Portions Copyright (c) 2003-2005  by Mark Lussier
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * Neither the name of the "David A. Czarnecki" and "blojsom" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "blojsom",
 * nor may "blojsom" appear in their name, without prior written permission of
 * David A. Czarnecki.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.blojsom.blog;

import org.blojsom.util.BlojsomUtils;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.BlojsomDataBase;
import org.blojsom.BlojsomException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.FileOutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.List;
import java.util.ArrayList;
import java.util.Vector;

/**
 * FileBackedBlogCategory
 *
 * @author David Czarnecki
 * @version $Id: FileBackedBlogCategory.java,v 1.9 2005/06/15 20:04:36 czarneckid Exp $
 */
public class FileBackedBlogCategory extends BlogCategory {

    private transient Log _logger = LogFactory.getLog(FileBackedBlogCategory.class);

    protected transient BlogUser _blogUser;

    /**
     * Create a new FileBackedBlogCategory.
     */
    public FileBackedBlogCategory() {
        super();
    }

    /**
     * Create a new FileBackedBlogCategory.
     *
     * @param category    Category name
     * @param categoryURL Category URL
     */
    public FileBackedBlogCategory(String category, String categoryURL) {
        super(category, categoryURL);
    }

    /**
     * Load the meta data for the category
     *
     * @param blogHome             Directory where blog entries are stored
     * @param propertiesExtensions List of file extensions to use when looking for category properties
     */
    protected void loadMetaData(String blogHome, String[] propertiesExtensions) {
        //File blog = new File(blogHome + BlojsomUtils.removeInitialSlash(_category));
        //String str = "";
        BlojsomDataBase blojsomdb = new BlojsomDataBase();
        blojsomdb.startDB();
        int categoryPropertyFiles = 0;
        ResultSet rs = null;
        ResultSet rs1 = null;
        Vector columnName = null;
        try {
        	rs = blojsomdb.myExecuteQuery("SELECT category_name FROM category where weblog_id='"+this._blogUser._id+"'");
        	rs.last();
        	categoryPropertyFiles = rs.getRow();
        	rs.first();
			// J̎擾
        	if(_category.equals("/")){
        		rs1 = blojsomdb.myExecuteQuery("SELECT * FROM category WHERE weblog_id='"+this._blogUser._id+"' and category_name IS NULL");
        	}else{
        		rs1 = blojsomdb.myExecuteQuery("SELECT * FROM category where weblog_id='"+this._blogUser._id+"' and category_name='"+BlojsomUtils.removeSlashes(_category)+"'");
        	}
			ResultSetMetaData rsmd = rs1.getMetaData();
			int iCols = rsmd.getColumnCount();
			int column = 5;
			columnName = new Vector();
			while (column <= iCols) {
				columnName.add(rsmd.getColumnName(column));
				column++;
			}
    	}catch(Exception e){
    		e.printStackTrace();
    	} 

        // Load properties file for category (if present)
        //File[] categoryPropertyFiles = blog.listFiles(BlojsomUtils.getExtensionsFilter(propertiesExtensions));
        if ((categoryPropertyFiles != 0) && (categoryPropertyFiles > 0)) {
        	BlojsomProperties dirProps = new BlojsomProperties();
            for (int i = 0; i < categoryPropertyFiles; i++) {
                try {
					// ꂽs[v
                	while (rs1.next()) {
						for (int j = 0; j < columnName.size(); j++) {
							String line = columnName.get(j).toString();
							line = BlojsomUtils.replace(line, "_", ".");
							line = line.toLowerCase();
							line = line + "=" + rs1.getString(columnName.get(j).toString());
							if (line != null) {
								if (line.length() > 0) {
									if (line.charAt(0) != '#') {
										int len = line.length();
										int keyIndex;
										for (keyIndex = 0; keyIndex < len; keyIndex++) {
											if (line.charAt(keyIndex) == '\\')
												keyIndex += 2;
											else if (BlojsomProperties.whiteSpaceChars
													.indexOf(line
															.charAt(keyIndex)) == -1)
												break;
										}

										int separatorIndex;
										for (separatorIndex = keyIndex; separatorIndex < len; separatorIndex++) {
											char currentChar = line
													.charAt(separatorIndex);
											if (currentChar == '\\')
												separatorIndex++;
											else if (BlojsomProperties.keyValueSeparators
													.indexOf(currentChar) != -1)
												break;
										}

										int valueIndex;
										for (valueIndex = separatorIndex; valueIndex < len; valueIndex++)
											if (BlojsomProperties.whiteSpaceChars
													.indexOf(line
															.charAt(valueIndex)) == -1)
												break;

										if (valueIndex < len)
											if (BlojsomProperties.strictKeyValueSeparators
													.indexOf(line
															.charAt(valueIndex)) != -1)
												valueIndex++;

										while (valueIndex < len) {
											if (BlojsomProperties.whiteSpaceChars
													.indexOf(line
															.charAt(valueIndex)) == -1)
												break;
											valueIndex++;
										}

										String key;
										String value;

										key = line.substring(keyIndex,
												separatorIndex);
										key = BlojsomUtils.replace(key, "\\",
												"");// key="BLOJSOM_COMMENT_PLUGIN_METADATA_IP"
										value = (separatorIndex < len) ? line
												.substring(valueIndex, len)
												: "";// value="127.0.0.1"

										List values;
										if (dirProps.containsKey(key)
												&& dirProps.allowMultipleValues) {
											Object previousValue = dirProps
													.get(key);

											if (previousValue instanceof List) {
												values = (List) previousValue;
												values.add(value);
											} else {
												values = new ArrayList(1);
												values.add(previousValue);
												values.add(value);
											}

											dirProps.put(key, values);
										} else {
											dirProps.put(key, value);
										}
									}
								}
							}
						}
					}
					//rs.absolute(categoryPropertyFiles);
					//str = rs.getString("category_name");
                } catch (Exception e) {
                	e.printStackTrace();
					_logger.warn("Failed loading properties from: " + e);
                    continue;
				}
            }
            setMetaData(dirProps);
        }
        blojsomdb.stopDB();
    }

    /**
     * Load a blog category.
     *
     * @param blog {@link Blog}
     * @throws BlojsomException If there is an error loading the category
     * @since blojsom 1.9.1
     * @deprecated
     */
    public void load(Blog blog) throws BlojsomException {
    }

    /**
     * Save the blog category.
     *
     * @param blog {@link Blog}
     * @throws BlojsomException If there is an error saving the category
     * @since blojsom 1.9.1
     * @deprecated
     */
    public void save(Blog blog) throws BlojsomException {
    }

    /**
     * Delete the blog category.
     *
     * @param blog {@link Blog}
     * @throws BlojsomException If there is an error deleting the category
     * @since blojsom 1.9.1
     * @deprecated
     */
    public void delete(Blog blog) throws BlojsomException {
    }

    /**
     * Load a blog category. Currently only loads the blog meta-data from disk.
     *
     * @param blogUser {@link BlogUser}
     * @throws BlojsomException If there is an error loading the category
     * @since blojsom 2.22
     */
    public void load(BlogUser blogUser) throws BlojsomException {
        _blogUser = blogUser;
        Blog blog = blogUser.getBlog();
        loadMetaData(blog.getBlogHome(), blog.getBlogPropertiesExtensions());
    }

    /**
     * Save the blog category.
     *
     * @param blogUser {@link BlogUser}
     * @throws BlojsomException If there is an error saving the category
     * @since blojsom 2.22
     */
    public void save(BlogUser blogUser) throws BlojsomException {
        _blogUser = blogUser;
        Blog blog = blogUser.getBlog();
        File blogCategory = new File(blog.getBlogHome() + BlojsomUtils.removeSlashes(_category));

        // If the category does not exist, try and create it
        if (!blogCategory.exists()) {
            if (!blogCategory.mkdirs()) {
                _logger.error("Could not create new blog category at: " + blogCategory.toString());

                return;
            }
        }

        // We know the category exists so try and save its meta-data
        //String propertiesExtension = blog.getBlogPropertiesExtensions()[0];
        //File categoryMetaDataFile = new File(blogCategory, "blojsom" + propertiesExtension);
        BlojsomProperties categoryMetaData = (BlojsomProperties) BlojsomUtils.mapToProperties(_metadata, BlojsomConstants.UTF8);
        // try {
		// FileOutputStream fos = new FileOutputStream(categoryMetaDataFile);
		// DBp̃Rg
		// categoryMetaData.getProperty(BlojsomUtils.removeInitialSlash(_category),"CATEGORY");
		// categoryMetaData.store(fos, null);

		// writer.write("#" + new Date().toString());writer.newLine();
        BlojsomDataBase blojsomdb = new BlojsomDataBase();
        blojsomdb.startDB();
        String category_condition = "";
        if(_category.equals("/")){
        	category_condition = "and category_name is null";
        }else{
        	category_condition = "and category_name='"+BlojsomUtils.removeSlashes(_category)+"'";
        }
		int i = blojsomdb.myExecuteUpdate("UPDATE category set blojsom_date=CURRENT_TIMESTAMP WHERE weblog_id='"+blogUser._id+"' "+category_condition);
		if(i <= 0){
			blojsomdb.myExecuteUpdate("INSERT INTO category (weblog_id,category_name,blojsom_date) VALUES ('"+blogUser._id+"','"+BlojsomUtils.removeSlashes(_category)+"',CURRENT_TIMESTAMP)");
		}
		for (Enumeration e = categoryMetaData.keys(); e.hasMoreElements();) {
			String key = e.nextElement().toString();
			Object value = categoryMetaData.get(key);
			key = BlojsomUtils.replace(key, " ", "\\ ");
			key = BlojsomUtils.replace(key,"-","_");
			key = BlojsomUtils.replace(key,".","_");
			if(key.length() > 30){
				key = key.substring(0,29);
			}
			if (value != null && value instanceof List
					&& categoryMetaData.allowMultipleValues) {
				List values = (List) value;
				for ( i = 0; i < values.size(); i++) {
					value = values.get(i);
					// writer.write(key + "=" + value);writer.newLine();
					int j = blojsomdb.myExecuteUpdate("UPDATE category SET " + key + "='" + value + "' WHERE weblog_id='"+blogUser._id+"' "+category_condition);
	        		if(j <= 0){
	        			blojsomdb.myExecuteUpdate("ALTER TABLE category ADD " + key + " varchar2(4000)");
	        			blojsomdb.myExecuteUpdate("UPDATE category SET " + key + "='" + value + "' WHERE weblog_id='"+blogUser._id+"' "+category_condition);
	        		}
				}
			} else {
				value = (value != null) ? value.toString() : "";
				// writer.write(key + "=" + value);writer.newLine();
				i = blojsomdb.myExecuteUpdate("UPDATE category SET " + key + "='" + value + "' WHERE weblog_id='"+blogUser._id+"' "+category_condition);
        		if(i <= 0){
        			blojsomdb.myExecuteUpdate("ALTER TABLE category ADD " + key + " varchar2(4000)");
        			blojsomdb.myExecuteUpdate("UPDATE category SET " + key + "='" + value + "' WHERE weblog_id='"+blogUser._id+"' "+category_condition);
        		}
			}
		}
        blojsomdb.stopDB();
            // fos.close();
        // } catch (IOException e) {
        // _logger.error(e);
        // throw new BlojsomException("Unable to save blog category", e);
        // }

        _logger.debug("Saved blog category: " + blogCategory.toString());
    }

    /**
     * Delete the blog category.
     *
     * @param blogUser {@link BlogUser}
     * @throws BlojsomException If there is an error deleting the category
     * @since blojsom 2.22
     */
    public void delete(BlogUser blogUser) throws BlojsomException {
        _blogUser = blogUser;
        Blog blog = blogUser.getBlog();
        File blogCategory = new File(blog.getBlogHome() + BlojsomUtils.removeSlashes(_category));
        BlojsomDataBase blojsomdb = new BlojsomDataBase();
        blojsomdb.startDB();
        if (blogCategory.equals(blog.getBlogHome())) {
            //if (!BlojsomUtils.deleteDirectory(blogCategory, false)) {
            throw new BlojsomException("Unable to delete blog category directory: " + _category);
            //}
        } else {
			int i = blojsomdb.myExecuteUpdate("DELETE FROM category WHERE weblog_id='"+blogUser._id+"' and category_name='"+BlojsomUtils.removeSlashes(_category)+"'");
			if(i <= 0){
				throw new BlojsomException("Unable to delete blog category directory: " + _category);
			}		
			//if (!BlojsomUtils.deleteDirectory(blogCategory)) {
            //    throw new BlojsomException("Unable to delete blog category directory: " + _category);
            //}
        }
        blojsomdb.stopDB();
        _logger.debug("Deleted blog category: " + blogCategory.toString());
    }

    /**
     * Recursively count the blog entries in a blog directory
     *
     * @param blog          {@link Blog}
     * @param recursive     Set to <code>true</code> if entries in sub-categories should be counted
     * @param rootDirectory
     * @return
     */
    protected int recursiveBlogEntriesCounter(Blog blog, boolean recursive, String rootDirectory) {
        File blogDirectory = new File(rootDirectory);
        File[] directories;
        int totalEntries = 0;

        if (blog.getBlogDirectoryFilter() == null) {
            directories = blogDirectory.listFiles(BlojsomUtils.getDirectoryFilter());
        } else {
            directories = blogDirectory.listFiles(BlojsomUtils.getDirectoryFilter(blog.getBlogDirectoryFilter()));
        }

        File[] entries = blogDirectory.listFiles(BlojsomUtils.getRegularExpressionFilter(blog.getBlogFileExtensions()));
        if (entries == null) {
            totalEntries = 0;
        } else {
            totalEntries = entries.length;
        }

        if (directories != null && recursive) {
            for (int i = 0; i < directories.length; i++) {
                File directory = directories[i];
                return totalEntries + recursiveBlogEntriesCounter(blog, recursive, directory.toString());
            }
        }

        return totalEntries;
    }

    /**
     * Count the number of blog entries in this category. If <code>recursive</code> is true, the method
     * will also count entries in all sub-categories.
     *
     * @param blog      {@link Blog}
     * @param recursive Set to <code>true</code> if entries in sub-categories should be counted
     * @return Number of blog entries in this category
     * @since blojsom 2.22
     */
    public int countBlogEntries(Blog blog, boolean recursive) {
        int totalEntries = recursiveBlogEntriesCounter(blog, recursive, blog.getBlogHome() + _category);

        return totalEntries;
    }

    /**
     * Build a list of blog categories recursively
     *
     * @param blogUser           {@link BlogUser}
     * @param blogDepth          Depth at which the current iteration is running
     * @param blogDirectoryDepth Depth to which the fetcher should stop looking for categories
     * @param blogDirectory      Directory in which the current iteration is running
     * @param categoryList       Dynamic list of categories that gets added to as it explores directories
     */
    protected void recursiveCategoryBuilder(BlogUser blogUser, int blogDepth, int blogDirectoryDepth, String blogDirectory, List categoryList) {
        Blog blog = blogUser.getBlog();
        blogDepth++;
        if (blogDirectoryDepth != BlojsomConstants.INFINITE_BLOG_DEPTH) {
            if (blogDepth == blogDirectoryDepth) {
                return;
            }
        }
        
        BlojsomDataBase blojsomdb = new BlojsomDataBase();
        blojsomdb.startDB();
        ResultSet rs = null;
        try {
        	rs = blojsomdb.myExecuteQuery("SELECT category_name FROM category where weblog_id='"+blogUser.getId()+"' ORDER by category_name");
        	//rs = blojsomdb.myExecuteQuery("SELECT blojsom_name FROM category where weblog_id='"+blogUser.getId()+"' ORDER by category_name");
        	while(rs.next()){
        		String str = rs.getString("category_name");
        		if(str == null){
        			str = "";
        		}
        		//String str = rs.getString("blojsom_name");
        		//String categoryKey = '/' + str;//BlojsomUtils.getBlogCategory(blog.getBlogHome(), str);
                //if (!categoryKey.endsWith("/")) {
                //    categoryKey += "/";
                //}

                BlogCategory blogCategory = new FileBackedBlogCategory();
                blogCategory.setParentCategory(this);        
                blogCategory.setCategory(str);
                blogCategory.setCategoryURL(blog.getBlogURL() + BlojsomUtils.removeInitialSlash(str));


                try {
                    blogCategory.load(blogUser);
                } catch (BlojsomException e) {
                    _logger.error(e);
                }

                if (blogDepth != 0) {
                    categoryList.add(blogCategory);
                }
        	}
        }catch(Exception e){
        	e.printStackTrace();
        }
        blojsomdb.stopDB();
        
        /*
        File blogDir = new File(blogDirectory);
        File[] directories;
        if (blog.getBlogDirectoryFilter() == null) {
            directories = blogDir.listFiles(BlojsomUtils.getDirectoryFilter());
        } else {
            directories = blogDir.listFiles(BlojsomUtils.getDirectoryFilter(blog.getBlogDirectoryFilter()));
        }       

        if (directories == null) {
            return;
        } else {
            for (int i = 0; i < directories.length; i++) {
                File directory = directories[i];
                recursiveCategoryBuilder(blogUser, blogDepth, blogDirectoryDepth, directory.toString(), categoryList);
            }
        }
        */
    }

    /**
     * Return a list of sub-categories under the current category
     *
     * @return {@link java.util.List} of sub-categories as {@link BlogCategory} objects
     * @since blojsom 2.22
     */
    public List getSubcategories() {
        _subcategories = new ArrayList();
        recursiveCategoryBuilder(_blogUser, -1, -1, _blogUser.getBlog().getBlogHome() + BlojsomUtils.removeInitialSlash(_category), _subcategories);

        return _subcategories;
    }

    /**
     * Retrieve a list of sub-categories under the current category up to a certain depth
     *
     * @param depth Depth of sub-categories to retrieve, use -1 for all sub-categories
     * @return @link List} of sub-categories as {@link BlogCategory} objects
     * @since blojsom 2.26
     */
    public List getSubcategories(int depth) {
        _subcategories = new ArrayList();
        if (depth <= -1) {
            depth = -1;
        } else {
            depth += 1;
        }

        recursiveCategoryBuilder(_blogUser, -1, depth, _blogUser.getBlog().getBlogHome() + BlojsomUtils.removeInitialSlash(_category), _subcategories);

        return _subcategories;
    }
}
