/**
 * Copyright (c) 2003-2005, David A. Czarnecki
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * Neither the name of the "David A. Czarnecki" and "blojsom" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "blojsom",
 * nor may "blojsom" appear in their name, without prior written permission of
 * David A. Czarnecki.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.blojsom.plugin.permission;

import org.blojsom.blog.BlogUser;
import org.blojsom.authorization.AuthorizationProvider;
import org.blojsom.BlojsomException;

import java.util.Map;

/**
 * Permission Checker plugin
 *
 * @author David Czarnecki
 * @version $Id: $
 * @since blojsom 2.28
 */
public class PermissionChecker {

    private BlogUser _blogUser;
    private AuthorizationProvider _authorizationProvider;
    private Map _permissionContext;

    /**
     * Create a new permission checker for a given blog
     *
     * @param blogUser {@link BlogUser}
     * @param authorizationProvider {@link AuthorizationProvider}
     * @param permissionContext Context for permissions to be evaulated in (not-used)
     */
    public PermissionChecker(BlogUser blogUser, AuthorizationProvider authorizationProvider, Map permissionContext) {
        _blogUser = blogUser;
        _authorizationProvider = authorizationProvider;
        _permissionContext = permissionContext;
    }

    /**
     * Check permission for a given username and permission
     *
     * @param username Username
     * @param permission Permission to check
     * @return <code>true</code> if <code>username</code> has given <code>permission</code>, <code>false</code> otherwise
     */
    public boolean checkPermission(String username, String permission) {
        try {
            _authorizationProvider.checkPermission(_blogUser, _permissionContext, username, permission);
        } catch (BlojsomException e) {
            return false;
        }

        return true;
    }
}
