/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.ConvertChar;
import base.MyURL;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class Util {
    public static Logger logger = Logger.getLogger("base.util");
    public static ClassLoader AppClassLoader;
    static Map RecycleString_map;

    public static InputStream OpenFile(String fname) throws IOException, FileNotFoundException {
        InputStream result = null;
        try {
            result = new FileInputStream(new File(fname));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        if (result == null && AppClassLoader != null) {
            result = AppClassLoader.getResourceAsStream(fname);
        }
        if (result != null) {
            return result;
        }
        throw new FileNotFoundException(fname + "\u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u3082\u30ea\u30bd\u30fc\u30b9\u306b\u3082\u542b\u307e\u308c\u3066\u3044\u306a\u3044");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageIcon GetImageIconFromJAR(String fname) {
        try {
            ImageIcon imageIcon;
            InputStream i = Util.OpenFile(fname);
            try {
                ByteArrayOutputStream ba = new ByteArrayOutputStream();
                while (true) {
                    byte[] b;
                    int readed;
                    int s;
                    if ((s = i.available()) < 1) {
                        s = 1;
                    }
                    if ((readed = i.read(b = new byte[s])) == -1) {
                        imageIcon = new ImageIcon(ba.toByteArray());
                        Object var7_8 = null;
                        break;
                    }
                    ba.write(b, 0, readed);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                i.close();
                throw throwable;
            }
            i.close();
            return imageIcon;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "GetImageIconFromJAR", e);
            return null;
        }
    }

    public static byte[] toJIS(String src) {
        return ConvertChar.UnicodeToJIS(src, 0, src.length());
    }

    public static byte[] toJIS(String src, int start, int end) {
        return ConvertChar.UnicodeToJIS(src, start, end);
    }

    public static String fromJIS(byte[] src) {
        return ConvertChar.convertForDisplay(ConvertChar.JISToUnicode(src, 0, src.length));
    }

    public static String fromJIS(byte[] src, int start, int end) {
        return ConvertChar.convertForDisplay(ConvertChar.JISToUnicode(src, start, end));
    }

    public static byte[] ByteSubString(byte[] src, int start, int end) {
        if (start < 0 || end < start || end > src.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] dst = new byte[end - start];
        int i = 0;
        while (i < dst.length) {
            dst[i] = src[i + start];
            ++i;
        }
        return dst;
    }

    public static int ByteIndexOf(byte[] src, int c) {
        return Util.ByteIndexOf(src, (byte)c);
    }

    public static int ByteIndexOf(byte[] src, char c) {
        return Util.ByteIndexOf(src, (byte)c);
    }

    public static int ByteIndexOf(byte[] src, byte c) {
        int i = 0;
        while (i < src.length) {
            if (src[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int compareByteArray(byte[] a, int a_start, byte[] b, int b_start) {
        int minlength = a.length - a_start < b.length - b_start ? a.length - a_start : b.length - b_start;
        int i = 0;
        while (i < minlength) {
            if (a[a_start++] != b[b_start++]) {
                return a[a_start - 1] - b[b_start - 1];
            }
            ++i;
        }
        return a.length - a_start - (b.length - b_start);
    }

    public static byte[] AsciiToByteArray(String s) {
        byte[] r = new byte[s.length()];
        int i = 0;
        while (i < r.length) {
            r[i] = (byte)s.charAt(i);
            ++i;
        }
        return r;
    }

    public static String qqByteArray(byte[] src) {
        if (src == null) {
            return "\"(null)\"";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        int i = 0;
        while (i < src.length) {
            int c = src[i];
            if (c < 0) {
                c += 256;
            }
            sb.append("%");
            String Hex = Integer.toHexString(c);
            int j = Hex.length();
            while (j < 2) {
                sb.append('0');
                ++j;
            }
            sb.append(Hex);
            ++i;
        }
        sb.append('\"');
        return new String(sb);
    }

    public static String qq(String src) {
        if (src == null) {
            return "\"(null)\"";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        int i = 0;
        while (i < src.length()) {
            char c = src.charAt(i);
            if ("\"\\".indexOf(c) != -1) {
                sb.append('\\');
                sb.append(c);
            } else if (Character.isISOControl(c)) {
                sb.append("\\u");
                String Hex = Integer.toHexString(c);
                int j = Hex.length();
                while (j < 4) {
                    sb.append('0');
                    ++j;
                }
                sb.append(Hex);
            } else {
                sb.append(c);
            }
            ++i;
        }
        sb.append('\"');
        return new String(sb);
    }

    public static String unquote(String src) {
        if (src == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean escape = false;
        int i = 0;
        while (i < src.length()) {
            char c = src.charAt(i);
            if (c != '\\') {
                if (c != '\"') {
                    sb.append(c);
                }
            } else {
                c = src.charAt(++i);
                switch (c) {
                    default: {
                        sb.append(c);
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'u': {
                        if (++i < src.length() && src.charAt(i) == 'u') {
                            sb.append("\\u");
                            break;
                        }
                        int code = 0;
                        int j = 0;
                        while (j < 4) {
                            int h;
                            if (++i >= src.length()) break;
                            c = src.charAt(i);
                            if (c >= 'a' && c <= 'z') {
                                c = (char)(c - 32);
                            }
                            if ((h = "0123456789ABCDEF".indexOf(c)) == -1) {
                                --i;
                                break;
                            }
                            code = code * 16 + h;
                            ++j;
                        }
                        sb.append(code);
                    }
                }
            }
            ++i;
        }
        return new String(sb);
    }

    public static final boolean isURIAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static final boolean isURIDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static final boolean isScheme(char c) {
        return Util.isURIAlpha(c) || Util.isURIDigit(c) || -1 != "+-.".indexOf(c);
    }

    public static final boolean isURIChar(char c) {
        return Util.isURIAlpha(c) || Util.isURIDigit(c) || -1 != ".%/-_=?&:~!*'();@+$,#~\u203e".indexOf(c);
    }

    public static List URISplitter(String src) {
        Vector<Object> v = new Vector<Object>();
        int start = 0;
        while (start < src.length()) {
            int uristart = start;
            int uriend = 0;
            block1: while (true) {
                if (uristart < src.length() && !Util.isURIAlpha(src.charAt(uristart))) {
                    ++uristart;
                    continue;
                }
                if (uristart >= src.length() - 2) {
                    uristart = src.length();
                    break;
                }
                int colon = src.indexOf(58, uristart + 1);
                if (colon == -1) {
                    uristart = src.length();
                    break;
                }
                int i = uristart + 1;
                while (i < colon) {
                    if (!Util.isScheme(src.charAt(i))) {
                        uristart = i;
                        continue block1;
                    }
                    ++i;
                }
                if (colon + 1 >= src.length() || src.charAt(colon + 1) != '/') {
                    uristart = colon + 1;
                    continue;
                }
                uriend = colon += 2;
                while (uriend < src.length() && Util.isURIChar(src.charAt(uriend))) {
                    ++uriend;
                }
                if (uriend != colon) break;
                uristart = colon;
            }
            if (uristart > start) {
                int n = start;
                start = uristart;
                v.add(src.substring(n, start));
            }
            if (uriend <= uristart) continue;
            start = uriend;
            v.add(new MyURL(src.substring(uristart, start)));
        }
        return v;
    }

    public static String EscapeForFile(String src) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < src.length()) {
            char c = src.charAt(i);
            if (-1 != "\\/:;?*,<>|\"".indexOf(c)) {
                c = '-';
            }
            sb.append(c);
            ++i;
        }
        return new String(sb);
    }

    public static String WildcardToRegEx(String mask) {
        StringBuffer sb = new StringBuffer();
        sb.append('^');
        boolean escape = false;
        int i = 0;
        while (i < mask.length()) {
            char c = mask.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                if (escape) {
                    escape = false;
                    sb.append('\\');
                }
                sb.append(c);
            } else if (escape) {
                escape = false;
                sb.append(c);
            } else if (c == '\\' && i < mask.length() - 1) {
                escape = true;
            } else if (c == '?') {
                sb.append('.');
            } else if (c == '*') {
                sb.append(".*");
            } else {
                sb.append('\\');
                sb.append(c);
            }
            ++i;
        }
        sb.append('$');
        String a = sb.toString();
        logger.finer("wildcard " + mask + " => regex " + a);
        return a;
    }

    private static String to2keta(String t) {
        if (t.length() < 2) {
            return "0" + t;
        }
        return t;
    }

    public static String GetTime(TimeZone tz) {
        return Util.GetTimeStr(tz);
    }

    public static String GetTimeStr(TimeZone tz) {
        return Util.GetTimeStr(new GregorianCalendar(tz));
    }

    public static String GetTimeStr(GregorianCalendar now) {
        String h = Util.to2keta(Integer.toString(now.get(11)));
        String m = Util.to2keta(Integer.toString(now.get(12)));
        return h + ":" + m;
    }

    public static String getDateStr(GregorianCalendar now) {
        String yy = Integer.toString(now.get(1));
        String mm = Util.to2keta(Integer.toString(1 + now.get(2)));
        String dd = Util.to2keta(Integer.toString(now.get(5)));
        return yy + mm + dd;
    }

    public static int SkipDelimitor(String src, String dlm, int start) {
        int i = start;
        while (i < src.length() && -1 != dlm.indexOf(src.charAt(i))) {
            ++i;
        }
        return i;
    }

    public static String JoinStr(String padding, String[] params, int start) {
        StringBuffer sb = new StringBuffer();
        int i = start;
        while (i < params.length) {
            if (i != start) {
                sb.append(padding);
            }
            sb.append(params[i]);
            ++i;
        }
        return new String(sb);
    }

    public static String RecycleString(String key) {
        if (key == null) {
            return null;
        }
        Object o = RecycleString_map.get(key);
        if (o != null) {
            return (String)o;
        }
        RecycleString_map.put(key, key);
        return key;
    }

    static {
        logger.setLevel(null);
        AppClassLoader = null;
        RecycleString_map = new HashMap();
    }
}

