/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.MyStreamTokenizer;
import base.Util;
import bluntirc.App;
import bluntirc.PFM_COLOR;
import bluntirc.PrintFormat;
import bluntirc.PrintFormatMacro;
import irc.IRCMessage;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class PrintFormatMacroManager {
    String[] macro_revlist;
    HashMap macro_map = new HashMap();
    public HashMap config;

    public PrintFormatMacroManager() {
        this.init_macro_revlist();
    }

    private void init_macro_revlist() {
        PrintFormatMacro[] macro_ary = new PrintFormatMacro[]{new PrintFormatMacro("%cs", null, false){

            public String getText(IRCMessage m, Object to) {
                return PrintFormatMacro.getShortName(to);
            }
        }, new PrintFormatMacro("%ce", null, false){

            public String getText(IRCMessage m, Object to) {
                return PrintFormatMacro.getEscapedName(to);
            }
        }, new PrintFormatMacro("%c", null, false){

            public String getText(IRCMessage m, Object to) {
                return PrintFormatMacro.getNormalName(to);
            }
        }, new PrintFormatMacro("%fs", null, false){

            public String getText(IRCMessage m, Object to) {
                return PrintFormatMacro.getShortName(m.log_from);
            }
        }, new PrintFormatMacro("%fe", null, false){

            public String getText(IRCMessage m, Object to) {
                return PrintFormatMacro.getEscapedName(m.log_from);
            }
        }, new PrintFormatMacro("%f", null, false){

            public String getText(IRCMessage m, Object to) {
                return PrintFormatMacro.getNormalName(m.log_from);
            }
        }, new PrintFormatMacro("%ts", null, false){

            public String getText(IRCMessage m, Object to) {
                return PrintFormatMacro.getShortName(m.log_to);
            }
        }, new PrintFormatMacro("%te", null, false){

            public String getText(IRCMessage m, Object to) {
                return PrintFormatMacro.getEscapedName(m.log_to);
            }
        }, new PrintFormatMacro("%t", null, false){

            public String getText(IRCMessage m, Object to) {
                return PrintFormatMacro.getNormalName(m.log_to);
            }
        }, new PrintFormatMacro("%s", null, false){

            public String getText(IRCMessage m, Object to) {
                return m.conn.getListener().getConnectionName(m.conn);
            }
        }, new PrintFormatMacro("%m", null, true){

            public String getText(IRCMessage m, Object to) {
                return m.log_msg;
            }
        }, new PrintFormatMacro("%x", null, false){

            public String getText(IRCMessage m, Object to) {
                return m.cmd;
            }
        }, new PrintFormatMacro("%y", null, false){

            public String getText(IRCMessage m, Object to) {
                return m.params_str;
            }
        }, new PrintFormatMacro("%w", null, false){

            public String getText(IRCMessage m, Object to) {
                return null;
            }

            public int getStyle() {
                return -2;
            }
        }, new PFM_COLOR(null)};
        Vector<String> names = new Vector<String>(macro_ary.length);
        int i = 0;
        while (i < macro_ary.length) {
            this.macro_map.put(macro_ary[i].name(), macro_ary[i]);
            names.add(macro_ary[i].name());
            ++i;
        }
        Collections.sort(names);
        Collections.reverse(names);
        this.macro_revlist = new String[names.size()];
        int i2 = 0;
        while (i2 < this.macro_revlist.length) {
            this.macro_revlist[i2] = (String)names.get(i2);
            ++i2;
        }
    }

    public void readMacroString(PrintFormat pf, String a_text) throws ParseException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        block0: while (i < a_text.length()) {
            Color cl;
            int j;
            int per = a_text.indexOf(37, i);
            if (per == -1) {
                per = a_text.length();
            }
            if (per > i) {
                j = i;
                while (j < per) {
                    sb.append(a_text.charAt(j));
                    ++j;
                }
                i = per;
                continue;
            }
            if (i == a_text.length() - 1 || a_text.charAt(i + 1) == '%') {
                sb.append('%');
                i += 2;
                continue;
            }
            j = 0;
            while (j < this.macro_revlist.length) {
                if (a_text.indexOf(this.macro_revlist[j], i) == i) {
                    if (sb.length() > 0) {
                        pf.macro.add(new String(sb));
                        sb = new StringBuffer();
                    }
                    pf.macro.add(this.macro_map.get(this.macro_revlist[j]));
                    i += this.macro_revlist[j].length();
                    continue block0;
                }
                ++j;
            }
            int[] ir = new int[6];
            if (a_text.length() - i >= 6 && a_text.charAt(i + 1) == '#' && a_text.charAt(i + 5) == ';' && -1 != (ir[0] = Character.digit(a_text.charAt(i + 2), 16)) && -1 != (ir[1] = Character.digit(a_text.charAt(i + 3), 16)) && -1 != (ir[2] = Character.digit(a_text.charAt(i + 4), 16))) {
                if (sb.length() > 0) {
                    pf.macro.add(new String(sb));
                    sb = new StringBuffer();
                }
                cl = new Color((float)ir[0] / 15.0f, (float)ir[1] / 15.0f, (float)ir[2] / 15.0f);
                pf.macro.add(new PFM_COLOR(cl));
                i += 6;
                continue;
            }
            if (a_text.length() - i >= 9 && a_text.charAt(i + 1) == '#' && a_text.charAt(i + 8) == ';' && -1 != (ir[0] = Character.digit(a_text.charAt(i + 2), 16)) && -1 != (ir[1] = Character.digit(a_text.charAt(i + 3), 16)) && -1 != (ir[2] = Character.digit(a_text.charAt(i + 4), 16)) && -1 != (ir[3] = Character.digit(a_text.charAt(i + 5), 16)) && -1 != (ir[4] = Character.digit(a_text.charAt(i + 6), 16)) && -1 != (ir[5] = Character.digit(a_text.charAt(i + 7), 16))) {
                if (sb.length() > 0) {
                    pf.macro.add(new String(sb));
                    sb = new StringBuffer();
                }
                cl = new Color((float)(ir[0] * 16 + ir[1]) / 255.0f, (float)(ir[2] * 16 + ir[3]) / 255.0f, (float)(ir[4] * 16 + ir[5]) / 255.0f);
                pf.macro.add(new PFM_COLOR(cl));
                i += 9;
                continue;
            }
            throw new ParseException("\u30de\u30af\u30ed\u6587\u5b57\u5217\u306e" + i + "\u6587\u5b57\u76ee\u306b\u672a\u5bfe\u5fdc\u306e\u30de\u30af\u30ed%" + a_text.charAt(i + 1), i);
        }
        if (sb.length() > 0) {
            pf.macro.add(new String(sb));
        }
    }

    public void readOptionString(PrintFormat pf, String a_option) throws ParseException {
        int i = 0;
        while (i < a_option.length()) {
            char c = a_option.charAt(i);
            switch (c) {
                default: {
                    throw new ParseException("\u30aa\u30d7\u30b7\u30e7\u30f3\u306e" + i + "\u6587\u5b57\u76ee\u306b\u672a\u5bfe\u5fdc\u306e\u30aa\u30d7\u30b7\u30e7\u30f3 " + c, i);
                }
                case '-': {
                    pf.NoDisp = true;
                    break;
                }
                case 'm': {
                    pf.NoCountMidoku = true;
                    break;
                }
                case 'r': {
                    int start = ++i;
                    while (i < a_option.length() && Character.isDigit(a_option.charAt(i))) {
                        ++i;
                    }
                    pf.RapidRate = i == start ? 60 : Integer.parseInt(a_option.substring(start, i));
                    --i;
                    break;
                }
            }
            ++i;
        }
    }

    public PrintFormat findPrintFormat(String sect, String cmd) {
        if (this.config == null) {
            return null;
        }
        HashMap section = (HashMap)this.config.get(sect);
        if (section == null) {
            App.Log("findPrintFormat: no section:" + sect);
            return null;
        }
        PrintFormat pf = (PrintFormat)section.get(cmd);
        return pf;
    }

    /*
     * Unable to fully structure code
     */
    public HashMap readStream(Reader r, String fname) throws IOException {
        in = new MyStreamTokenizer(r, fname, true);
        result = new HashMap<String, HashMap<String, PrintFormat>>();
        NowTargetName = null;
        NowTarget = null;
        hasError = false;
        block6: while (true) {
            try {
                while (true) {
                    in.skipToStartOfStatement();
                    if (in.ttype == -1) break block6;
                    if (in.ttype != -3 || !in.sval.equals("PrintFormat")) break;
                    in.nextToken();
                    NowTargetName = in.readQuote("PrintFormat\u306e\u5f8c\u306e\u30bb\u30af\u30b7\u30e7\u30f3\u540d");
                    NowTarget = (HashMap<String, PrintFormat>)result.get(NowTargetName);
                    if (NowTarget != null) continue;
                    NowTarget = new HashMap<String, PrintFormat>();
                    result.put(NowTargetName, NowTarget);
                }
                pf = new PrintFormat();
                this.readOptionString(pf, in.readQuote("\u884c\u982d\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u6587\u5b57\u5217\u307e\u305f\u306fPrintFormat\u30bb\u30af\u30b7\u30e7\u30f3\u6307\u5b9a"));
                this.readMacroString(pf, in.readQuote("\u30aa\u30d7\u30b7\u30e7\u30f3\u6587\u5b57\u5217\u306e\u5f8c\u306e\u30de\u30af\u30ed\u6587\u5b57\u5217"));
                if (NowTarget != null) ** GOTO lbl41
                throw new ParseException("\u524d\u306e\u884c\u307e\u3067\u306bPrintFormat\u30bb\u30af\u30b7\u30e7\u30f3\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044", 0);
lbl-1000:
                // 1 sources

                {
                    switch (in.ttype) {
                        case -3: 
                        case 34: 
                        case 39: {
                            NowTarget.put(in.sval, pf);
                            break;
                        }
                        case -2: {
                            NowTarget.put(Integer.toString((int)in.nval), pf);
                            break;
                        }
                        default: {
                            throw in.nomatch("\u30e1\u30c3\u30bb\u30fc\u30b8\u7a2e\u5225");
                        }
                    }
                    in.nextToken();
lbl41:
                    // 2 sources

                    ** while (!in.isEndOfStatement())
                }
lbl42:
                // 1 sources

            }
            catch (ParseException e) {
                hasError = true;
                App.Log(in.errorString(e));
                in.skipToEndOfStatement();
            }
        }
        return hasError != false ? null : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(String fname) {
        try {
            InputStreamReader r;
            block5: {
                boolean bl;
                r = new InputStreamReader(Util.OpenFile(fname), "UTF-8");
                try {
                    HashMap a = this.readStream(r, fname);
                    if (a == null) break block5;
                    this.config = a;
                    App.Log(fname + "\u3092\u8aad\u307f\u7d42\u308f\u308a\u307e\u3057\u305f");
                    bl = true;
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    r.close();
                    throw throwable;
                }
                r.close();
                return bl;
            }
            Object var6_8 = null;
            r.close();
            return false;
        }
        catch (FileNotFoundException e) {
            App.Log(e.getMessage());
            return false;
        }
        catch (IOException e) {
            App.Log(fname + ":" + e.getMessage());
            return false;
        }
    }
}

