/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.MyStreamTokenizer;
import base.TinyWriter;
import base.Util;
import bluntirc.App;
import bluntirc.CTN_Chan;
import bluntirc.CTN_Conn;
import bluntirc.CTN_Priv;
import bluntirc.ConnTreeNode;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;

public class PropertyManager {
    ConnTreeNode context;
    Map map = new HashMap();
    public static final String eol = "\n";
    public static String TargetFileEncode = "UTF-8";
    static boolean saveAtExit = false;

    public PropertyManager(ConnTreeNode c) {
        this.context = c;
    }

    private void setMap(Map t) {
        this.map = t;
    }

    public static Vector parsePropertyName(String name) {
        Vector<String> result = new Vector<String>();
        if (name == null || name.length() == 0) {
            return result;
        }
        int i = 0;
        while (i < name.length()) {
            int start = i;
            while (i < name.length() && name.charAt(i) != '/') {
                ++i;
            }
            result.add(name.substring(start, i));
            ++i;
        }
        return result;
    }

    public Object get(String name) {
        return this.get(PropertyManager.parsePropertyName(name));
    }

    public Object get(Vector param) {
        Map context = this.map;
        int i = 0;
        while (i < param.size()) {
            String v = (String)param.get(i);
            if (context instanceof Map) {
                context = context.get(v);
            } else if (context instanceof List) {
                int index;
                try {
                    index = Integer.parseInt(v);
                }
                catch (Throwable e) {
                    App.Log(v + " \u30ea\u30b9\u30c8\u306e\u30a4\u30f3\u30c7\u30af\u30b9\u306f\u6570\u5024\u3067\u306a\u3044\u3068\u3044\u3051\u307e\u305b\u3093");
                    return null;
                }
                if (index < 0 || index >= ((List)((Object)context)).size()) {
                    App.Log(v + " \u30ea\u30b9\u30c8\u306e\u30a4\u30f3\u30c7\u30af\u30b9\u304c\u7bc4\u56f2\u5916\u3067\u3059");
                    return null;
                }
                context = ((List)((Object)context)).get(index);
            } else {
                App.Log("Map\u3082List\u3082\u3042\u308a\u307e\u305b\u3093 \u30ad\u30fc=" + v);
                return null;
            }
            ++i;
        }
        return context;
    }

    public boolean exists(Vector param) {
        Map context = this.map;
        int i = 0;
        while (i < param.size()) {
            String v = (String)param.get(i);
            if (context instanceof Map) {
                if (!context.containsKey(v)) {
                    return false;
                }
                context = context.get(v);
            } else if (context instanceof List) {
                int index;
                try {
                    index = Integer.parseInt(v);
                }
                catch (Throwable e) {
                    App.Log(v + " \u30ea\u30b9\u30c8\u306e\u30a4\u30f3\u30c7\u30af\u30b9\u306f\u6570\u5024\u3067\u306a\u3044\u3068\u3044\u3051\u307e\u305b\u3093");
                    return false;
                }
                if (index < 0 || index >= ((List)((Object)context)).size()) {
                    App.Log(v + " \u30ea\u30b9\u30c8\u306e\u30a4\u30f3\u30c7\u30af\u30b9\u304c\u7bc4\u56f2\u5916\u3067\u3059");
                    return false;
                }
                context = ((List)((Object)context)).get(index);
            } else {
                App.Log(v + "Map\u3082List\u3082\u3042\u308a\u307e\u305b\u3093");
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean set_(String name, Object value) {
        return this.set_(PropertyManager.parsePropertyName(name), value);
    }

    private boolean set_(Vector param, Object value) {
        Map context = this.map;
        int last = param.size() - 1;
        int i = 0;
        while (i < param.size()) {
            String v = (String)param.get(i);
            if (context instanceof Map) {
                if (i == last) {
                    context.put(v, value);
                    return true;
                }
                context = context.get(v);
            } else if (context instanceof List) {
                int index;
                try {
                    index = Integer.parseInt(v);
                }
                catch (Throwable e) {
                    App.Log(v + " \u30ea\u30b9\u30c8\u306e\u30a4\u30f3\u30c7\u30af\u30b9\u306f\u6570\u5024\u3067\u306a\u3044\u3068\u3044\u3051\u307e\u305b\u3093");
                    return false;
                }
                if (index < 0 || index >= ((List)((Object)context)).size()) {
                    App.Log(v + " \u30ea\u30b9\u30c8\u306e\u30a4\u30f3\u30c7\u30af\u30b9\u304c\u7bc4\u56f2\u5916\u3067\u3059");
                    return false;
                }
                if (i == last) {
                    ((List)((Object)context)).set(index, value);
                    return true;
                }
                context = ((List)((Object)context)).get(index);
            } else {
                App.Log(v + "Map\u3082List\u3082\u3042\u308a\u307e\u305b\u3093");
                return false;
            }
            ++i;
        }
        App.Log("\u30d7\u30ed\u30d1\u30c6\u30a3 '" + PropertyManager.keyToString(param) + "'\u306e\u5909\u66f4\u306f\u3067\u304d\u307e\u305b\u3093 key=");
        return false;
    }

    public static String keyToString(Vector param) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < param.size()) {
            if (i != 0) {
                sb.append('/');
            }
            String s = (String)param.get(i);
            int j = 0;
            while (j < s.length()) {
                char c = s.charAt(j);
                if (c == '/') {
                    c = '?';
                }
                sb.append(c);
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    public void put(String name, Object value) {
        this.set(name, value);
    }

    public void set(String name, Object value) {
        if (this.set_(name, value)) {
            this.context.onPropertyChanged(name, value);
        }
    }

    public void put(Vector param, Object value) {
        this.set(param, value);
    }

    public void set(Vector param, Object value) {
        if (this.set_(param, value)) {
            this.context.onPropertyChanged(PropertyManager.keyToString(param), value);
        }
    }

    public int getInt(String name) {
        return PropertyManager.IntValue(this.get(name));
    }

    public int getInt(String name, int defvalue) {
        try {
            return PropertyManager.IntValue(this.get(name));
        }
        catch (Throwable e) {
            return defvalue;
        }
    }

    public boolean getBoolean(String name, boolean defvalue) {
        try {
            return PropertyManager.BooleanValue(this.get(name));
        }
        catch (Throwable e) {
            return defvalue;
        }
    }

    public List getList(String name) {
        Object o = this.get(name);
        return o != null ? (List)o : new LinkedList();
    }

    public String getString(String name) {
        Object o = this.get(name);
        return o != null ? (String)o : "";
    }

    public String setString(String name, String value) {
        this.set(name, (Object)value);
        return value;
    }

    public boolean setBoolean(String name, boolean value) {
        this.set(name, (Object)Boolean.toString(value));
        return value;
    }

    public int setInt(String name, int value) {
        this.set(name, (Object)Integer.toString(value));
        return value;
    }

    public String setDefaultString(String name, String value) {
        Vector param = PropertyManager.parsePropertyName(name);
        Object o = this.get(param);
        if (o == null) {
            this.set(param, (Object)value);
            return value;
        }
        return PropertyManager.StringValue(o);
    }

    public boolean setDefaultBoolean(String name, boolean value) {
        Vector param = PropertyManager.parsePropertyName(name);
        Object o = this.get(param);
        if (o == null) {
            this.set(param, (Object)("" + value));
            return value;
        }
        return PropertyManager.BooleanValue(o);
    }

    public int setDefaultInt(String name, int value) {
        Vector param = PropertyManager.parsePropertyName(name);
        Object o = this.get(param);
        if (o == null) {
            this.set(param, (Object)("" + value));
            return value;
        }
        try {
            return PropertyManager.IntValue(o);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public Object setDefaultObject(String name, Object value) {
        Vector param = PropertyManager.parsePropertyName(name);
        Object o = this.get(param);
        if (o == null) {
            this.set(param, value);
            return value;
        }
        return o;
    }

    public static boolean BooleanValue(Object value) {
        return Boolean.valueOf((String)value);
    }

    public static int IntValue(Object value) {
        return Integer.parseInt((String)value);
    }

    public static char CharValue(Object value) {
        return ((String)value).charAt(0);
    }

    public static String StringValue(Object value) {
        return (String)value;
    }

    public static void writeIndent(TinyWriter w, int indent) throws IOException {
        int i = 0;
        while (i < indent) {
            w.write(9);
            ++i;
        }
    }

    public static void SaveProperty(TinyWriter w, int indent, Object o) throws IOException {
        if (o instanceof String) {
            w.write("String ");
            w.write(Util.qq((String)o));
            w.write(eol);
            return;
        }
        if (o instanceof List) {
            w.write("List ");
            List list = (List)o;
            w.write(Integer.toString(list.size()));
            w.write(eol);
            ++indent;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                PropertyManager.writeIndent(w, indent);
                PropertyManager.SaveProperty(w, indent, it.next());
            }
            --indent;
            return;
        }
        if (o instanceof Map) {
            w.write("Map ");
            Map map = (Map)o;
            w.write(Integer.toString(map.size()));
            w.write(eol);
            ++indent;
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                PropertyManager.writeIndent(w, indent);
                w.write(Util.qq((String)me.getKey()));
                w.write(" ");
                PropertyManager.SaveProperty(w, indent, me.getValue());
            }
            --indent;
            return;
        }
        w.write("null");
        w.write(eol);
    }

    public static Object LoadProperty(MyStreamTokenizer in) throws ParseException, IOException {
        String type = in.readWord("\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u578b");
        if (type.equals("null")) {
            return null;
        }
        if (type.equals("String")) {
            return in.readQuote("\u6587\u5b57\u5217");
        }
        if (type.equals("List") || type.equals("LinkedList")) {
            LinkedList<Object> list = new LinkedList<Object>();
            int count = in.readInt("\u30ea\u30b9\u30c8\u306e\u8981\u7d20\u6570");
            int i = 0;
            while (i < count) {
                list.add(PropertyManager.LoadProperty(in));
                ++i;
            }
            return list;
        }
        if (type.equals("Map") || type.equals("TreeMap")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int count = in.readInt("\u30de\u30c3\u30d7\u306e\u8981\u7d20\u6570");
            int i = 0;
            while (i < count) {
                String key = in.readQuote("\u30de\u30c3\u30d7\u306e\u30ad\u30fc");
                map.put(key, PropertyManager.LoadProperty(in));
                ++i;
            }
            return map;
        }
        throw in.nomatch("\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u578b");
    }

    private static void SaveConnTreeNode(TinyWriter w, ConnTreeNode node) throws IOException {
        node.onHashSave();
        String type = null;
        type = node instanceof App ? "App" : (node instanceof CTN_Conn ? "Conn" : (node instanceof CTN_Chan ? "Chan" : (node instanceof CTN_Priv ? "Priv" : node.getClass().getName())));
        w.write(type);
        w.write(32);
        List l = node.getCreateParam();
        w.write(Integer.toString(l.size()));
        w.write(32);
        Iterator it = l.iterator();
        while (it.hasNext()) {
            w.write(Util.qq((String)it.next()));
            w.write(32);
        }
        w.write(Integer.toString(node.getChildCount()));
        w.write(eol);
        PropertyManager.SaveProperty(w, 0, node.property.map);
        Iterator it2 = node.child.iterator();
        while (it2.hasNext()) {
            PropertyManager.SaveConnTreeNode(w, (ConnTreeNode)it2.next());
        }
    }

    private static void LoadConnTreeNode(MyStreamTokenizer in, ConnTreeNode parent) throws ParseException, IOException {
        ConnTreeNode node;
        String type = in.readWord("\u30ce\u30fc\u30c9\u306e\u7a2e\u985e");
        int CreateParamCount = in.readInt("\u4f5c\u6210\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u8981\u7d20\u6570");
        Vector<String> v = new Vector<String>(CreateParamCount);
        int i = 0;
        while (i < CreateParamCount) {
            v.add(in.readQuote("\u4f5c\u6210\u30d1\u30e9\u30e1\u30fc\u30bf" + i));
            ++i;
        }
        int child_count = in.readInt("\u5b50\u30ce\u30fc\u30c9\u306e\u6570");
        if (type.equals("App")) {
            node = App.createNode(parent, v);
        } else if (type.equals("Conn")) {
            node = CTN_Conn.createNode(parent, v);
        } else if (type.equals("Chan")) {
            node = CTN_Chan.createNode(parent, v);
        } else if (type.equals("Priv")) {
            node = CTN_Priv.createNode(parent, v);
        } else {
            throw in.nomatch("\u30ce\u30fc\u30c9\u306e\u7a2e\u985e");
        }
        node.property.setMap((Map)PropertyManager.LoadProperty(in));
        int i2 = 0;
        while (i2 < child_count) {
            PropertyManager.LoadConnTreeNode(in, node);
            ++i2;
        }
        node.onHashLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void preloadIniFile(ConnTreeNode root, String TargetFile) {
        try {
            InputStreamReader r = new InputStreamReader(Util.OpenFile(TargetFile), TargetFileEncode);
            try {
                String fname = TargetFile;
                MyStreamTokenizer in = new MyStreamTokenizer(r, TargetFile, true, true);
                try {
                    String type = in.readWord("\u30ce\u30fc\u30c9\u306e\u578b");
                    int CreateParamCount = in.readInt("\u4f5c\u6210\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u8981\u7d20\u6570");
                    Vector<String> v = new Vector<String>(CreateParamCount);
                    int i = 0;
                    while (true) {
                        if (i >= CreateParamCount) {
                            int child_count = in.readInt("\u5b50\u30ce\u30fc\u30c9\u306e\u6570");
                            root.property.setMap((Map)PropertyManager.LoadProperty(in));
                            break;
                        }
                        v.add(in.readQuote("\u4f5c\u6210\u30d1\u30e9\u30e1\u30fc\u30bf" + i));
                        ++i;
                    }
                }
                catch (ParseException e) {
                    App.Log(in.errorString(e));
                    Object var11_14 = null;
                    ((Reader)r).close();
                    return;
                }
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                ((Reader)r).close();
                throw throwable;
            }
            ((Reader)r).close();
            return;
        }
        catch (FileNotFoundException e) {
            App.Log(e.getMessage());
            saveAtExit = true;
            return;
        }
        catch (IOException e) {
            App.Log(TargetFile + ":" + e.toString() + " " + e.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(ConnTreeNode root, String TargetFile) {
        saveAtExit = false;
        try {
            InputStreamReader r = new InputStreamReader(Util.OpenFile(TargetFile), TargetFileEncode);
            try {
                try {
                    MyStreamTokenizer in = new MyStreamTokenizer(r, TargetFile, true, true);
                    PropertyManager.LoadConnTreeNode(in, root);
                    App.Log(TargetFile + "\u3092\u8aad\u307f\u7d42\u308f\u308a\u307e\u3057\u305f");
                    saveAtExit = true;
                    Object var5_7 = null;
                }
                catch (ParseException e) {
                    App.Log(e.getMessage());
                    Object var5_8 = null;
                    ((Reader)r).close();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                ((Reader)r).close();
                throw throwable;
            }
            ((Reader)r).close();
            return;
        }
        catch (FileNotFoundException e) {
            App.Log(e.getMessage());
            saveAtExit = true;
            return;
        }
        catch (IOException e) {
            App.Log(TargetFile + ":" + e.toString() + " " + e.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(ConnTreeNode root, String TargetFile) {
        if (!saveAtExit) {
            return;
        }
        try {
            TinyWriter w = new TinyWriter((OutputStream)new FileOutputStream(TargetFile), TargetFileEncode);
            try {
                w.println("// " + TargetFileEncode + "\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306f" + TargetFileEncode + "\u3067\u66f8\u304b\u308c\u3066\u3044\u307e\u3059\u3002");
                PropertyManager.SaveConnTreeNode(w, root);
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                w.close();
                throw throwable;
            }
            w.close();
            {
            }
        }
        catch (Exception e) {
            App.logger.log(Level.SEVERE, TargetFile, e);
            App.Log(TargetFile + ":" + e.toString() + " " + e.getMessage());
        }
    }

    public static void resetSaveFlag() {
        saveAtExit = true;
    }
}

