/*
 * Decompiled with CFR 0.152.
 */
package buffer;

import buffer.PackedStyle;
import buffer.StyleID;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.List;

public class PackedLineWriter
extends PackedStyle {
    public CharArrayWriter text = new CharArrayWriter();
    public ByteArrayOutputStream style = new ByteArrayOutputStream();

    public PackedLineWriter(StyleID sid, String basestyle_name) {
        super(sid, basestyle_name);
    }

    public void appendStyle(PackedStyle newstyle) {
        if (newstyle == null) {
            return;
        }
        if (this.baseid != newstyle.baseid) {
            this.baseid = newstyle.baseid;
            if (this.baseid == 0) {
                System.err.println("PackedLineWriter : bad baseid 0!");
                this.style.write(129);
            } else {
                this.style.write(128 + (this.baseid & 0x3F));
            }
        }
        int i = 0;
        while (i < this.optionid.length) {
            if (this.optionid[i] != newstyle.optionid[i]) {
                this.optionid[i] = newstyle.optionid[i];
                if (this.optionid[i] != -1) {
                    this.style.write(208 + i);
                    this.style.write(this.optionid[i]);
                } else {
                    this.style.write(224 + i);
                }
            }
            ++i;
        }
    }

    public void appendSaveIndent(PackedStyle newstyle) {
        this.appendStyle(newstyle);
        this.style.write(207);
    }

    public void appendText(List list, int start, int last, PackedStyle newstyle) {
        int length = this.text.size();
        try {
            int i = start;
            while (i <= last) {
                this.text.write((String)list.get(i));
                ++i;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        length = this.text.size() - length;
        if (length < 0) {
            return;
        }
        this.appendStyle(newstyle);
        while (length >= 128) {
            this.style.write(128);
            length -= 128;
        }
        this.style.write(length);
    }
}

