/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCChannelMember;
import irc.IRCChannelName;
import irc.IRCChannelNameOrPrefix;
import irc.IRCConnection;
import irc.IRCMessage;
import irc.IRCNicknameHash;
import irc.IRCUser;
import java.util.Iterator;
import java.util.Vector;

public class IRCChannel
implements IRCChannelNameOrPrefix {
    public Object Extra;
    protected IRCChannelName name;
    protected IRCUser private_user;
    private String Topic = "";
    private String mode = "";
    protected boolean m_isInMyself = false;
    private IRCNicknameHash members = new IRCNicknameHash();

    public IRCChannelName getCName() {
        return this.name;
    }

    public void setCName(IRCChannelName c) {
        this.name = c;
    }

    public String getName() {
        return this.name.getName();
    }

    public String getShortName() {
        return this.name.getShortName();
    }

    public String getPrintableName() {
        return this.name.getPrintableName();
    }

    public String getEscapedName() {
        return this.name.getEscapedName();
    }

    public byte[] getLowerBytes() {
        return this.name.getLowBytes();
    }

    public byte[] getRawBytes() {
        return this.name.getRawBytes();
    }

    public boolean isChannel() {
        return this.private_user == null;
    }

    public IRCUser getPrivateUser() {
        return this.private_user;
    }

    public String getTopic() {
        return this.Topic;
    }

    public void setTopic(String s) {
        this.Topic = s;
    }

    public String getChannelMode() {
        return this.mode;
    }

    public void setChannelModeString(String s) {
        this.mode = s;
    }

    public boolean isInMyself() {
        return this.m_isInMyself;
    }

    private IRCChannel(IRCConnection conn, IRCChannelName a) {
        this.name = a;
        if (!this.name.isChannelName()) {
            this.private_user = conn.findUser(this.name.getRawBytes());
        }
    }

    public static IRCChannel createByIRCConnection(IRCConnection conn, IRCChannelName name) {
        return new IRCChannel(conn, name);
    }

    public boolean OnJoinMyself() {
        if (this.m_isInMyself) {
            return false;
        }
        this.m_isInMyself = true;
        return true;
    }

    public boolean OnPartMyself() {
        if (!this.m_isInMyself) {
            return false;
        }
        this.m_isInMyself = false;
        return true;
    }

    public int getUserCount() {
        return this.members.size();
    }

    public IRCChannelMember findUser(IRCUser who) {
        return (IRCChannelMember)this.members.get(who);
    }

    public IRCChannelMember findUser(byte[] key) {
        return (IRCChannelMember)this.members.get(key);
    }

    public boolean isIn(IRCUser who) {
        return this.findUser(who) != null;
    }

    void AddUser(IRCMessage m, IRCUser who, String mode) {
        IRCChannelMember member = (IRCChannelMember)this.members.get(who);
        byte[] old_name = null;
        if (member != null) {
            old_name = member.getUser().getNickBytes();
            this.members.remove(old_name);
        }
        member = new IRCChannelMember(who, mode);
        this.members.put(who, (Object)member);
        m.conn.getListener().ChangeUserInfo(m.conn, this, old_name, member);
    }

    boolean RemoveUser(IRCMessage m, IRCUser who) {
        IRCChannelMember member = (IRCChannelMember)this.members.get(who);
        if (member == null) {
            return false;
        }
        this.members.remove(who);
        m.conn.getListener().RemoveUserList(m.conn, this, member);
        return true;
    }

    void RemoveUserAll(IRCConnection conn) {
        Vector list = new Vector(this.members.size());
        Iterator it = this.members.values().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Iterator it2 = list.iterator();
        while (it2.hasNext()) {
            IRCChannelMember member = (IRCChannelMember)it2.next();
            this.members.remove(member.getUser());
            conn.getListener().RemoveUserList(conn, this, member);
        }
        this.members.clear();
    }

    boolean OnWhoReply(IRCMessage m, IRCUser key) {
        if (this.isChannel()) {
            return null != this.findUser(key);
        }
        return this.private_user == key;
    }

    boolean OnChangeNick(IRCMessage m, byte[] fromnick, IRCUser to, boolean isMyself) {
        if (this.isChannel()) {
            IRCChannelMember member = (IRCChannelMember)this.members.get(to);
            if (member == null) {
                member = (IRCChannelMember)this.members.get(fromnick);
            }
            if (member == null) {
                return false;
            }
            this.members.remove(to);
            this.members.remove(fromnick);
            member = new IRCChannelMember(to, member.OpString());
            this.members.put(to, (Object)member);
            m.addContext(this);
            m.conn.getListener().ChangeUserInfo(m.conn, this, fromnick, member);
            return true;
        }
        if (isMyself) {
            m.addContext(this);
            m.conn.getListener().ChangeUserInfo(m.conn, this, fromnick, new IRCChannelMember(to, ""));
            return true;
        }
        if (this.private_user == to) {
            IRCChannelName old_cname = this.name;
            this.name = new IRCChannelName(this.private_user.getNickBytes());
            m.conn.ChangeChannelName(old_cname, this);
            m.addContext(this);
            m.conn.getListener().ChangeUserInfo(m.conn, this, fromnick, null);
            return true;
        }
        return false;
    }

    void addMemberMode(IRCMessage m, IRCUser who, char mode) {
        IRCChannelMember member = this.findUser(who);
        if (member != null && member.addOp(mode)) {
            m.conn.getListener().ChangeUserInfo(m.conn, this, who.getNickBytes(), member);
        }
    }

    void removeMemberMode(IRCMessage m, IRCUser who, char mode) {
        IRCChannelMember member = this.findUser(who);
        if (member != null && member.removeOp(mode)) {
            m.conn.getListener().ChangeUserInfo(m.conn, this, who.getNickBytes(), member);
        }
    }

    public boolean hasOp(IRCUser who) {
        return this.hasOp(who, '@');
    }

    public boolean hasOp(IRCUser who, char type) {
        IRCChannelMember member = this.findUser(who);
        return member != null && member.hasOp(type);
    }

    void FixChannelMode(IRCMessage m, byte[] str) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length) {
            int c = str[i] & 0xFF;
            if (c > 32 && c < 127) {
                sb.append((char)c);
            }
            ++i;
        }
        this.mode = new String(sb);
        m.conn.getListener().SetChannelMode(m, this);
    }

    void SetChannelMode(IRCMessage m, char toggle, char c) {
        if (toggle == '+') {
            if (-1 != this.mode.indexOf(c)) {
                return;
            }
            this.mode = this.mode + c;
            m.conn.getListener().SetChannelMode(m, this);
            return;
        }
        if (toggle == '-') {
            int pos = this.mode.indexOf(c);
            if (pos == -1) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.mode.length()) {
                if (this.mode.charAt(i) != c) {
                    sb.append(this.mode.charAt(i));
                }
                ++i;
            }
            this.mode = new String(sb);
            m.conn.getListener().SetChannelMode(m, this);
        }
    }

    void SetChannelMode(IRCMessage m, char toggle, char c, IRCUser target) {
        if (toggle == '+' && c == 'o') {
            this.addMemberMode(m, target, '@');
            return;
        }
        if (toggle == '+' && c == 'v') {
            this.addMemberMode(m, target, '+');
            return;
        }
        if (toggle == '-' && c == 'o') {
            this.removeMemberMode(m, target, '@');
            return;
        }
        if (toggle == '-' && c == 'v') {
            this.removeMemberMode(m, target, '+');
            return;
        }
        switch (c) {
            case 'k': 
            case 'l': {
                this.SetChannelMode(m, toggle, c);
                return;
            }
        }
    }
}

