/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.InnerClassesEntry;

public class InnerClassesAttribute
extends AttributeInfo {
    private List classes;

    public InnerClassesAttribute(ConstantPool cp) {
        super(cp, "InnerClasses");
        this.length = 2;
        this.classes = new LinkedList();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.nameIndex);
        out.writeInt(this.length);
        out.writeShort(this.classes.size());
        Iterator it = this.classes.iterator();
        while (it.hasNext()) {
            ((InnerClassesEntry)it.next()).write(out);
        }
    }

    public InnerClassesEntry addInnerClassesEntry() {
        InnerClassesEntry ice = new InnerClassesEntry(this.constantPool);
        this.classes.add(ice);
        this.length += 8;
        return ice;
    }
}

