/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.interpreter.InterpreterUtilities;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.MethodModificationError;
import koala.dynamicjava.interpreter.context.NoSuchFunctionException;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.modifier.ArrayModifier;
import koala.dynamicjava.interpreter.modifier.InvalidModifier;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnaryExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.Constants;

public class TypeChecker
extends VisitorObject {
    private Context context;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Cloneable;

    public TypeChecker(Context ctx) {
        this.context = ctx;
    }

    public Object visit(PackageDeclaration node) {
        this.context.setCurrentPackage(node.getName());
        return null;
    }

    public Object visit(ImportDeclaration node) {
        if (node.isPackage()) {
            this.context.declarePackageImport(node.getName());
        } else {
            try {
                this.context.declareClassImport(node.getName());
            }
            catch (ClassNotFoundException e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
        }
        return null;
    }

    public Object visit(WhileStatement node) {
        if (node.getCondition().acceptVisitor(this) != Boolean.TYPE) {
            throw new ExecutionError("condition.type", node);
        }
        node.getBody().acceptVisitor(this);
        return null;
    }

    public Object visit(ForStatement node) {
        Expression cond;
        this.context.enterScope();
        List l = node.getInitialization();
        if (l != null) {
            this.checkList(l);
        }
        if ((cond = node.getCondition()) != null && cond.acceptVisitor(this) != Boolean.TYPE) {
            throw new ExecutionError("condition.type", node);
        }
        l = node.getUpdate();
        if (l != null) {
            this.checkList(l);
        }
        node.getBody().acceptVisitor(this);
        node.setProperty("variables", this.context.leaveScope());
        return null;
    }

    public Object visit(DoStatement node) {
        node.getBody().acceptVisitor(this);
        if (node.getCondition().acceptVisitor(this) != Boolean.TYPE) {
            throw new ExecutionError("condition.type", node);
        }
        return null;
    }

    public Object visit(SwitchStatement node) {
        Class c = (Class)node.getSelector().acceptVisitor(this);
        if (c != Character.TYPE && c != Byte.TYPE && c != Short.TYPE && c != Integer.TYPE) {
            node.setProperty("errorStrings", new String[]{c.getName()});
            throw new ExecutionError("selector.type", node);
        }
        Iterator it = node.getBindings().iterator();
        while (it.hasNext()) {
            SwitchBlock sb = (SwitchBlock)it.next();
            sb.acceptVisitor(this);
            Expression exp = sb.getExpression();
            if (exp == null) continue;
            Class lc = NodeProperties.getType(exp);
            if (lc != Character.TYPE && lc != Byte.TYPE && lc != Short.TYPE && lc != Integer.TYPE) {
                node.setProperty("errorStrings", new String[]{lc.getName()});
                throw new ExecutionError("switch.label.type", node);
            }
            if (c == lc) continue;
            Number n = null;
            if (exp.hasProperty("value")) {
                Object cst = exp.getProperty("value");
                n = lc == Character.TYPE ? (Number)new Integer(((Character)cst).charValue()) : (Number)((Number)cst);
            }
            if (c == Byte.TYPE) {
                if (exp.hasProperty("value")) {
                    if (n.byteValue() == n.intValue()) continue;
                    node.setProperty("errorStrings", new String[]{c.getName()});
                    throw new ExecutionError("switch.label.type", node);
                }
                throw new ExecutionError("switch.label.type", node);
            }
            if (c != Short.TYPE && c != Character.TYPE) continue;
            if (exp.hasProperty("value")) {
                if (n.shortValue() == n.intValue()) continue;
                node.setProperty("errorStrings", new String[]{c.getName()});
                throw new ExecutionError("switch.label.type", node);
            }
            if (lc != Integer.TYPE) continue;
            node.setProperty("errorStrings", new String[]{c.getName()});
            throw new ExecutionError("switch.label.type", node);
        }
        return null;
    }

    public Object visit(SwitchBlock node) {
        List l;
        Expression exp = node.getExpression();
        if (exp != null) {
            exp.acceptVisitor(this);
        }
        if ((l = node.getStatements()) != null) {
            this.checkList(l);
        }
        return null;
    }

    public Object visit(LabeledStatement node) {
        node.getStatement().acceptVisitor(this);
        return null;
    }

    public Object visit(TryStatement node) {
        node.getTryBlock().acceptVisitor(this);
        Iterator it = node.getCatchStatements().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        Node n = node.getFinallyBlock();
        if (n != null) {
            n.acceptVisitor(this);
        }
        return null;
    }

    public Object visit(CatchStatement node) {
        this.context.enterScope();
        Class c = (Class)node.getException().acceptVisitor(this);
        if (!(class$java$lang$Throwable == null ? (class$java$lang$Throwable = TypeChecker.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(c)) {
            node.setProperty("errorStrings", new String[]{c.getName()});
            throw new ExecutionError("catch.type", node);
        }
        node.getBlock().acceptVisitor(this);
        this.context.leaveScope();
        node.setProperty("type", c);
        return null;
    }

    public Object visit(ThrowStatement node) {
        Class c;
        if (!(class$java$lang$Throwable == null ? (class$java$lang$Throwable = TypeChecker.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(c = (Class)node.getExpression().acceptVisitor(this))) {
            node.setProperty("errorStrings", new String[]{c.getName()});
            throw new ExecutionError("throw.type", node);
        }
        return null;
    }

    public Object visit(ReturnStatement node) {
        Expression e = node.getExpression();
        if (e != null) {
            e.acceptVisitor(this);
        }
        return null;
    }

    public Object visit(IfThenStatement node) {
        if (node.getCondition().acceptVisitor(this) != Boolean.TYPE) {
            throw new ExecutionError("condition.type", node);
        }
        node.getThenStatement().acceptVisitor(this);
        return null;
    }

    public Object visit(IfThenElseStatement node) {
        if (node.getCondition().acceptVisitor(this) != Boolean.TYPE) {
            throw new ExecutionError("condition.type", node);
        }
        node.getThenStatement().acceptVisitor(this);
        node.getElseStatement().acceptVisitor(this);
        return null;
    }

    public Object visit(SynchronizedStatement node) {
        if (((Class)node.getLock().acceptVisitor(this)).isPrimitive()) {
            throw new ExecutionError("lock.type", node);
        }
        node.getBody().acceptVisitor(this);
        return null;
    }

    public Object visit(Literal node) {
        Class c = node.getType();
        node.setProperty("value", node.getValue());
        node.setProperty("type", c);
        return c;
    }

    public Object visit(VariableDeclaration node) {
        Class lc = (Class)node.getType().acceptVisitor(this);
        if (node.isFinal()) {
            this.context.defineConstant(node.getName(), lc);
        } else {
            this.context.define(node.getName(), lc);
        }
        Expression init = node.getInitializer();
        if (init != null) {
            Class rc = (Class)init.acceptVisitor(this);
            TypeChecker.checkAssignmentStaticRules(lc, rc, node, init);
        }
        return null;
    }

    public Object visit(BlockStatement node) {
        this.context.enterScope();
        this.checkList(node.getStatements());
        node.setProperty("variables", this.context.leaveScope());
        return null;
    }

    public Object visit(ObjectFieldAccess node) {
        Class<?> c = (Class<?>)node.getExpression().acceptVisitor(this);
        if (!c.isArray()) {
            Field f = null;
            try {
                f = this.context.getField(c, node.getFieldName());
            }
            catch (Exception e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
            node.setProperty("field", f);
            c = f.getType();
            node.setProperty("type", c);
            node.setProperty("modifier", this.context.getModifier(node));
            return c;
        }
        if (!node.getFieldName().equals("length")) {
            String s0 = "length";
            String s1 = c.getComponentType().getName() + " array";
            node.setProperty("errorStrings", new String[]{s0, s1});
            throw new ExecutionError("no.such.field", node);
        }
        node.setProperty("type", Integer.TYPE);
        node.setProperty("modifier", new InvalidModifier(node));
        return Integer.TYPE;
    }

    public Object visit(SuperFieldAccess node) {
        Field f = null;
        try {
            f = this.context.getSuperField(node, node.getFieldName());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
        node.setProperty("field", f);
        Class<?> c = f.getType();
        node.setProperty("type", c);
        node.setProperty("modifier", this.context.getModifier(node));
        return c;
    }

    public Object visit(StaticFieldAccess node) {
        Class<?> c = (Class<?>)node.getFieldType().acceptVisitor(this);
        Field f = null;
        try {
            f = this.context.getField(c, node.getFieldName());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
        node.setProperty("field", f);
        c = f.getType();
        node.setProperty("type", c);
        node.setProperty("modifier", this.context.getModifier(node));
        return c;
    }

    public Object visit(ObjectMethodCall node) {
        Expression exp = node.getExpression();
        Class<?> c = (Class<?>)exp.acceptVisitor(this);
        String mn = node.getMethodName();
        if (!c.isArray() || c.isArray() && !mn.equals("clone")) {
            List args = node.getArguments();
            Class[] cargs = Constants.EMPTY_CLASS_ARRAY;
            if (args != null) {
                cargs = new Class[args.size()];
                Iterator it = args.iterator();
                int i = 0;
                while (it.hasNext()) {
                    cargs[i++] = (Class)((Node)it.next()).acceptVisitor(this);
                }
            }
            Method m = null;
            try {
                m = this.context.lookupMethod(exp, mn, cargs);
            }
            catch (NoSuchMethodException e) {
                String s = c.getName();
                node.setProperty("errorStrings", new String[]{mn, s});
                throw new ExecutionError("no.such.method", node);
            }
            catch (MethodModificationError e) {
                Expression expr = e.getExpression();
                expr.acceptVisitor(this);
                node.setExpression(expr);
                m = e.getMethod();
            }
            node.setProperty("method", m);
            c = m.getReturnType();
            node.setProperty("type", c);
            return c;
        }
        if (!mn.equals("clone") || node.getArguments() != null) {
            String s0 = "clone";
            String s1 = c.getComponentType().getName() + " array";
            node.setProperty("errorStrings", new String[]{s0, s1});
            throw new ExecutionError("no.such.method", node);
        }
        c = class$java$lang$Object == null ? (class$java$lang$Object = TypeChecker.class$("java.lang.Object")) : class$java$lang$Object;
        node.setProperty("type", c);
        return c;
    }

    public Object visit(MethodDeclaration node) {
        this.context.defineFunction(node);
        node.setProperty("type", node.getReturnType().acceptVisitor(this));
        node.setProperty("functions", this.context.getFunctions());
        node.setProperty("importationManager", this.context.getImportationManager().clone());
        this.context.enterScope();
        this.checkList(node.getParameters());
        this.context.leaveScope();
        return null;
    }

    public Object visit(FunctionCall node) {
        List args = node.getArguments();
        Class[] cargs = Constants.EMPTY_CLASS_ARRAY;
        if (args != null) {
            cargs = new Class[args.size()];
            Iterator it = args.iterator();
            int i = 0;
            while (it.hasNext()) {
                cargs[i++] = (Class)((Node)it.next()).acceptVisitor(this);
            }
        }
        MethodDeclaration f = null;
        try {
            f = this.context.lookupFunction(node.getMethodName(), cargs);
        }
        catch (NoSuchFunctionException e) {
            String s = node.getMethodName();
            node.setProperty("errorStrings", new String[]{s});
            throw new ExecutionError("no.such.function", node);
        }
        node.setProperty("function", f);
        Class c = NodeProperties.getType(f);
        node.setProperty("type", c);
        return c;
    }

    public Object visit(SuperMethodCall node) {
        List args = node.getArguments();
        Class[] pt = Constants.EMPTY_CLASS_ARRAY;
        if (args != null) {
            pt = new Class[args.size()];
            Iterator it = args.iterator();
            int i = 0;
            while (it.hasNext()) {
                pt[i++] = (Class)((Node)it.next()).acceptVisitor(this);
            }
        }
        Method m = null;
        try {
            m = this.context.lookupSuperMethod(node, node.getMethodName(), pt);
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
        node.setProperty("method", m);
        Class<?> c = m.getReturnType();
        node.setProperty("type", c);
        return c;
    }

    public Object visit(StaticMethodCall node) {
        List args = node.getArguments();
        Class[] cargs = Constants.EMPTY_CLASS_ARRAY;
        if (args != null) {
            cargs = new Class[args.size()];
            Iterator it = args.iterator();
            int i = 0;
            while (it.hasNext()) {
                cargs[i++] = (Class)((Node)it.next()).acceptVisitor(this);
            }
        }
        Method m = null;
        ReferenceType n = node.getMethodType();
        Class<?> c = (Class<?>)((Node)n).acceptVisitor(this);
        try {
            m = this.context.lookupMethod(n, node.getMethodName(), cargs);
        }
        catch (NoSuchMethodException e) {
            String s0 = node.getMethodName();
            String s1 = c.getName();
            node.setProperty("errorStrings", new String[]{s0, s1});
            throw new ExecutionError("no.such.method", node);
        }
        node.setProperty("method", m);
        c = m.getReturnType();
        node.setProperty("type", c);
        return c;
    }

    public Object visit(SimpleAssignExpression node) {
        String var;
        Expression left = node.getLeftExpression();
        Expression right = node.getRightExpression();
        Class rc = (Class)right.acceptVisitor(this);
        if (left instanceof QualifiedName && !this.context.exists(var = ((QualifiedName)left).getRepresentation())) {
            Class clazz = rc == null ? (class$java$lang$Object == null ? (class$java$lang$Object = TypeChecker.class$("java.lang.Object")) : class$java$lang$Object) : rc;
            this.context.define(var, clazz);
        }
        Class lc = (Class)left.acceptVisitor(this);
        if (!left.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        TypeChecker.checkAssignmentStaticRules(lc, rc, node, right);
        node.setProperty("type", lc);
        return lc;
    }

    public Object visit(QualifiedName node) {
        String var = node.getRepresentation();
        Class c = (Class)this.context.get(var);
        node.setProperty("type", c);
        node.setProperty("modifier", this.context.getModifier(node));
        return c;
    }

    public Object visit(SimpleAllocation node) {
        Type type = node.getCreationType();
        Class c = (Class)type.acceptVisitor(this);
        List args = node.getArguments();
        Class[] cargs = Constants.EMPTY_CLASS_ARRAY;
        if (args != null) {
            cargs = new Class[args.size()];
            ListIterator it = args.listIterator();
            int i = 0;
            while (it.hasNext()) {
                cargs[i++] = (Class)((Node)it.next()).acceptVisitor(this);
            }
        }
        return this.context.setProperties(node, c, cargs);
    }

    public Object visit(InnerAllocation node) {
        Class ec = (Class)node.getExpression().acceptVisitor(this);
        Type type = node.getCreationType();
        if (!(type instanceof ReferenceType)) {
            throw new ExecutionError("allocation.type", node);
        }
        ReferenceType rt = (ReferenceType)type;
        rt.setRepresentation(ec.getName() + "$" + rt.getRepresentation());
        Class c = (Class)type.acceptVisitor(this);
        Class dc = InterpreterUtilities.getDeclaringClass(c);
        List args = node.getArguments();
        Class[] cargs = null;
        if (dc != null && dc.isAssignableFrom(ec)) {
            if (args != null) {
                cargs = new Class[args.size() + 1];
                cargs[0] = ec;
                ListIterator it = args.listIterator();
                int i = 1;
                while (it.hasNext()) {
                    cargs[i++] = (Class)((Node)it.next()).acceptVisitor(this);
                }
            } else {
                cargs = new Class[]{ec};
            }
        } else {
            throw new ExecutionError("allocation.type", node);
        }
        Constructor cons = null;
        try {
            cons = this.context.lookupConstructor(c, cargs);
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
        node.setProperty("type", c);
        node.setProperty("constructor", cons);
        return c;
    }

    public Object visit(ClassAllocation node) {
        if (node.hasProperty("type")) {
            return NodeProperties.getType(node);
        }
        Type ctn = node.getCreationType();
        Class ct = (Class)ctn.acceptVisitor(this);
        List largs = node.getArguments();
        Class[] args = Constants.EMPTY_CLASS_ARRAY;
        if (largs != null) {
            args = new Class[largs.size()];
            Iterator it = largs.iterator();
            int i = 0;
            while (it.hasNext()) {
                args[i++] = (Class)((Node)it.next()).acceptVisitor(this);
            }
        }
        return this.context.setProperties(node, ct, args, node.getMembers());
    }

    public Object visit(ArrayAllocation node) {
        Class c;
        Iterator it = node.getSizes().iterator();
        while (it.hasNext()) {
            c = (Class)((Node)it.next()).acceptVisitor(this);
            if (c == Byte.TYPE || c == Short.TYPE || c == Integer.TYPE) continue;
            throw new ExecutionError("array.dimension.type", node);
        }
        c = (Class)node.getCreationType().acceptVisitor(this);
        if (node.getInitialization() != null) {
            node.getInitialization().acceptVisitor(this);
        }
        Class<?> ac = Array.newInstance(c, new int[node.getDimension()]).getClass();
        node.setProperty("type", ac);
        node.setProperty("componentType", c);
        return ac;
    }

    public Object visit(ArrayInitializer node) {
        node.getElementType().acceptVisitor(this);
        this.checkList(node.getCells());
        return null;
    }

    public Object visit(ArrayAccess node) {
        Class c = (Class)node.getExpression().acceptVisitor(this);
        if (!c.isArray()) {
            node.setProperty("errorStrings", new String[]{c.getName()});
            throw new ExecutionError("array.required", node);
        }
        Class<?> result = c.getComponentType();
        node.setProperty("type", result);
        node.setProperty("modifier", new ArrayModifier(node));
        c = (Class)node.getCellNumber().acceptVisitor(this);
        if (c != Character.TYPE && c != Byte.TYPE && c != Short.TYPE && c != Integer.TYPE) {
            throw new ExecutionError("array.index.type", node);
        }
        return result;
    }

    public Object visit(PrimitiveType node) {
        Class o = node.getValue();
        node.setProperty("type", o);
        return o;
    }

    public Object visit(ReferenceType node) {
        Class c = null;
        try {
            c = this.context.lookupClass(node.getRepresentation());
        }
        catch (ClassNotFoundException e) {
            node.setProperty("errorStrings", new String[]{node.getRepresentation()});
            throw new ExecutionError("undefined.class", node);
        }
        node.setProperty("type", c);
        return c;
    }

    public Object visit(ArrayType node) {
        Type eType = node.getElementType();
        Class c = (Class)eType.acceptVisitor(this);
        Class<?> ac = Array.newInstance(c, 0).getClass();
        node.setProperty("type", ac);
        return ac;
    }

    public Object visit(TypeExpression node) {
        Class c = (Class)node.getType().acceptVisitor(this);
        node.setProperty("type", class$java$lang$Class == null ? (class$java$lang$Class = TypeChecker.class$("java.lang.Class")) : class$java$lang$Class);
        node.setProperty("value", c);
        return class$java$lang$Class == null ? (class$java$lang$Class = TypeChecker.class$("java.lang.Class")) : class$java$lang$Class;
    }

    public Object visit(NotExpression node) {
        Expression n = node.getExpression();
        Class c = (Class)n.acceptVisitor(this);
        if (c != Boolean.TYPE) {
            throw new ExecutionError("not.expression.type", node);
        }
        node.setProperty("type", c);
        if (n.hasProperty("value")) {
            if (((Boolean)n.getProperty("value")).booleanValue()) {
                node.setProperty("value", Boolean.FALSE);
            } else {
                node.setProperty("value", Boolean.TRUE);
            }
        }
        return c;
    }

    public Object visit(ComplementExpression node) {
        Expression n = node.getExpression();
        Class<Integer> c = (Class<Integer>)n.acceptVisitor(this);
        if (c == Character.TYPE || c == Byte.TYPE || c == Short.TYPE) {
            c = Integer.TYPE;
            node.setProperty("type", c);
        } else if (c == Integer.TYPE || c == Long.TYPE) {
            node.setProperty("type", c);
        } else {
            throw new ExecutionError("complement.expression.type", node);
        }
        if (n.hasProperty("value")) {
            Object o = n.getProperty("value");
            if (o instanceof Character) {
                o = new Integer(((Character)o).charValue());
            }
            o = c == Integer.TYPE ? (Number)new Integer(~((Number)o).intValue()) : (Number)new Long(((Number)o).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            node.setProperty("value", o);
        }
        return c;
    }

    public Object visit(PlusExpression node) {
        Class c = this.visitUnaryOperation(node, "plus.expression.type");
        Expression n = node.getExpression();
        if (n.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.plus(c, n.getProperty("value")));
        }
        return c;
    }

    public Object visit(MinusExpression node) {
        Class c = this.visitUnaryOperation(node, "minus.expression.type");
        Expression n = node.getExpression();
        if (n.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.minus(c, n.getProperty("value")));
        }
        return c;
    }

    public Object visit(AddExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)rn.acceptVisitor(this);
        Class c = class$java$lang$String == null ? (class$java$lang$String = TypeChecker.class$("java.lang.String")) : class$java$lang$String;
        if (lc != (class$java$lang$String == null ? (class$java$lang$String = TypeChecker.class$("java.lang.String")) : class$java$lang$String) && rc != (class$java$lang$String == null ? (class$java$lang$String = TypeChecker.class$("java.lang.String")) : class$java$lang$String)) {
            c = TypeChecker.visitNumericExpression(node, "addition.type");
        } else {
            c = class$java$lang$String == null ? (class$java$lang$String = TypeChecker.class$("java.lang.String")) : class$java$lang$String;
            node.setProperty("type", c);
        }
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.add(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(AddAssignExpression node) {
        Expression ln = node.getLeftExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (!(lc == (class$java$lang$String == null ? (class$java$lang$String = TypeChecker.class$("java.lang.String")) : class$java$lang$String) || lc != null && rc != null && lc != Void.TYPE && rc != Void.TYPE && rc != Boolean.TYPE && rc.isPrimitive())) {
            throw new ExecutionError("addition.type", node);
        }
        if (!ln.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", lc);
        return lc;
    }

    public Object visit(SubtractExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        ln.acceptVisitor(this);
        rn.acceptVisitor(this);
        Class c = TypeChecker.visitNumericExpression(node, "subtraction.type");
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.subtract(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(SubtractAssignExpression node) {
        Expression ln = node.getLeftExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE || !lc.isPrimitive() || !rc.isPrimitive()) {
            throw new ExecutionError("subtraction.type", node);
        }
        if (!ln.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", lc);
        return lc;
    }

    public Object visit(MultiplyExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        ln.acceptVisitor(this);
        rn.acceptVisitor(this);
        Class c = TypeChecker.visitNumericExpression(node, "multiplication.type");
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.multiply(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(MultiplyAssignExpression node) {
        Expression ln = node.getLeftExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE || !lc.isPrimitive() || !rc.isPrimitive()) {
            throw new ExecutionError("multiplication.type", node);
        }
        if (!ln.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", lc);
        return lc;
    }

    public Object visit(DivideExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        ln.acceptVisitor(this);
        rn.acceptVisitor(this);
        Class c = TypeChecker.visitNumericExpression(node, "division.type");
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            double d;
            Object rval = rn.getProperty("value");
            if (rval instanceof Number && (d = ((Number)rval).doubleValue()) == 0.0) {
                return c;
            }
            node.setProperty("value", InterpreterUtilities.divide(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(DivideAssignExpression node) {
        Expression ln = node.getLeftExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE || !lc.isPrimitive() || !rc.isPrimitive()) {
            throw new ExecutionError("division.type", node);
        }
        if (!ln.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", lc);
        return lc;
    }

    public Object visit(RemainderExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        ln.acceptVisitor(this);
        rn.acceptVisitor(this);
        Class c = TypeChecker.visitNumericExpression(node, "remainder.type");
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            double d;
            Object rval = rn.getProperty("value");
            if (rval instanceof Number && (d = ((Number)rval).doubleValue()) == 0.0) {
                return c;
            }
            node.setProperty("value", InterpreterUtilities.remainder(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(RemainderAssignExpression node) {
        Expression ln = node.getLeftExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE || !lc.isPrimitive() || !rc.isPrimitive()) {
            throw new ExecutionError("remainder.type", node);
        }
        if (!ln.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", lc);
        return lc;
    }

    public Object visit(EqualExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)rn.acceptVisitor(this);
        TypeChecker.checkEqualityStaticRules(lc, rc, node);
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.equalTo(lc, rc, ln.getProperty("value"), rn.getProperty("value")));
        }
        node.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    public Object visit(NotEqualExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)rn.acceptVisitor(this);
        TypeChecker.checkEqualityStaticRules(lc, rc, node);
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.notEqualTo(lc, rc, ln.getProperty("value"), rn.getProperty("value")));
        }
        node.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    public Object visit(LessExpression node) {
        Class c = this.visitRelationalExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.lessThan(ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(LessOrEqualExpression node) {
        Class c = this.visitRelationalExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.lessOrEqual(ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(GreaterExpression node) {
        Class c = this.visitRelationalExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.greaterThan(ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(GreaterOrEqualExpression node) {
        Class c = this.visitRelationalExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.greaterOrEqual(ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(BitAndExpression node) {
        Class c = this.visitBitwiseExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.bitAnd(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(BitAndAssignExpression node) {
        return this.visitBitwiseAssign(node);
    }

    public Object visit(BitOrExpression node) {
        Class c = this.visitBitwiseExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.bitOr(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(BitOrAssignExpression node) {
        return this.visitBitwiseAssign(node);
    }

    public Object visit(ExclusiveOrExpression node) {
        Class c = this.visitBitwiseExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.xOr(c, ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(ExclusiveOrAssignExpression node) {
        return this.visitBitwiseAssign(node);
    }

    public Object visit(ShiftLeftExpression node) {
        Class c = this.visitShiftExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.shiftLeft(NodeProperties.getType(node), ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(ShiftLeftAssignExpression node) {
        Class c = this.visitShiftExpression(node);
        if (!node.getLeftExpression().hasProperty("modifier")) {
            throw new ExecutionError("shift.left.type", node);
        }
        return c;
    }

    public Object visit(ShiftRightExpression node) {
        Class c = this.visitShiftExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.shiftRight(NodeProperties.getType(node), ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(ShiftRightAssignExpression node) {
        Class c = this.visitShiftExpression(node);
        if (!node.getLeftExpression().hasProperty("modifier")) {
            throw new ExecutionError("shift.right.type", node);
        }
        return c;
    }

    public Object visit(UnsignedShiftRightExpression node) {
        Class c = this.visitShiftExpression(node);
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", InterpreterUtilities.unsignedShiftRight(NodeProperties.getType(node), ln.getProperty("value"), rn.getProperty("value")));
        }
        return c;
    }

    public Object visit(UnsignedShiftRightAssignExpression node) {
        Class c = this.visitShiftExpression(node);
        if (!node.getLeftExpression().hasProperty("modifier")) {
            throw new ExecutionError("unsigned.shift.right.type", node);
        }
        return c;
    }

    public Object visit(AndExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)rn.acceptVisitor(this);
        if (lc != Boolean.TYPE || rc != Boolean.TYPE) {
            throw new ExecutionError("and.type", node);
        }
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", (Boolean)ln.getProperty("value") != false && (Boolean)rn.getProperty("value") != false ? Boolean.TRUE : Boolean.FALSE);
        }
        node.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    public Object visit(OrExpression node) {
        Expression ln = node.getLeftExpression();
        Expression rn = node.getRightExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)rn.acceptVisitor(this);
        if (lc != Boolean.TYPE || rc != Boolean.TYPE) {
            throw new ExecutionError("or.type", node);
        }
        if (ln.hasProperty("value") && rn.hasProperty("value")) {
            node.setProperty("value", (Boolean)ln.getProperty("value") != false || (Boolean)rn.getProperty("value") != false ? Boolean.TRUE : Boolean.FALSE);
        }
        node.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    public Object visit(InstanceOfExpression node) {
        node.getReferenceType().acceptVisitor(this);
        if (((Class)node.getExpression().acceptVisitor(this)).isPrimitive()) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visit(ConditionalExpression node) {
        void var6_27;
        if (node.getConditionExpression().acceptVisitor(this) != Boolean.TYPE) {
            throw new ExecutionError("condition.type", node);
        }
        Expression n1 = node.getIfTrueExpression();
        Expression n2 = node.getIfFalseExpression();
        Class c1 = (Class)n1.acceptVisitor(this);
        Class c2 = (Class)n2.acceptVisitor(this);
        Object var6_6 = null;
        if (c1 == c2) {
            Class clazz = c1;
        } else if (c1 == null) {
            Class clazz = c2;
        } else if (c2 == null) {
            Class clazz = c1;
        } else if (!c1.isPrimitive() && !c2.isPrimitive()) {
            if (c1.isAssignableFrom(c2)) {
                Class clazz = c1;
            } else {
                if (!c2.isAssignableFrom(c1)) throw new ExecutionError("incompatible.types", node);
                Class clazz = c2;
            }
        } else {
            if (c1 == Boolean.TYPE || c2 == Boolean.TYPE || c1 == Void.TYPE || c2 == Void.TYPE) {
                throw new ExecutionError("incompatible.types", node);
            }
            if (c1 == Short.TYPE && c2 == Byte.TYPE || c1 == Byte.TYPE && c2 == Short.TYPE) {
                Class<Short> clazz = Short.TYPE;
            } else if ((c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Character.TYPE) && n1.hasProperty("value") && c1 == Integer.TYPE) {
                Number n = (Number)n1.getProperty("value");
                if (c2 == Byte.TYPE) {
                    if (n.intValue() == n.byteValue()) {
                        Class<Byte> clazz = Byte.TYPE;
                    } else {
                        Class<Integer> clazz = Integer.TYPE;
                    }
                } else if (n.intValue() == n.shortValue()) {
                    Class<Comparable<Character>> clazz = c2 == Character.TYPE ? Character.TYPE : Short.TYPE;
                } else {
                    Class<Integer> clazz = Integer.TYPE;
                }
            } else if ((c1 == Byte.TYPE || c1 == Short.TYPE || c1 == Character.TYPE) && n2.hasProperty("value") && c2 == Integer.TYPE) {
                Number n = (Number)n2.getProperty("value");
                if (c1 == Byte.TYPE) {
                    if (n.intValue() == n.byteValue()) {
                        Class<Byte> clazz = Byte.TYPE;
                    } else {
                        Class<Integer> clazz = Integer.TYPE;
                    }
                } else if (n.intValue() == n.shortValue()) {
                    Class<Comparable<Character>> clazz = c1 == Character.TYPE ? Character.TYPE : Short.TYPE;
                } else {
                    Class<Integer> clazz = Integer.TYPE;
                }
            } else if (c1 == Double.TYPE || c2 == Double.TYPE) {
                Class<Double> clazz = Double.TYPE;
            } else if (c1 == Float.TYPE || c2 == Float.TYPE) {
                Class<Float> clazz = Float.TYPE;
            } else if (c1 == Long.TYPE || c2 == Long.TYPE) {
                Class<Long> clazz = Long.TYPE;
            } else {
                Class<Integer> clazz = Integer.TYPE;
            }
        }
        node.setProperty("type", var6_27);
        return var6_27;
    }

    public Object visit(FormalParameter node) {
        Class c = (Class)node.getType().acceptVisitor(this);
        if (node.isFinal()) {
            this.context.defineConstant(node.getName(), c);
        } else {
            this.context.define(node.getName(), c);
        }
        node.setProperty("type", c);
        return c;
    }

    public Object visit(PostIncrement node) {
        Expression exp = node.getExpression();
        Class c = (Class)exp.acceptVisitor(this);
        if (!c.isPrimitive() || c == Void.TYPE || c == Boolean.TYPE) {
            throw new ExecutionError("post.increment.type", node);
        }
        if (!exp.hasProperty("modifier")) {
            throw new ExecutionError("post.increment.type", node);
        }
        node.setProperty("type", c);
        return c;
    }

    public Object visit(PreIncrement node) {
        Expression exp = node.getExpression();
        Class c = (Class)exp.acceptVisitor(this);
        if (!c.isPrimitive() || c == Void.TYPE || c == Boolean.TYPE) {
            throw new ExecutionError("pre.increment.type", node);
        }
        if (!exp.hasProperty("modifier")) {
            throw new ExecutionError("pre.increment.type", node);
        }
        node.setProperty("type", c);
        return c;
    }

    public Object visit(PostDecrement node) {
        Expression exp = node.getExpression();
        Class c = (Class)exp.acceptVisitor(this);
        if (!c.isPrimitive() || c == Void.TYPE || c == Boolean.TYPE) {
            throw new ExecutionError("post.decrement.type", node);
        }
        if (!exp.hasProperty("modifier")) {
            throw new ExecutionError("post.decrement.type", node);
        }
        node.setProperty("type", c);
        return c;
    }

    public Object visit(PreDecrement node) {
        Expression exp = node.getExpression();
        Class c = (Class)exp.acceptVisitor(this);
        if (!c.isPrimitive() || c == Void.TYPE || c == Boolean.TYPE) {
            throw new ExecutionError("pre.decrement.type", node);
        }
        if (!exp.hasProperty("modifier")) {
            throw new ExecutionError("pre.decrement.type", node);
        }
        node.setProperty("type", c);
        return c;
    }

    public Object visit(CastExpression node) {
        Class c = (Class)node.getTargetType().acceptVisitor(this);
        TypeChecker.checkCastStaticRules(c, (Class)node.getExpression().acceptVisitor(this), node);
        node.setProperty("type", c);
        return c;
    }

    private Class visitUnaryOperation(UnaryExpression node, String s) {
        Class c = (Class)node.getExpression().acceptVisitor(this);
        if (c == Character.TYPE || c == Byte.TYPE || c == Short.TYPE || c == Integer.TYPE) {
            node.setProperty("type", Integer.TYPE);
        } else if (c == Long.TYPE || c == Float.TYPE || c == Double.TYPE) {
            node.setProperty("type", c);
        } else {
            throw new ExecutionError(s, node);
        }
        return c;
    }

    private static Class visitNumericExpression(BinaryExpression node, String s) {
        Class lc = NodeProperties.getType(node.getLeftExpression());
        Class rc = NodeProperties.getType(node.getRightExpression());
        Class<Number> c = null;
        if (lc == null || rc == null || lc == Boolean.TYPE || rc == Boolean.TYPE || !lc.isPrimitive() || !rc.isPrimitive() || lc == Void.TYPE || rc == Void.TYPE) {
            throw new ExecutionError(s, node);
        }
        if (lc == Double.TYPE || rc == Double.TYPE) {
            c = Double.TYPE;
            node.setProperty("type", c);
        } else if (lc == Float.TYPE || rc == Float.TYPE) {
            c = Float.TYPE;
            node.setProperty("type", c);
        } else if (lc == Long.TYPE || rc == Long.TYPE) {
            c = Long.TYPE;
            node.setProperty("type", c);
        } else {
            c = Integer.TYPE;
            node.setProperty("type", c);
        }
        return c;
    }

    private static void checkAssignmentStaticRules(Class lc, Class rc, Node node, Node v) {
        if (lc != null) {
            if (lc.isPrimitive()) {
                if (lc == Boolean.TYPE && rc != Boolean.TYPE) {
                    throw new ExecutionError("assignment.types", node);
                }
                if (lc == Byte.TYPE && rc != Byte.TYPE) {
                    Number n;
                    if (rc == Integer.TYPE && v.hasProperty("value") && (n = (Number)v.getProperty("value")).intValue() == n.byteValue()) {
                        return;
                    }
                    throw new ExecutionError("assignment.types", node);
                }
                if ((lc == Short.TYPE || rc == Character.TYPE) && rc != Byte.TYPE && rc != Short.TYPE && rc != Character.TYPE) {
                    Number n;
                    if (rc == Integer.TYPE && v.hasProperty("value") && (n = (Number)v.getProperty("value")).intValue() == n.shortValue()) {
                        return;
                    }
                    throw new ExecutionError("assignment.types", node);
                }
                if (lc == Integer.TYPE && rc != Byte.TYPE && rc != Short.TYPE && rc != Character.TYPE && rc != Integer.TYPE) {
                    throw new ExecutionError("assignment.types", node);
                }
                if (!(lc != Long.TYPE || rc != null && rc.isPrimitive() && rc != Void.TYPE && rc != Boolean.TYPE && rc != Float.TYPE && rc != Double.TYPE)) {
                    throw new ExecutionError("assignment.types", node);
                }
                if (!(lc != Float.TYPE || rc != null && rc.isPrimitive() && rc != Void.TYPE && rc != Boolean.TYPE && rc != Double.TYPE)) {
                    throw new ExecutionError("assignment.types", node);
                }
                if (!(lc != Double.TYPE || rc != null && rc.isPrimitive() && rc != Void.TYPE && rc != Boolean.TYPE)) {
                    throw new ExecutionError("assignment.types", node);
                }
            } else if (rc != null && !lc.isAssignableFrom(rc)) {
                throw new ExecutionError("assignment.types", node);
            }
        }
    }

    private static void checkEqualityStaticRules(Class lc, Class rc, Node n) {
        if (lc != rc || lc == Void.TYPE) {
            if (lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE) {
                throw new ExecutionError("compare.type", n);
            }
            if (lc == null && rc.isPrimitive() || rc == null && lc.isPrimitive()) {
                throw new ExecutionError("compare.type", n);
            }
            if (lc != null && rc != null) {
                if (lc.isPrimitive() ^ rc.isPrimitive()) {
                    throw new ExecutionError("compare.type", n);
                }
                if (!(lc.isPrimitive() || rc.isPrimitive() || lc.isAssignableFrom(rc) || rc.isAssignableFrom(lc))) {
                    throw new ExecutionError("compare.type", n);
                }
            }
        }
    }

    private Class visitRelationalExpression(BinaryExpression node) {
        Class lc = (Class)node.getLeftExpression().acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Boolean.TYPE || rc == Boolean.TYPE || !lc.isPrimitive() || !rc.isPrimitive()) {
            throw new ExecutionError("relational.expression.type", node);
        }
        node.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    private Class visitBitwiseExpression(BinaryExpression node) {
        Class lc = (Class)node.getLeftExpression().acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        Class<Constable> c = null;
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Float.TYPE || rc == Float.TYPE || lc == Double.TYPE || rc == Double.TYPE || lc == Boolean.TYPE ^ rc == Boolean.TYPE || !lc.isPrimitive() || !rc.isPrimitive()) {
            throw new ExecutionError("bitwise.expression.type", node);
        }
        if (lc == Long.TYPE || rc == Long.TYPE) {
            c = Long.TYPE;
            node.setProperty("type", c);
        } else if (lc == Boolean.TYPE) {
            c = Boolean.TYPE;
            node.setProperty("type", c);
        } else {
            c = Integer.TYPE;
            node.setProperty("type", c);
        }
        return c;
    }

    private Class visitBitwiseAssign(BinaryExpression node) {
        Expression ln = node.getLeftExpression();
        Class lc = (Class)ln.acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Float.TYPE || rc == Float.TYPE || lc == Double.TYPE || rc == Double.TYPE || lc == Boolean.TYPE ^ rc == Boolean.TYPE || !lc.isPrimitive() || !rc.isPrimitive()) {
            throw new ExecutionError("bitwise.expression.type", node);
        }
        if (!ln.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", node);
        }
        node.setProperty("type", lc);
        return lc;
    }

    private Class visitShiftExpression(BinaryExpression node) {
        Class lc = (Class)node.getLeftExpression().acceptVisitor(this);
        Class rc = (Class)node.getRightExpression().acceptVisitor(this);
        Class<Number> c = null;
        if (lc == null || rc == null || lc == Boolean.TYPE || rc == Boolean.TYPE || lc == Void.TYPE || rc == Void.TYPE || lc == Float.TYPE || rc == Float.TYPE || lc == Double.TYPE || rc == Double.TYPE || !lc.isPrimitive() || !rc.isPrimitive()) {
            throw new ExecutionError("shift.expression.type", node);
        }
        if (lc == Long.TYPE) {
            c = Long.TYPE;
            node.setProperty("type", c);
        } else {
            c = Integer.TYPE;
            node.setProperty("type", c);
        }
        return c;
    }

    private static void checkCastStaticRules(Class tc, Class ec, Node n) {
        if (tc != ec) {
            if (tc.isPrimitive()) {
                if (tc == null || !ec.isPrimitive() || ec == Boolean.TYPE || ec == Void.TYPE) {
                    throw new ExecutionError("cast", n);
                }
            } else if (ec != null) {
                if (ec.isArray()) {
                    if (tc.isArray()) {
                        Class<?> tec = tc.getComponentType();
                        Class<?> eec = ec.getComponentType();
                        if (tec.isPrimitive() && eec.isPrimitive()) {
                            if (tec != eec) {
                                throw new ExecutionError("cast", n);
                            }
                        } else {
                            TypeChecker.checkCastStaticRules(tec, eec, n);
                        }
                    } else {
                        if (tc.isInterface() && tc != (class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = TypeChecker.class$("java.lang.Cloneable")) : class$java$lang$Cloneable)) {
                            throw new ExecutionError("cast", n);
                        }
                        if (tc != (class$java$lang$Object == null ? (class$java$lang$Object = TypeChecker.class$("java.lang.Object")) : class$java$lang$Object)) {
                            throw new ExecutionError("cast", n);
                        }
                    }
                } else if (ec.isInterface() ? !tc.isInterface() && (tc.isArray() ? !(class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = TypeChecker.class$("java.lang.Cloneable")) : class$java$lang$Cloneable).isAssignableFrom(ec) : Modifier.isFinal(tc.getModifiers()) && !tc.isAssignableFrom(ec)) : (tc.isInterface() ? Modifier.isFinal(tc.getModifiers()) && !tc.isAssignableFrom(ec) : !ec.isAssignableFrom(tc) && !tc.isAssignableFrom(ec))) {
                    throw new ExecutionError("cast", n);
                }
            }
        }
    }

    private void checkList(List l) {
        ListIterator it = l.listIterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

