package base;
import java.nio.channels.*;

public class SelectorRun implements Runnable{
	public static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("base.selectorrun");
	static{ logger.setLevel(null); }

	Selector selector;

	// RXgN^
	public SelectorRun() 
	throws java.io.IOException 
	{ selector=Selector.open(); }

	// checkXbh͎OɂĂԂ
	public void setCheckThreadInfo(){
		// Aɂ邱Ƃ͂Ȃ
	}
	// selectČ̓CxgfBXpb`Xbhŏ
	// (ԂAWTXbhȊOĂ΂)
	public Throwable check(){
		try{
			selector.select(333);
			javax.swing.SwingUtilities.invokeAndWait(this);
		}catch(InterruptedException e){
			// nothing to do
		}catch(NullPointerException e){
			// nothing to do
		}catch(java.lang.reflect.InvocationTargetException e){
			return e.getCause();
		}catch(Throwable e){
			return e;
		}
		return null;
	}


	// `lo^
	// (ԂAWTXbhĂ΂)
	public SelectionKey register(SelectorItem item,SelectableChannel channel)
	throws java.io.IOException,java.nio.channels.ClosedChannelException
	{
		SelectionKey key = channel.register(selector.wakeup(),channel.validOps(),item);
		return key;
	}

	// ҋ@
	// (ԂAWTXbhĂ΂)
	public void wakeup(){ selector.wakeup(); }

	// ACeonTimerĂ
	// (ԂAWTXbhĂ΂)
	public void timer(){
		selector.wakeup();
		run();
		for(java.util.Iterator it = selector.keys().iterator();it.hasNext();){
			SelectionKey key = (SelectionKey)it.next();
			SelectorItem item =(SelectorItem)key.attachment();
			SelectableChannel channel=key.channel();
			try{
				if(channel==null) continue;
				item.onTimer(channel);
			}catch(CancelledKeyException e){
				// do nothing
			}catch(java.util.ConcurrentModificationException e){
				// do nothing
			}catch(Throwable e){
				logger.log(java.util.logging.Level.WARNING,"timer",e);
			}
		}
	}


	// implements Runnable
	// (ԂAWTXbhĂ΂)
	public void run(){
		try{
			selector.selectNow();
			for(java.util.Iterator it = selector.selectedKeys().iterator();it.hasNext();){
				SelectionKey key = (SelectionKey)it.next();
				SelectorItem item =(SelectorItem)key.attachment();
				SelectableChannel channel=key.channel();
				try{
					if(key.isAcceptable () && item.onAcceptable (channel)){ it.remove(); continue;}
					if(key.isConnectable() && item.onConnectable(channel)){ it.remove(); continue;}
					if(key.isReadable   () && item.onReadable   (channel)){ it.remove(); continue;}
					if(key.isWritable   () && item.onWritable   (channel)){ it.remove(); continue;}
				}catch(CancelledKeyException e){
					// do nothing
				}catch(java.util.ConcurrentModificationException e){
					// do nothing
				}catch(Throwable e){
					logger.log(java.util.logging.Level.WARNING,"run",e);
				}
			}
		}catch(Throwable e){ logger.log(java.util.logging.Level.WARNING,"run(2)",e); }
	}

	// o^ꂽL[ׂĕ̂҂
	// (ԂAWTXbhĂ΂)
	public boolean closeAll(){
		selector.wakeup();
		run();
		if( selector.keys().isEmpty() ){
			logger.fine( "all selector keys are closed.");
			return true;
		}
		for(java.util.Iterator it = selector.keys().iterator();it.hasNext();){
			SelectionKey key = (SelectionKey)it.next();
			SelectorItem item =(SelectorItem)key.attachment();
			SelectableChannel channel=key.channel();
			try{
				if(channel==null) continue;
				logger.fine( "wait for "
					+item.getClass().getName()
					+" "+((channel instanceof SocketChannel)?((SocketChannel)channel).socket().getRemoteSocketAddress().toString():"")
				);
				item.onSelectorExit(channel);
				item.onTimer(channel);
			}catch(CancelledKeyException e){
				// do nothing
			}catch(java.util.ConcurrentModificationException e){
				// do nothing
			}catch(Throwable e){
				logger.log(java.util.logging.Level.WARNING,"closeAll",e);
			}
		}
		return false;
	}
}

