// UTF-8 ☀☁☂☃
package base;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.net.MalformedURLException;
import java.util.logging.Level;

public class Util{
	public static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("base.util");
	static{ logger.setLevel(null); }

	//--------------------------------
	// まずCWDを探し、なければJARから読む
	public static ClassLoader AppClassLoader=null;
	public static InputStream OpenFile(String fname)
	throws IOException,FileNotFoundException
	{
		InputStream result=null;
		try{
			result= new FileInputStream(new File(fname));
		}catch(FileNotFoundException e){
		}
		if(result==null && AppClassLoader!=null)
			result = AppClassLoader.getResourceAsStream(fname);
		if(result!=null) return result;
		throw new java.io.FileNotFoundException(fname+"はディレクトリにもリソースにも含まれていない");
	}
	//----------------------------------------------
	// JAR からの画像の読み取り
	public static ImageIcon GetImageIconFromJAR(String fname){
		try{
			InputStream i=OpenFile(fname);
			try{
				ByteArrayOutputStream ba = new ByteArrayOutputStream();
				for(;;){
					int s = i.available();
					if(s<1) s= 1;
					byte[] b = new byte[s];
					int readed = i.read(b);
					if(readed==-1) break;
					ba.write(b,0,readed);
				}
				return new ImageIcon(ba.toByteArray());
			}finally{
				i.close();
			}
		}catch(Throwable e){
			logger.log(Level.WARNING,"GetImageIconFromJAR",e);
			return null;
		}
	}

	//-------------------------------------
	// エスケープの解釈と文字コード変換

	public static byte[] toJIS(String src)
	{return  ConvertChar.UnicodeToJIS(src,0,src.length()); }

	public static byte[] toJIS(String src,int start,int end)
	{ return ConvertChar.UnicodeToJIS(src,start,end); }

	public static String fromJIS(byte[] src)
	{ return ConvertChar.convertForDisplay(ConvertChar.JISToUnicode(src,0,src.length)); }

	public static String fromJIS(byte[] src,int start,int end)
	{ return ConvertChar.convertForDisplay(ConvertChar.JISToUnicode(src,start,end)); }

	//-------------------------------------
	// byte 配列の扱い
	public static byte[] ByteSubString(byte[] src,int start,int end){
		if(start<0 || end<start || end > src.length )
			throw new IndexOutOfBoundsException();
		byte[] dst= new byte[end-start];
		for(int i=0;i<dst.length;++i){
			dst[i]=src[i+start];
		}
		return dst;
	}
	public static int ByteIndexOf(byte[] src,int  c){return ByteIndexOf(src,(byte)c);}
	public static int ByteIndexOf(byte[] src,char c){return ByteIndexOf(src,(byte)c);}
	public static int ByteIndexOf(byte[] src,byte c){
		for(int i=0;i<src.length;++i){
			if(src[i]==c) return i;
		}
		return -1;
	}

	public static int compareByteArray(byte[] a,int a_start,byte[] b,int b_start){
		int minlength = ((a.length-a_start)<(b.length-b_start)?(a.length-a_start):(b.length-b_start));
		for(int i=0;i<minlength;++i){
			if(a[a_start++]!=b[b_start++])
			return ((int)a[a_start-1])-((int)b[b_start-1]);
		}
		return (a.length-a_start) - (b.length-b_start);
	}
	public static byte[] AsciiToByteArray(String s){
		byte[] r = new byte[s.length()];
		for(int i=0;i<r.length;++i){
			r[i]=(byte)s.charAt(i);
		}
		return r;
	}

	public static String qqByteArray(byte[] src){
		if(src==null){
			return "\"(null)\"";
		}
		StringBuffer sb=new StringBuffer();
		sb.append('"');
		for(int i=0;i<src.length;++i){
			int c = src[i];
			if(c<0)c+=256;
			sb.append("%");
			String Hex =Integer.toHexString(c);
			for(int j=Hex.length();j<2;++j){
				sb.append('0');
			}
			sb.append(Hex);
		}
		sb.append('"');
		return new String(sb);
	}
	// StreamTokenizerがDouble Qoute された文字列として扱うように変形
	public static String qq(String src){
		if(src==null){
			return "\"(null)\"";
		}
		StringBuffer sb=new StringBuffer();
		sb.append('"');
		for(int i=0;i<src.length();++i){
			char c = src.charAt(i);
			if("\"\\".indexOf(c)!=-1){
				sb.append('\\');
				sb.append(c);
				continue;
			}
			if( Character.isISOControl(c) ){
				sb.append("\\u");
				String Hex =Integer.toHexString((int)c);
				for(int j=Hex.length();j<4;++j){
					sb.append('0');
				}
				sb.append(Hex);
				continue;
			}
			sb.append(c);
			continue;
		}
		sb.append('"');
		return new String(sb);
	}
	// Ueil.qq の逆
	public static String unquote(String src){
		if(src==null) return null;
		StringBuffer sb=new StringBuffer();
		boolean escape = false;
		for(int i=0;i<src.length();++i){
			char c = src.charAt(i);
			if(c!='\\'){
				if(c!='"') sb.append(c);
				continue;
			}
			c = src.charAt(++i);
			switch(c){
			default:
				sb.append(c);
				break;
			case 'n':
				sb.append('\n');
				break;
			case 'r':
				sb.append('\r');
				break;
			case 't':
				sb.append('\t');
				break;
			case 'u':
				++i;
				if(i<src.length() && src.charAt(i)=='u'){
					sb.append("\\u");
					break;
				}
				int code =0;
				for(int j=0;j<4;++j){
					if(++i >= src.length() ) break;
					c = src.charAt(i);
					if( (c>='a' && c<='z') ) c-= 'a'-'A';
					int h = "0123456789ABCDEF".indexOf(c);
					if(h==-1){
						--i;
						break;
					}
					code =code*16 + h;
				}
				sb.append(code);
			}
		}
		return new String(sb);
	}


	////////////////////////////////////////////////////
	// URISpritter

	public static final boolean isURIAlpha(char c){ return  (c>='A' && c<='Z' ) ||  (c>='a' && c<='z' ); }
	public static final boolean isURIDigit(char c){ return  (c>='0' && c<='9' ); }

	// スキームの中に書いていい文字
	public static final boolean isScheme(char c)
	{ return isURIAlpha(c) || isURIDigit(c) 
	|| -1!="+-.".indexOf(c) ; }

	// :/ の後に書いていい文字かどうか
	public static final boolean isURIChar(char c)
	{ return isURIAlpha(c) || isURIDigit(c) 
	|| -1!=".%/-_=?&:~!*'();@+$,#\u007E\u203E".indexOf(c); }
	// http://www.ingrid.org/java/i18n/encoding/ja-conv.html とか参照

 	public static java.util.List URISplitter(String src){
		Vector v=new Vector();
		for(int start=0;start<src.length();){
			int uristart =start;// 見つかる可能性がある最初の位置
			int uriend   =0;
			FIND: for(;;){
				// アルファベットが見つかるまでは普通の文字列
				while(uristart<src.length()&&!isURIAlpha(src.charAt(uristart))) ++uristart;
				if( uristart>=src.length()-2 ){ uristart=src.length();break;}

				// その後に : があるはず
				int colon=src.indexOf(':',uristart+1);
				if(colon==-1){ uristart=src.length(); break; }

				// alpha+1からcologne-1まではisSchemeでないといけない
				for(int i=uristart+1;i<colon;++i)
					if(!isScheme(src.charAt(i))){ uristart=i; continue FIND; }

				// URIの種類を :/ :// に限定するなら、colonの直後は / でないといけない
				// スキームの種類をみてこの制限をはずすこともできるが、知識がないのでやめとく
				if(colon+1>=src.length() || src.charAt(colon+1)!='/'){ uristart=colon+1; continue FIND; }

				// :/ 以降にURIに使える文字が1文字以上ないといけない
				uriend=(colon+=2);
				while( uriend<src.length() && isURIChar(src.charAt(uriend))) ++uriend;
				if(uriend==colon){ uristart=colon; continue FIND; }

				// 見つかったらしい
				break;
			}
			// start～uristart-1 までは普通の文字列
			if(uristart>start) v.add(src.substring(start,start=uristart));
			// uristart～end-1 にはURIがある
			if(uriend>uristart) v.add(new MyURL(src.substring(uristart,start=uriend)));
		}
		return v;
	}

	public static String EscapeForFile(String src){
		StringBuffer sb=new StringBuffer();
		for(int i=0;i<src.length();++i){
			char c=src.charAt(i);
			if(-1!="\\/:;?*,<>|\"".indexOf(c)) c='-';
			sb.append(c);
		}
		return new String(sb);
	}
	public static String WildcardToRegEx(String mask){
		/*
			変換規則
				最初と最後に ^ $ をつける
				直前に\がない場合、
					\ は次の文字をエスケープ
					alnum はそのまま
					? *   は対応する正規表現
					他の記号には\をつける
				直前に\がある場合、
					alnum は \がつく
					他は  をつけずにそのまま
				例 wildcard aaa\d\+?  => regex ^aaa\d+.$
		*/
		StringBuffer sb = new StringBuffer();
		sb.append('^');
		boolean escape =false;
		for(int i=0;i<mask.length();++i){
			char c= mask.charAt(i);
			if((c>='a'&&c<='z')||(c>='A'&&c<='Z')||(c>='0'&&c<='9')){
				if(escape){ escape=false; sb.append('\\'); }
				sb.append(c);
			}
			else if(escape){ escape=false;sb.append(c);}
			else if(c=='\\' && i<mask.length()-1){ escape=true; }
			else if(c=='?'){ sb.append('.'); }
			else if(c=='*'){ sb.append(".*");}
			else { sb.append('\\');sb.append(c); }
		}
		sb.append('$');
		String a = sb.toString();
		logger.finer("wildcard "+mask+" => regex "+a);
		return a;
	}
	///////////////////////////////////////////////////////////
	//-----------------------------------
	// 時刻の管理

	private static String to2keta(String t){
		if(t.length()<2) return "0"+t;
		return t;
	}
//	public static TimeZone tz = TimeZone.getTimeZone("JST");
	public static String GetTime(TimeZone tz){ return GetTimeStr(tz); }
	public static String GetTimeStr(TimeZone tz)
		{ return GetTimeStr(new GregorianCalendar(tz)); }

	public static String GetTimeStr(GregorianCalendar now){
//		String yy =         Integer.toString( now.get(Calendar.YEAR  ));
//		String mm = to2keta(Integer.toString( 1+now.get(Calendar.MONTH )));
//		String dd = to2keta(Integer.toString( now.get(Calendar.DATE )));
		String h  = to2keta(Integer.toString( now.get(Calendar.HOUR_OF_DAY )));
		String m  = to2keta(Integer.toString( now.get(Calendar.MINUTE )));
//		String s  = to2keta(Integer.toString( now.get(Calendar.SECOND )));
		return h+":"+m;
	}

	public static String getDateStr(GregorianCalendar now){
		String yy =         Integer.toString( now.get(Calendar.YEAR  ));
		String mm = to2keta(Integer.toString( 1+now.get(Calendar.MONTH )));
		String dd = to2keta(Integer.toString( now.get(Calendar.DATE )));
		return yy+mm+dd;
	}

/*
	private static String ary_from="ABCDEFGHIJKLMNOPQRSTUVWXYZ[]\\";
	private static String ary_to  ="abcdefghijklmnopqrstuvwxyz{}|";
*/

	// 指定した文字種をスキップした文字列を返す
	public static int SkipDelimitor(String src,String dlm,int start){
		int i=start;
		while(i<src.length() && -1!= dlm.indexOf(src.charAt(i))) ++i;
		return i;
	}

	public static String JoinStr(String padding,String[] params,int start){
		StringBuffer sb = new StringBuffer();
		for(int i=start;i<params.length;++i){
			if(i!=start) sb.append(padding);
			sb.append(params[i]);
		}
		return new String(sb);
	}


	//////////////////////////
	// 頻出する文字列を使いまわす
	//---------------------------------------------
	// モード文字列は皆ほぼ共通なので使いまわす
	static Map RecycleString_map = new HashMap();
	public static String RecycleString(String key){
		if(key==null)return null;
		Object o= RecycleString_map.get(key);
		if(o!=null) return (String)o;
		RecycleString_map.put(key,key);
		return key;
	}
}
