package bluntirc;

import irc.*;
import base.*;
import gui.*;
import bluntirc.djava.*;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class ActionUtility{
	// アクションが文字列の引数を持っていたらそれ、なければnull
	public static String getStringParamater(){
		Object o=App.action_manager.getStackParameter();
		if(o instanceof String) return (String) o;
		return null;
	}
	// 文字列の最初の引数またはnull
	public static String StringToArg(String src,int index){
		if(src!=null){
			int i=0;
			for(;;){
				while(i<src.length() && " \t\n".indexOf(src.charAt(i))!=-1) ++i;
				int start=i;
				while(i<src.length() && " \t\n".indexOf(src.charAt(i))==-1) ++i;
				if(i>start && index==0) return src.substring(start,i);
				--index;
			}
		}
		return null;
	}


	// 接続設定ダイアログから呼ばれる。新しい枝を作成して返す
	public static CTN_Conn createConn(String name){
		CTN_Conn r = new CTN_Conn(App.getApp(),name);
		return r;
	}


	public static void setUsersMode(String modeStr){
		LinkedList users = App.main_window.user_view.getSelectedMulti();
		if(users!=null){
			CTN_Chan ctn=App.main_window.user_view.getChannelNode();
			IRCConnection conn=ctn.getConnNode().conn;
			while(0!=users.size()){
				LinkedList v=new LinkedList();
				while(0!=users.size() && v.size()<3){
					IRCChannelMember member =(IRCChannelMember)users.removeFirst();
					IRCUser user = member.getUser();
					if(user == conn.myself ) continue;
					v.add(user.getNickBytes());
				}
				if(v.size()!=0){
					v.addFirst(modeStr.substring(0,v.size()+1));
					v.addFirst(ctn.chan.getRawBytes());
					v.addFirst("MODE");
					conn.SendToServer(v);
				}
			}
		}
	}

	// ポップアップメニューから呼ばれた場合に
	// LogViewに対する指示だったら
	// 注目されている部分のテキストを返す
	public static String readHoverOrSelected(ActionEvent e){
		buffer.TextSpanInfo info = getLastHover(e);
		Object o= e.getSource();
		// ポップアップメニューから呼ばれた?
		if(!(o instanceof JMenuItem )) return null;
		// LogViewに対するメニューだった?
		o=App.getFocusComponent();
		if(!(o instanceof buffer.LogView)) return null;
		buffer.LogView view = (buffer.LogView)o;
		buffer.LogDocument doc = view.getDocument();

		// そのLogViewにはテキストがある？
		if( doc ==null) return null;

		// URLが注目されている？
		doc.getLastHover();
		if( info==null){
			App.Log("readHoverOrSelected: getLastHover is null");
			return null;
		}
		// 注目部分のテキスト
		return info.text;
	}

	// whois やファイル送信のために、ホバーされているテキストを取ってくる
	public static buffer.TextSpanInfo getLastHover(ActionEvent e){
		// メニューから呼ばれた？
		Object o = e.getSource();
		if(!(o instanceof JMenuItem)){
			App.Log("getLastHover: メニューから呼ばれたのではない？");
			return null;
		}
		// フォーカスがあったコンポーネントはLogView?
		o=App.getFocusComponent();
		if(!(o instanceof buffer.LogView)){
			App.Log("getLastHover: FocusComponent is not LogView");
			return null ;
		}
		buffer.LogView view = (buffer.LogView)o;
		buffer.LogDocument doc = view.getDocument();
		if( doc ==null){
			App.Log("getLastHover: getDocument is null");
			return null ;
		}
		buffer.TextSpanInfo info = doc.getLastHover();
		if( info==null){
			App.Log("getLastHover: doc.getLastHover is null");
			return null ;
		}
		return info;
	}
	public static CTN_Conn getConnectionNode(buffer.TextSpanInfo info){
		// 全ログなら行の中に書いてあるだろう
		buffer.StyleID sid = App.style_manager;
		buffer.PackedLineReader tsi = new buffer.PackedLineReader(info.block,info.line,sid,"base");

		// フォーカスがあったコンポーネントはLogView?
		Object o=App.getFocusComponent();
		if(!(o instanceof buffer.LogView)){
			App.Log("getLastHover: FocusComponent is not LogView");
			return null ;
		}
		buffer.LogView view = (buffer.LogView)o;
		buffer.LogDocument doc = view.getDocument();

		String name=null;
		while(tsi.hasNextSpan()){
			if(tsi.readSpan()==0) continue;
			FontInfo2 base_style = sid.getBaseStyle(tsi.baseid);
			if(base_style.get(FontInfo2.KEY_NAME).equals("%s")){
				name=tsi.getSpanText();
				break;
			}
		}
		if(name!=null){
			for(Iterator it=App.getApp().getChilds();it.hasNext();){
				o=it.next();
				if(o instanceof CTN_Conn 
				&& ((CTN_Conn)o).getName().equals(name)
				) return ((CTN_Conn)o);
			}
		}
		if( view== App.log_all.log_view ){
			if(name==null) App.Log(info.text+"のwhoisをどの接続先に対して発行すればいいかログからは読めなかった。(%sがない)");
			else  App.Log(info.text+"のwhoisを"+name+"にたずねようとしたが、接続先の一覧にその名前がない(削除またはリネームしましたね?)");
			return null;
		}
		// 全ログじゃないならバッファ一覧で選択中のバッファだと思う
		return App.getSelectedConn();
	}
}
