package bluntirc;
import irc.*;
import base.*;
import java.util.*;
import javax.swing.ImageIcon;
import java.awt.event.MouseEvent;

public class CTN_Priv extends ConnTreeNode{
	//////////////////////////////////////
	public IRCChannel chan;
	public IRCChannel GetChannel(){ return chan;}
	public CTN_Priv getPrivNode(){return this;}
	public CTN_Conn getConnNode(){return (CTN_Conn)getParent();}
	public String GetCaption(){ return chan.getShortName(); }

	//////////////////////////////////////
	static ImageIcon icon_priv  = Util.GetImageIconFromJAR("images/priv1.gif");
	static ImageIcon icon_privM = Util.GetImageIconFromJAR("images/priv2.gif");
	public ImageIcon getImageIcon()
	{ return hasMidoku ? icon_privM:icon_priv; }

	//////////////////////////////////////
	boolean hasMidoku = false;
	public void addMidoku(buffer.PackedLineWriter line,boolean noMidokuCheck){
		super.addMidoku(line);
		if( !hasMidoku &&  !noMidokuCheck&&  App.getSelected() != this ){
			hasMidoku=true;
			App.redrawTreeView(this);
		}
	}
	public void OnSelect()
	{ hasMidoku=false; App.redrawTreeView(this); }

	//////////////////////////////////////

	public String getPopupName(){ return "popup-priv";}
	public int getListLevel(){ return 3;}
	public void OnMiddleClick(MouseEvent e){ parent.removeNode(this); }
	public String getTitle()
	{ return getConnNode().GetCaption()+" "+GetCaption(); }

/*

	public void StartUp(){
	}
*/

	//////////////////////////////////////////////////
	public Object getPropertyExtra(){ return chan;}
	public void onHashSave(){ }
	public void onHashLoad(){}
	public void onPropertyChanged(String name,Object value){}
	//////////////////////////////////////////////////
	// 作成と破棄

	// 接続設定の保存に使う createNode に必要なパラメータを返す
	public java.util.List getCreateParam(){
		LinkedList l=new LinkedList();
		l.add( GetChannel().getEscapedName() );
		return l;
	}
	// 接続設定のロードからの作成
	public static ConnTreeNode createNode(ConnTreeNode parent,java.util.List param){
		String name =(String)param.get(0);
		IRCConnection conn = ((CTN_Conn)parent).conn;
		IRCChannel chan=conn.FindChannel( IRCChannelName.unescape(name),true );
		return (ConnTreeNode)chan.Extra;
	}

	// IRCConnection.FindChannelからの作成
	public static ConnTreeNode createByInitIRCChannel(ConnTreeNode p,IRCChannel chan){ return new CTN_Priv(p,chan); }

	private CTN_Priv(ConnTreeNode p,IRCChannel chan){
		super(null);
		this.chan=chan;
		CTN_Conn parent=(CTN_Conn)p;
		chan.Extra = this;
		parent.insertNodeInto(this);
	}

	public void PreRemove(){
		// IRCConnectionからチャンネルを取り除く
		getConnNode().conn.RemoveChannel(chan);
	}

}
