package bluntirc;
import irc.*;
import base.*;
import gui.*;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.awt.datatransfer.*;

public class ChannelMemberView
implements TableModel //,java.awt.datatransfer.Transferable
{
	public ChannelMemberView(boolean trans){
		addComponents(trans);
		table.addMouseListener(new MouseListener(){
			public void mouseEntered (MouseEvent e){}
			public void mouseExited  (MouseEvent e){}
			public void mousePressed (MouseEvent e){CheckPopup(e);}
			public void mouseReleased(MouseEvent e){CheckPopup(e);}
			public void mouseClicked(MouseEvent e){
				if(0!=(e.getModifiers() & MouseEvent.BUTTON1_MASK  )
				&& e.getClickCount()==2
				) CheckDoubleClick(e);
			}
		});
		table.getTableHeader().addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent e){
				int col = table.convertColumnIndexToModel(table.getColumnModel().getColumnIndexAtX(e.getX()));
				if( col==-1) return;
                if( e.getClickCount()==1 ) sort(col);
			}
		});

		row_selection = table.getSelectionModel();
		col_selection = table.getColumnModel().getSelectionModel() ;
        table.setColumnSelectionAllowed(true); 
//        table.setTransferHandler(new MyTransferHandler(this));
		table.setDragEnabled(true);
	}

	// カラムヘッダを押してソートする
	int last_col=1;
	boolean last_ascending=true;
	class ReverceComparator implements Comparator{
		Comparator src;
		ReverceComparator(Comparator src){this.src=src;}
		public int compare(Object o1,Object o2){ return - src.compare(o1,o2);}
	};
	public void sort(int col){
		if(last_col==col){
			last_ascending=!last_ascending;
		}else{
			last_ascending=true;
		}
		last_col=col;
		if(doc!=null) doc.sort(last_ascending?comparators[last_col]:new ReverceComparator(comparators[last_col]));
	}

	/////////////////////////////////////////////////////////
	// implements TableModel
	LinkedList listener = new LinkedList();
	public void addTableModelListener(TableModelListener l)
	{ if(-1==listener.indexOf(l)) listener.add(l); }
	public void removeTableModelListener(TableModelListener l)
	{ listener.remove(l); }
	public void fireTableModelListener(TableModelEvent e){
		for(Iterator i=listener.iterator();i.hasNext();)
		{ ((TableModelListener)i.next()).tableChanged(e); }
	}

	/////////////////////////////////////////////////////////
	static String[] header=new String[]{
		"o",
		"nickname",
		"username",
		"host",
		"irc server",
		"HG",
		"hop",
		"realname",
	};
	public int getColumnCount(){ return header.length; }
	public String getColumnName(int index){ return header[index];}
	public Class getColumnClass(int index){ return String.class;}

	public int getColumnPreferredWidth(int index){
		FontMetrics fm=table.getFontMetrics(table.getFont());
		return 12+fm.stringWidth(getColumnName(index));
	}

	// 実際のデータはチャンネルごとに用意されるChannelMemberListが持っている。
	ConnTreeNode channel;
	ChannelMemberList doc;
	public CTN_Chan getChannelNode(){return channel==null?null:(CTN_Chan)channel;}
	public void setDocument(ConnTreeNode channel,ChannelMemberList new_doc){
		if(doc==new_doc) return;
		if(doc!=null) doc.removeView(this);
		doc=new_doc;
		this.channel=channel;
		if(doc!=null) doc.addView(this);
		fireTableModelListener(new TableModelEvent(this));
	}
	public int    getRowCount(){ return doc==null?0:doc.getRowCount();}
	public boolean isCellEditable(int rowIndex,int columnIndex){ return false; }
	public void   setValueAt(Object aValue,int rowIndex,int columnIndex){}

	////////////////////////////////////////////////////////////
	// セルの桁ごとの処理

	public Object getValueAt(int rowIndex,int columnIndex){
		if(doc==null) return null;
		IRCChannelMember u = doc.getByRow(rowIndex);
		IRCUser user=u.getUser();
		String s=null;
		int i;
		switch(columnIndex){
		case 0: s=u.OpString(); break;
		case 1: s=user.getNick(); break;
		case 2:
			s=user.getAfterNickStr();
			if(s!=null){ i=s.indexOf('@'); if(i!=-1)s=s.substring(1,i);}
			break;
		case 3:
			s=user.getAfterNickStr();
			if(s!=null){ i=s.indexOf('@'); if(i!=-1)s=s.substring(i+1);}
			break;
		case 4: s=user.getServer(); break;
		case 5: s=user.getHomeGone(); break;
		case 6:
			int hc = user.getHopCount();
			s=((hc<0)?"":""+hc);
			break;
		case 7: s=user.getRealName();break;
		}
		return s==null?"":s;
	}

	static Comparator no_comparator = new Comparator(){ public int compare(Object o1,Object o2){return 0;}};
	Comparator[] comparators=new Comparator[]{
		//@+
		new Comparator(){ public int compare(Object o1,Object o2)
		{ return ((IRCChannelMember)o1).OpString().compareTo( ((IRCChannelMember)o2).OpString());}},
		//nickname
		ChannelMemberList.nickname_comparator, 
		// username
		new Comparator(){ public int compare(Object o1,Object o2){
			return ChannelMemberList.nickname_comparator.compare(
			 ((IRCChannelMember)o1).getUser().getUserNameBytes(),
			 ((IRCChannelMember)o2).getUser().getUserNameBytes());
		}},
		// host
		new Comparator(){ public int compare(Object o1,Object o2){
			return ChannelMemberList.nickname_comparator.compare(
			 ((IRCChannelMember)o1).getUser().getHostBytes(),
			 ((IRCChannelMember)o2).getUser().getHostBytes());
		}},
		// server
		new Comparator(){ public int compare(Object o1,Object o2){
			String s1 = ((IRCChannelMember)o1).getUser().getServer();
			String s2 = ((IRCChannelMember)o2).getUser().getServer();
			if(s1==null) s1=""; if(s2==null)s2="";
			return s1.compareToIgnoreCase(s2);
		}},
		// HG
		new Comparator(){ public int compare(Object o1,Object o2){
			String s1 = ((IRCChannelMember)o1).getUser().getHomeGone();
			String s2 = ((IRCChannelMember)o2).getUser().getHomeGone();
			if(s1==null) s1=""; if(s2==null)s2="";
			return s1.compareToIgnoreCase(s2);
		}},
		// hop
		new Comparator(){ public int compare(Object o1,Object o2){
			int s1 = ((IRCChannelMember)o1).getUser().getHopCount();
			int s2 = ((IRCChannelMember)o2).getUser().getHopCount();
			return s1 - s2;
		}},
		// realname
		new Comparator(){ public int compare(Object o1,Object o2){
			String s1 = ((IRCChannelMember)o1).getUser().getRealName();
			String s2 = ((IRCChannelMember)o2).getUser().getRealName();
			if(s1==null) s1=""; if(s2==null)s2="";
			return s1.compareToIgnoreCase(s2);
		}},
	};

	// ダブルクリック
	void CheckDoubleClick(MouseEvent e){
		ListSelectionModel lsm = row_selection;
		// ダブルクリックの際は anchor しか見ない
		if(lsm.isSelectionEmpty()) return;
		int row= lsm.getAnchorSelectionIndex();
		int col= table.convertColumnIndexToModel(col_selection.getAnchorSelectionIndex());
		if(row!=-1 && col!=-1 && doc!=null){
			IRCChannelMember member = doc.getByRow(row);
			IRCUser user=member.getUser();
			     if(col==0){ if(!member.hasOp('@')) ((CTN_Chan)channel).addOp(member,"+o"); }
			else if(col==1){ App.main_window.input_area.pasteText(user.getShortName());}
			else if(col==2){ App.main_window.input_area.pasteText(user.getEscapedName());}
			else           { App.main_window.input_area.pasteText((String)getValueAt(row,col)); }
		}
	}

	// 右クリックメニュー
	void CheckPopup(MouseEvent e){
		if(e.isPopupTrigger()){
			int row = table.rowAtPoint(new Point(e.getX(),e.getY()));
			int col = table.getColumnModel().getColumnIndexAtX(e.getX());
			if(row<0 || col<0){
				// どこでもない場所をクリックしたのなら、選択範囲をクリアする
				table.clearSelection();
			}else if(! table.isCellSelected(row,col) ){
				// 選択範囲の中をクリックしたのでないなら、
				// 選択範囲を変更する
				table.clearSelection();
				row_selection.setAnchorSelectionIndex(row);
				row_selection.addSelectionInterval(row,row);
				col_selection.setAnchorSelectionIndex(col);
				col_selection.addSelectionInterval(col,col);
				table.repaint();
			}
			App.menu_conf.showPopupMenu(e,"popup-channel-user");
		}
	}

	/////////////////////////////////////////////////////////
	// GUI部品
	public MyTable table ;
	JScrollPane scroll;
	UserTableCellRenderer cell_renderer;
	MyTableHeaderRenderer cell_renderer2;

	// 部品の初期化
	public void addComponents(boolean trans){
		table = new MyTable(this,trans);
		cell_renderer =new UserTableCellRenderer();
		table.setDefaultRenderer(String.class,cell_renderer);
		cell_renderer2=new MyTableHeaderRenderer(table.getTableHeader().getDefaultRenderer());
		table.getTableHeader().setDefaultRenderer(cell_renderer2);

		table.setShowVerticalLines(false);
	    table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		table.setCellSelectionEnabled(true);
		table.setRowSelectionAllowed(true);
		table.setColumnSelectionAllowed(true);

		TableColumnModel tcm =table.getColumnModel() ;
		for(int i=0;i<tcm.getColumnCount();++i){
			int width = getColumnPreferredWidth(i);
			tcm.getColumn(i).setPreferredWidth(width);
		}
		scroll = new MyScrollPane(table,trans);
	//    scroll.setPreferredSize(new Dimension(60, 120));

		if(trans){
			// JTableはscrollのColumnHeaderを設定する
			table.configureEnclosingScrollPane_();
			scroll.getColumnHeader().setOpaque(false);
		}
		scroll.setBorder(null);
		scroll.setOpaque(false);
		scroll.getViewport().setOpaque(false);
	}
	public JComponent getComponent(){ return scroll; }

	void reloadFontInfo(){
		cell_renderer .cf=App.style_manager.findFontInfo("UserTable");
		cell_renderer2.cf=App.style_manager.findFontInfo("UserTableHeader");
		table.setGridColor( App.style_manager.findFontInfo("UserTableGrid").fg);
		int h = table.getFontMetrics(cell_renderer.cf.font).getHeight()+2;
		if(h<16)h=16;
		table.setRowHeight( h );
	}
	/////////////////////////////////////////////////////////
	// 選択範囲

	ListSelectionModel row_selection;
	ListSelectionModel col_selection;

	public boolean isSelectedOne(){
		ListSelectionModel lsm = row_selection;
		// ダブルクリックの際はanchor しか見ない
		if(lsm.isSelectionEmpty()) return false;
		int row= lsm.getAnchorSelectionIndex();
		int col= col_selection.getAnchorSelectionIndex();
		return (row!=-1 && col!=-1 );
	}

	public boolean isSelectedMulti(){
		ListSelectionModel lsm = row_selection;
		if(lsm.isSelectionEmpty()) return false;
		return true;
	}

	public IRCChannelMember getSelectedOne(){
		if(doc!=null){
			ListSelectionModel lsm = row_selection;
			if(!lsm.isSelectionEmpty()){
				int row= lsm.getAnchorSelectionIndex();
				if(row!=-1)return doc.getByRow(row);
			}
		}
		return null;
	}
	public LinkedList  getSelectedMulti(){
		if(doc!=null){
			ListSelectionModel lsm = row_selection;
			if(!lsm.isSelectionEmpty()){
				int start = lsm.getMinSelectionIndex();
				int end   = lsm.getMaxSelectionIndex();
				if(start>=0){
					LinkedList  v= new LinkedList ();
					for(int i=0;i<=end;++i){ //endを含むことに注意
						if(lsm.isSelectedIndex(i)){
							v.add(doc.getByRow(i));
						}
					}
					return v;
				}
			}
		}
		return null;
	}
}

/////////////////////////////////////////////////////////////
// テーブルのヘッダのセルを描画するコンポーネントを返す
class MyTableHeaderRenderer
implements TableCellRenderer
{
	FontInfo cf;
	TableCellRenderer orig;
	Insets inset = new Insets(0,0,0,0);

	public MyTableHeaderRenderer(TableCellRenderer orig)
	{ this.orig=orig; }

	public Component getTableCellRendererComponent
	(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
	{
		/*
			ヘッダのデフォルトのレンダラーは
			DefaultTableCellRendererを軽く拡張して
			setBorder(UIManager.getBorder("TableHeader.cellBorder"));
			しただけのものだ。
			DefaultTableCellRenderer はJLabelを継承している。
		*/
		Component component = orig.getTableCellRendererComponent
			(table,value,isSelected,hasFocus,row,column);

		// スタイルを変更する
		if(cf!=null){
			component.setFont(cf.font);
			component.setForeground(cf.fg);
			if(component instanceof JLabel)
				((JLabel)component).setHorizontalAlignment(SwingConstants.LEADING);
			if(cf.bg==null){
				if(component instanceof JComponent)
					((JComponent)component).setOpaque(false);
			}else{
				component.setBackground(cf.bg);
			}
		}
		return component;
	}
}

/////////////////////////////////////////////////////////////
// テーブルのセルを描画するコンポーネントを返す
class UserTableCellRenderer
extends JComponent
implements TableCellRenderer 
{
	// 表示に使うリソース
	FontInfo cf;
	ImageIcon icon_user  = Util.GetImageIconFromJAR("images/user1.gif");
	ImageIcon icon_userV = Util.GetImageIconFromJAR("images/user2.gif");
	ImageIcon icon_userO = Util.GetImageIconFromJAR("images/user3.gif");

	// セルの情報
	Object value;
	boolean isSelected;
	boolean hasFocus ;
	int col; // モデル桁

	public Component getTableCellRendererComponent
	(JTable table,Object value,boolean isSelected,boolean hasFocus,int row,int column)
	{
		this.isSelected= isSelected;
		this.hasFocus  = hasFocus;
		this.col       = table.convertColumnIndexToModel(column);
		this.value     = value;
		return this;
	}

	public void update(Graphics g){ paint(g); }
	public void paint(Graphics g){
		int width  = getWidth();
		int height = getHeight();
		if(isSelected){
			g.setColor(cf.bg2);
			g.fillRect(1,1,width-2,height-2);
		}
		if(hasFocus){
			g.setColor(cf.bg);
			g.drawRect(0,0,width-1,height-1);
		}

		String text =value.toString();

		if( col==0 && App.root_property.getBoolean("UseMemberListIcon",false) ){
			ImageIcon icon = (
				 text.indexOf('@')!=-1?icon_userO
				:text.indexOf('+')!=-1?icon_userV:icon_user
			);
			Image image= icon.getImage();
			if(image!=null) g.drawImage(image,width-image.getWidth(this),0,this);
			return;
		}

		g.setFont(cf.font);
		FontMetrics fm = g.getFontMetrics();
		int text_width = fm.stringWidth(text);

		g.setColor(isSelected?cf.fg2:cf.fg);
		int align=0;
		switch(col){
		case 0: align=1; break;
		case 1: align=-1; break;
		case 2: align=-1; break;
		case 3: align=0; break;
		case 4: align=0; break;
		case 5: align=1; break;
		case 6: align=1; break;
		case 7: align=-1; break;
		}
		boolean right=false;
		if(align==1){
			right=true;
		}else if( align==0){
			// はみだす時だけ右揃え
			if( text_width > width-4) right=true;
		}
		g.drawString(text
			,(right?(width-2-text_width):2)
			,fm.getHeight()-fm.getDescent()
		);
	}
}
