package bluntirc;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import gui.*;
import base.Util;

public class InputAreaWrap{
	public JTextArea InputArea = new JTextArea();
	JScrollPane InputAreaScroller=new MyScrollPane(InputArea,App.root_property.setDefaultBoolean("TransparentScrollBarUI",false));
	JCheckBox cbMultiLine = new JCheckBox();
	Box  InputOptionPanel = Box.createHorizontalBox();
	JPanel RightBottomPanel = new JPanel();
	public JPanel getComponent(){ return RightBottomPanel; }

	public void initInputArea(){
		InputArea = new JTextArea(){
			public Dimension getPreferredSize(){
				Dimension r= super.getPreferredSize();
				r.width += 100;
				return r;
			}
		};
		InputArea.addMouseListener(new MouseAdapter(){
			public void mousePressed(MouseEvent e){ checkTreePopup(e); }
			public void mouseReleased(MouseEvent e){ checkTreePopup(e); }
		});
		InputArea.addCaretListener(new javax.swing.event.CaretListener() {
			public void caretUpdate(CaretEvent e) {
				if( InputArea.getText().indexOf('\n') != -1 )
					cbMultiLine.setSelected(true);
			}
		});
		InputArea.addKeyListener(new java.awt.event.KeyAdapter() {
			public void keyPressed(KeyEvent e) { CheckModifiler(e,true); }
			public void keyReleased(KeyEvent e) { CheckModifiler(e,false); }
		});
		InputArea.getDocument().addDocumentListener(new DocumentListener(){
			public void changedUpdate(DocumentEvent e){ updateInputAreaScroller(); }
			public void insertUpdate(DocumentEvent e){ updateInputAreaScroller(); }
			public void removeUpdate(DocumentEvent e){ updateInputAreaScroller(); }
		});
		InputAreaScroller=new MyScrollPane(InputArea,App.root_property.setDefaultBoolean("TransparentScrollBarUI",false));
		InputArea.setMinimumSize(new Dimension(100,40));
		InputAreaScroller.setMinimumSize(new Dimension(100,40));
		InputArea.setOpaque(false);
		InputAreaScroller.setOpaque(false);
		InputAreaScroller.getViewport().setOpaque(false);
		RightBottomPanel.add(InputAreaScroller, BorderLayout.CENTER);

	}

	public InputAreaWrap(){
		Insets insets = new Insets(0,0,0,0);

		cbMultiLine.setOpaque(false);
		cbMultiLine.setText("複数行");
		cbMultiLine.setRequestFocusEnabled(false);
		cbMultiLine.setVerifyInputWhenFocusTarget(false);
		cbMultiLine.setMargin(insets);


		RightBottomPanel.setLayout(new BorderLayout());
	    JComponent[] options=new JComponent[]{
			cbMultiLine,
			App.main_window.btnTalk,
			App.main_window.btnNotice,
			App.main_window.btnAction,
			App.main_window.btnTopic2,
			App.main_window.btnSendAll,
			null,
			App.main_window.labelBufferInfo,
			App.main_window.btnURL,
		};

		Box b = Box.createHorizontalBox();
		App.main_window.labelBufferInfo.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
		for(int i=0;i<options.length;++i){
			if(options[i]==null){
				b.add(Box.createHorizontalGlue());
			}else{
				if(i>0&& options[i-1]!=null){
					b.add(Box.createHorizontalStrut(2));
				}
				if( options[i] instanceof AbstractButton){
					((AbstractButton)options[i]).setMargin(insets);
				}
				b.add(options[i]);
			}
		}
		b.setBorder(BorderFactory.createEmptyBorder(1,1,1,1));
		InputOptionPanel.add(b);
		InputOptionPanel.setOpaque(false);
		InputOptionPanel.setBorder(new LineBorder(Color.black));
	    RightBottomPanel.add(InputOptionPanel,  BorderLayout.NORTH);
		RightBottomPanel.setOpaque(false);
		initInputArea();
	}

	public void reloadFontInfo(){
		updateInputAreaScroller();
	}

	public void updateInputAreaScroller(){
		Font font = App.style_manager.findFontInfo("InputArea").font;
		InputArea.setFont(font);
		InputArea.revalidate();
		// Look&Feelの補修
		cbMultiLine.setOpaque(false);
		App.main_window.labelBufferInfo.setBorder(null);
		// 入力部ScrollPaneのサイズの変更
		{
			// 最大でもバッファのコンテナ全体-InputOptionPanelの高さ
			Dimension rv = RightBottomPanel.getParent().getSize();
			rv.height   -= InputOptionPanel.getHeight() + 32;
			InputAreaScroller.setMaximumSize(rv);
			// 好みの高さは (1行+スクロールバー高さ)～上記の最大高さ
			int min_height = InputAreaScroller.getHorizontalScrollBar().getHeight();
			if(min_height<16) min_height=16;
			min_height += InputArea.getFontMetrics(font).getHeight();
			Dimension ps = InputArea.getPreferredSize();
			if(ps.height>rv.height) ps.height=rv.height;
			if(ps.height < min_height) ps.height=min_height;
			InputAreaScroller.setPreferredSize(ps);
		}
		RightBottomPanel.getParent().validate();
		InputAreaScroller.repaint(10);
	}

	private void checkTreePopup(MouseEvent e){
		if(!e.isPopupTrigger() ) return;
		
		
		App.menu_conf.showPopupMenu(e,"popup-inputarea");
	}

	//----------------------
	// 入力エリアのキーの扱い

	public void initListeners(){
	}

	//---------------------
	// 入力ヒストリ
	LinkedList rireki =new LinkedList();
	int rireki_lastShow=-1; // 最後に表示した履歴
	int rireki_max=20;
	void rireki_Append(String s){
		rireki.addFirst(s);
		if(rireki.size()>rireki_max){
			rireki.removeLast() ;
		}
		rireki_lastShow=-1;
	}
/*
	public boolean history_prev_ok(){ return rireki.size()!=0; }
	public boolean history_next_ok(){ return rireki.size()!=0; }
*/
	String rireki_prev(){
//		App.logger.finer("rireki_prev size="+rireki.size());
		if(rireki.size()==0) return null;
		++rireki_lastShow;
		if(rireki_lastShow >=rireki.size()) rireki_lastShow=0;
		return (String) rireki.get(rireki_lastShow);
	}
	String rireki_next(){
//		App.logger.finer("rireki_next size="+rireki.size());
		if(rireki.size()==0) return null;
		--rireki_lastShow;
		if(rireki_lastShow <0 ) rireki_lastShow = rireki.size()-1;
		return (String) rireki.get(rireki_lastShow);
	}

	//---------------------
	// メッセージの送信

	public void OnMenuTalk  (){ SendMessage(0); }
	public void OnMenuTopic (){ SendMessage(1); }
	public void OnMenuNotice(){ SendMessage(2); }
	public void OnMenuAction(){ SendMessage(3); }
	public void OnMenuSendAll(){ SendMessage(4); }

	void SendMessage(int type){
		String a = InputArea.getText();
		if(a.length()==0) return;
		a=Util.fromJIS(Util.toJIS(a));
		if( SendMessage(a,type) ){
			rireki_Append(a);
			// 送信に成功したら入力をクリア
			InputArea.setText("");
			cbMultiLine.setSelected(false);
		}
	}
	// ユーザからの入力を処理する
	public static boolean SendMessage(String a,int type){
		if(a==null || a.length()==0) return false;

		if(type==4){ // 全チャンネルに送る
			CTN_Conn connNode = App.getSelectedConn();
			if(connNode!=null){
				LinkedList l = connNode.getChannelNodes();
				for(Iterator it= l.iterator();it.hasNext();){
					CTN_Chan c=(CTN_Chan) it.next();
					if(c.chan.isInMyself()){
						c.SendFromUserInput(a,0);
					}
				}
			}
			return true;
		}
		ConnTreeNode c=App.getSelected();
		if( c==null ) return false;
		return c.SendFromUserInput(a,type);
	}

	boolean up_pressed;
	boolean down_pressed;
	private void CheckModifiler(KeyEvent e,boolean IsPressed){
		if(e.getKeyCode() ==KeyEvent.VK_ENTER && IsPressed ){
			if( e.isShiftDown() ||  e.isAltDown() ){ cbMultiLine.setSelected(true); }
			if(cbMultiLine.isSelected()){
				InputArea.insert("\n",InputArea.getCaretPosition() );
				updateInputAreaScroller();
			}else{
				SendMessage(0);
			}
			e.setKeyCode(KeyEvent.CHAR_UNDEFINED );
			return;
		}
		// メニューに設定されたアクションがあれば実行する
		JMenuItem menu = App.menu_conf.findMenuItem(KeyStroke.getKeyStrokeForEvent(e));
		if(menu!=null){
			menu.doClick();
			e.setKeyCode(KeyEvent.CHAR_UNDEFINED );
		}
	}

	public void history_prev(){
		String a= rireki_prev();
		if(a!=null){
			InputArea.setText(a);
			InputArea.setSelectionStart(0);
			InputArea.setSelectionEnd(a.length());
		}
	}
	public void history_next(){
		String a= rireki_next();
		if(a!=null){
			InputArea.setText(a);
			InputArea.setSelectionStart(0);
			InputArea.setSelectionEnd(a.length());
		}
	}

	public void pasteText(String s){
		int start=InputArea.getSelectionStart();
		int end  =InputArea.getSelectionEnd();
	//	App.logger.finer("pasteText: selstart="+start+" end="+end);
		if(start<end){
			InputArea.replaceRange(s,start,end);
			InputArea.setCaretPosition(start+s.length());
		}else{
			InputArea.insert(s,InputArea.getCaretPosition() );
		}
		updateInputAreaScroller();
	}
	public void cutText(){
		String s=InputArea.getSelectedText();
		if(s==null||s.length()==0) return;
		App.os_dependence.Copy(s);
		int start=InputArea.getSelectionStart();
		int end  =InputArea.getSelectionEnd();
		if(start<end){
			InputArea.replaceRange("",start,end);
			InputArea.setCaretPosition(start);
			updateInputAreaScroller();
		}
	}
	public boolean hasSelectedText(){
		int start=InputArea.getSelectionStart();
		int end  =InputArea.getSelectionEnd();
		return start<end;
	}
	public void repair(){
		RightBottomPanel.remove(InputAreaScroller);
		initInputArea();
		updateInputAreaScroller();
	}
}

