// UTF-8 ☀☁☂☃
/*
	・主ウィンドウ
*/
package bluntirc;

import irc.*;
import base.*;
import gui.*;
import bluntirc.djava.*;

import java.util.*;
import java.io.*;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

// 主ウィンドウ
public class MainWindow
extends JFrame 
{
	public MainWindow(){
		super();
		App.main_window =this;
		setTitle(App.config_AppName);
		setIconImage( App.icon_app.getImage() );
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		addWindowListener(new WindowAdapter(){
			public void windowClosed(WindowEvent e)
			{ App.getApp().AppExit("windowClosed"); }
		});
		// ボタンの初期化
		{
			JButton[] jb = new JButton[]{
				btnTalk		=new JButton(App.action_manager.find("inputarea-send-privmsg")),
				btnTopic2	=new JButton(App.action_manager.find("inputarea-send-topic")),
				btnNotice	=new JButton(App.action_manager.find("inputarea-send-notice")),
				btnAction	=new JButton(App.action_manager.find("inputarea-send-action")),
				btnSendAll	=new JButton(App.action_manager.find("inputarea-send-all-channnel")),
				btnURL 		=new JButton(App.action_manager.find("buffer-url-list")),
			};
			for(int i=0;i<jb.length;++i){
				jb[i].setRequestFocusEnabled(false);
				jb[i].setVerifyInputWhenFocusTarget(false);
				jb[i].setMargin(new Insets(0, 0, 0, 0));
				jb[i].setOpaque(false);
			}
		}
		App.menu_conf.setJMenuBar(this);
		initGUI();
		updateOpaque();

//		pack();
		log_view.setDocument(App.console_doc);
//		job_view.setSize(600,300);
		setSize(600,200);
	}
	////////////////////////////////////////////
	// レイアウト関係

//	public JPanel RootPane;

	public JSplitPane ChannelAndUserSplitter = new JSplitPane();
	public JSplitPane LRSplitter             = new JSplitPane();
	public JSplitPane AllLogSplitter         = new JSplitPane();
	public JPanel RightPanel = new JPanel();
	public ImagePanel        image_panel;
	public ChannelMemberView user_view;
	public JScrollPane       buflist_scroll;
	public InputAreaWrap     input_area;
	public buffer.LogView    log_view;
	public JTextField         labelBufferInfo = new JTextField("");
	public JButton btnTalk;
	public JButton btnTopic2;
	public JButton btnNotice;
	public JButton btnAction;
	public JButton btnSendAll;
	public JButton btnURL;


	// 背景色の描画の有無を更新する
	public void updateOpaque(){
		{
			JRootPane root = this.getRootPane();
			JLayeredPane layer=root.getLayeredPane();
			JPanel glass= (JPanel)root.getGlassPane();
			JPanel content= (JPanel)root.getContentPane();
			 JMenuBar menu = root.getJMenuBar()  ;

			root.setBorder(null);root.setOpaque(false);
			layer.setBorder(null);layer.setOpaque(false);
			menu.setBorder(null);
			//menu.setOpaque(false);
			glass.setBorder(null);glass.setOpaque(false);
			content.setBorder(null);content.setOpaque(false);
		}
		
		ChannelAndUserSplitter.setOpaque(false);
		AllLogSplitter.setOpaque(false);
		LRSplitter.setOpaque(false);
		RightPanel.setOpaque(false);
	    LRSplitter.setBorder(null);
		LRSplitter            .setContinuousLayout(false);
		ChannelAndUserSplitter.setContinuousLayout(false);
		log_view.setOpaque(false);
		labelBufferInfo.setEditable(false);
		labelBufferInfo.setOpaque(false);
	    log_view.setPreferredSize(new Dimension(300, 200));

		btnTalk		.setMargin(new Insets(0, 0, 0, 0));
		btnTopic2	.setMargin(new Insets(0, 0, 0, 0));
		btnNotice	.setMargin(new Insets(0, 0, 0, 0));
		btnAction	.setMargin(new Insets(0, 0, 0, 0));
		btnSendAll	.setMargin(new Insets(0, 0, 0, 0));
		btnURL 		.setMargin(new Insets(0, 0, 0, 0));
		btnTalk		.setOpaque(false);
		btnTopic2	.setOpaque(false);
		btnNotice	.setOpaque(false);
		btnAction	.setOpaque(false);
		btnSendAll	.setOpaque(false);
		btnURL 		.setOpaque(false);

		App.buf_list.setOpaque(false);
		buflist_scroll.setBorder(null);
		buflist_scroll.setOpaque(false);
		buflist_scroll.getViewport().setOpaque(false);
			//設定してはいけない    ConnTree.setPreferredSize(new Dimension(60, 60));
			//設定してはいけない	ConnTree.setPreferredSize(new Dimension(32767,32767));

		if( App.root_property.getBoolean("TransparentSplitPaneUI",false)){
			ChannelAndUserSplitter .setUI(new MySplitPaneUI());
			LRSplitter.setUI(new MySplitPaneUI());
			AllLogSplitter.setUI(new MySplitPaneUI());
		}
		input_area.repair();
	}

	// 部品を並べる
	private void initGUI(){
		// DPIの調査
		{
			GraphicsConfiguration gc = getGraphicsConfiguration();
			java.awt.geom.AffineTransform at = gc.getDefaultTransform();
			App.logger.info("getGraphicsConfiguration.getDefaultTransform="+at.toString());
		}
	
		JLayeredPane layer= getRootPane().getLayeredPane();
		image_panel = new ImagePanel(layer);
		getContentPane().add( image_panel ); //,new Integer( JLayeredPane.DEFAULT_LAYER.intValue() -1) );
/*
		getContentPane()
	    getContentPane()
		RootPane=(JPanel)this.;
		RootPane.setLayout(new BorderLayout());
		RootPane.add(image_panel,BorderLayout.CENTER);
		
*/		
		boolean scrollbar_trans = App.root_property.setDefaultBoolean("TransparentScrollBarUI",false);
		{
			buflist_scroll=new MyScrollPane(App.buf_list,scrollbar_trans);
			buflist_scroll.setPreferredSize(new Dimension(16*8,120));
			App.buf_list.addItem(App.getApp());
		}
		input_area=new InputAreaWrap();
		log_view = new buffer.LogView(scrollbar_trans);
		log_view.addMouseListener(new MouseAdapter(){
			public void mousePressed(MouseEvent e){ checkPopup(e);}
			public void mouseReleased(MouseEvent e){checkPopup(e);}
			void checkPopup(MouseEvent e){
				if( e.isPopupTrigger() 
				&&  e.getComponent() instanceof buffer.LogView
				){
					buffer.LogView lv = (buffer.LogView)e.getComponent();
					buffer.LogDocument doc = lv.getDocument();
					if(doc==null) return;
					lv.requestFocus();
					App.menu_conf.showPopupMenu(e,doc.getMenuListener(),doc);
				}
			}
		});

		user_view = new ChannelMemberView(App.root_property.setDefaultBoolean("TransparentScrollBarUI",false));


		RightPanel.setLayout(new BorderLayout());

		JComponent logarea_top;
		if(App.log_all.isWindow()){
			RightPanel.add(log_view, BorderLayout.CENTER);
			RightPanel.add(input_area.getComponent(),BorderLayout.SOUTH);
			logarea_top=RightPanel;
		}else{
			AllLogSplitter.setOrientation(JSplitPane.VERTICAL_SPLIT);
			AllLogSplitter.setResizeWeight(0.5);
			if( App.root_property.getBoolean("alllog_top",false) ){
			    AllLogSplitter.add(log_view, JSplitPane.RIGHT);
				AllLogSplitter.add(App.log_all.getComponent(),JSplitPane.LEFT);
				RightPanel.add(AllLogSplitter, BorderLayout.CENTER);
				RightPanel.add(input_area.getComponent(),BorderLayout.SOUTH);
				logarea_top=RightPanel;
			}else{
				RightPanel.add(input_area.getComponent(),BorderLayout.SOUTH);
				RightPanel.add(log_view, BorderLayout.CENTER);
			    AllLogSplitter.add(RightPanel, JSplitPane.LEFT);
				AllLogSplitter.add(App.log_all.getComponent(),JSplitPane.RIGHT);
				logarea_top=AllLogSplitter;
			}
		}

		ChannelAndUserSplitter.setOrientation(App.root_property.getBoolean("HorizontalLayout",false)?JSplitPane.HORIZONTAL_SPLIT:JSplitPane.VERTICAL_SPLIT);
		if(App.root_property.getBoolean("TopTree",false)){
			ChannelAndUserSplitter.add(user_view.getComponent(),JSplitPane.RIGHT);
			ChannelAndUserSplitter.add(buflist_scroll,JSplitPane.LEFT);
			ChannelAndUserSplitter.setResizeWeight(0);
			ChannelAndUserSplitter.setDividerLocation(-1);
		}else{
			ChannelAndUserSplitter.add(user_view.getComponent(),JSplitPane.LEFT);
			ChannelAndUserSplitter.add(buflist_scroll,JSplitPane.RIGHT);
			ChannelAndUserSplitter.setResizeWeight(1);
			ChannelAndUserSplitter.setDividerLocation(-1);
		}

		if( App.root_property.getBoolean("RightTree",false)){
		    LRSplitter.add(ChannelAndUserSplitter, JSplitPane.RIGHT);
		    LRSplitter.add(logarea_top, JSplitPane.LEFT);
			LRSplitter.setResizeWeight(0);
		}else{
		    LRSplitter.add(ChannelAndUserSplitter, JSplitPane.LEFT);
		    LRSplitter.add(logarea_top, JSplitPane.RIGHT);
			LRSplitter.setResizeWeight(1);
		}
		image_panel.setLayout(new BorderLayout());
		image_panel.add(LRSplitter, BorderLayout.CENTER);
		//	JPanel lay = new JPanel();
		//	lay.setLayout(new OverlayLayout(lay));
		//	lay.setOpaque(false);
		//	lay.add( fore);
		//	lay.add( bg );
		//	parent.add(lay, BorderLayout.CENTER);
	}

	// 表示設定ファイルのりロードにあわせて画面を更新する
	public void reloadBGInfoAll(){

		App.log_all.image_panel.reloadBGInfo(App.style_manager.findBGInfo( App.log_all.isWindow()?"AllLog" :"MainWindow"));
		image_panel.reloadBGInfo(App.style_manager.findBGInfo("MainWindow"));
//		job_view.image_panel.reloadBGInfo(style_manager.findBGInfo("MainWindow"));
//		job_view.reloadFontInfo();
		user_view.reloadFontInfo();
		input_area.reloadFontInfo();
		App.buf_list.setFontInfo(
			 App.style_manager.findFontInfo("ConnListCaption")
			,App.style_manager.findFontInfo("ConnListLabel2")
			,App.style_manager.findFontInfo("ConnListNumber")
		);
		// メニュー設定の再読み込み
		App.menu_conf.load();
		App.menu_conf.setJMenuBar(this);
	}
	
	// スプリッタの位置を調整する
	public void neatSplitter(){
		if(App.root_property.getBoolean("TopTree",false)){
			ChannelAndUserSplitter.setDividerLocation((int)(buflist_scroll.getPreferredSize().getWidth()) );
		}else{
			ChannelAndUserSplitter.setDividerLocation(ChannelAndUserSplitter.getWidth()-buflist_scroll.getPreferredSize().getWidth() );
		}
/*		
			int loc = LRSplitter.getDividerLocation();
			int right_width = LRSplitter.getRightComponent().getMinimumSize().width;
			int left_width  = LRSplitter.getLeftComponent() .getMinimumSize().width;
			int width = LRSplitter.getWidth();
			if(loc>width)loc=width;
			if(App.root_property.getBoolean("RightTree",false)){
				if(loc < left_width) loc = left_width;
			}else{
				if((width-loc) < right_width) loc = width-right_width;
			}
			LRSplitter.setDividerLocation(loc);
*/
	}

	// ウィンドウを閉じた際に終了する。
	// (JFrameの関数のオーバライド)
	protected void processWindowEvent(WindowEvent e) {
		super.processWindowEvent(e);
		if( e.getID() == WindowEvent.WINDOW_CLOSING )
			App.getApp().AppExit("WindowEvent.WINDOW_CLOSING");
	}
}
