// UTF-8 ☀☁☂☃
package bluntirc; 

/*
	外部コマンドの実行、
	Look & Feel の変更、
	クリップボード関連のコード 等
	機種間で主に問題になりそうな部分を集めたクラス
*/

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import koala.dynamicjava.interpreter.*;
import koala.dynamicjava.parser.wrapper.*;

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

import base.MyURL;

class WinLF extends com.sun.java.swing.plaf.windows.WindowsLookAndFeel
{ public boolean isNativeLookAndFeel() { return true; } }

public class OSDependence
implements ClipboardOwner
{
	public static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("bluntirc.osdependence");
	static{ logger.setLevel(null); }

	//////////////////////////////////////////////////////////////////////////
	// クリップボード

    public void lostOwnership(Clipboard clipboard, Transferable contents) {}
	public void Copy(String s){
		if(s==null || s.length()==0) return;
		try{
			App.main_window.getToolkit().getSystemClipboard().setContents(
				new StringSelection(s),this
			);
		}catch(Throwable e){
			logger.log(java.util.logging.Level.WARNING,"clipboard-copy is failed",e);
		}
	}

	public boolean canGetClipboardText(){
		try{
			App app=App.getApp();
			if(app!=null && App.main_window !=null ){
				Transferable t=App.main_window.getToolkit().getSystemClipboard().getContents(app);
				return t!=null && t.isDataFlavorSupported(DataFlavor.stringFlavor);
			}
		}catch(Throwable e){
			App.Log("canGetClipboardText"+e.toString() );
			logger.log(java.util.logging.Level.WARNING,"canGetClipboardText",e);
		}
		return false;
	}

	public String getClipboardText(){
		try{
			App app=App.getApp();
			if(app!=null && App.main_window !=null ){
				Transferable t=App.main_window.getToolkit().getSystemClipboard().getContents(app);
				if(t!=null&& t.isDataFlavorSupported(DataFlavor.stringFlavor) ){
					return (String)t.getTransferData(DataFlavor.stringFlavor);
				}
			}
		}catch(Throwable e){
			App.Log("getClipboardText "+e.toString());
			logger.log(java.util.logging.Level.WARNING,"getClipboardText",e);
		}
		return null;
	}

	//////////////////////////////////////////////////////////////
	// 外部コマンドの実行

	public String[] parsecmd(String desc,String cmdline){
		if( cmdline==null || cmdline.length()==0 ){
			if(desc!=null) App.Log(desc+"が設定されていない");
			return null;
		}
		// "" 区切りの可能なエスケープ指定
		StreamTokenizer in=new StreamTokenizer(new StringReader(cmdline));
		in.resetSyntax();
		// 区切りは <=0x20 全部
		in.whitespaceChars(0,0x20);
		in.wordChars(0x21,0x21); // !
		in.quoteChar(0x22); // "
		in.wordChars(0x23,0x26); // #  $  %  &
		in.quoteChar(0x27); // '
		in.wordChars(0x28,0x7E); // ( ～ ~
		Vector v=new Vector();
		boolean hasError=false;
		try{
			for(;;){
				switch( in.nextToken() ){
				case StreamTokenizer.TT_EOL: break;
				case StreamTokenizer.TT_EOF: break;
				case 0x22:
				case 0x27:
				case StreamTokenizer.TT_WORD:
					App.logger.finer("Command param["+v.size()+"]="+in.sval);
					v.add(in.sval);
					continue;
				default:
					App.logger.warning("Command has bad token "+(char)+in.ttype+" num="+Integer.toHexString(in.ttype) );
					hasError=true;
					continue;
				}
				break;
			}
		}catch(IOException e){
			if(desc!=null)  App.Log(desc+"のパースに失敗しました "+e);
			return null;
		}
		if(v.size()==0 || hasError){
			if(desc!=null) App.Log(desc+"のパースに失敗しました"+in.sval);
			return null;
		}
		String[] cmdarray = new String[v.size()+1];
		for(int i=0;i<v.size();++i) cmdarray[i]=(String)v.get(i);
		return cmdarray;
	}

	TreeInterpreter ti;

	public boolean openURL(String desc,String cmdline,String url){
		if(url==null){
			App.Log("処理するURLを取得できない");
			return false;
		}

		if(App.root_property.getBoolean("UseMRJToOpenURL",false)){
			String script ="com.apple.mrj.MRJFileUtils.openURL("+base.Util.qq(url)+");";
			try{
				if(ti==null){
					ti = new TreeInterpreter(new JavaCCParserFactory());
					ti.setAccessible(true);
				}
				ti.interpret(new base.EscapeReader(new StringReader(script)),"mrj-open_url");
				return true;
			}catch( Throwable e ){
				App.hook_manager.parseScriptError("mrj-open_url",e);
				return false;
			}
		}

		String[] cmdarray =parsecmd(desc,cmdline);
		if(cmdarray==null) return false;

		for(Iterator it=base.Util.URISplitter(url).iterator();it.hasNext();){
			Object o= it.next();
			if(o instanceof MyURL){
				cmdarray[cmdarray.length-1] = ((MyURL)o).toString();
				try{
					Runtime.getRuntime().exec(cmdarray);
				}catch (IOException error){ 
					App.Log("Runtime.getRuntime().exec :"+error.toString()+" "+error.getMessage());
					logger.log(java.util.logging.Level.WARNING,"cmd=["+cmdline+"] url="+cmdarray[cmdarray.length-1],error);
				}
			}
		}
		return true;
	}

	public void editTextFile(File file){
		String cmdline =App.root_property.getString("TextEditorPath");
		String[] cmdarray =parsecmd("TextEditorPath",cmdline);
		if(cmdarray==null) return ;
		cmdarray[cmdarray.length-1] = file.getAbsolutePath();
		try{
			Runtime.getRuntime().exec(cmdarray);
		}catch (IOException error){ 
			App.Log("Runtime.getRuntime().exec :"+error.toString()+" "+error.getMessage());
			logger.log(java.util.logging.Level.WARNING,"cmd=["+cmdline+"] arg="+cmdarray[cmdarray.length-1],error);
		}
	}
	public void openFolder(File file){
		String cmdline =App.root_property.getString("FolderViewerPath");
		String[] cmdarray =parsecmd("FolderViewerPath",cmdline);
		if(cmdarray==null) return ;
		cmdarray[cmdarray.length-1] = file.getAbsolutePath();
		try{
			Runtime.getRuntime().exec(cmdarray);
		}catch (IOException error){ 
			App.Log("Runtime.getRuntime().exec :"+error.toString()+" "+error.getMessage());
			logger.log(java.util.logging.Level.WARNING,"cmd=["+cmdline+"] arg="+cmdarray[cmdarray.length-1],error);
		}
	}
	///////////////////////////////////////////////////////////
	// UIの変更

	private LookAndFeel win_lf;
	private String old_lf = "?";

    public boolean isWindows(){
        String osName = System.getProperty("os.name");
        return (osName != null) && (osName.indexOf("Windows") != -1);
    }

	public void removeBorder(java.awt.Component c){
		if( c instanceof JSplitPane){
			((JSplitPane)c).setBorder(null);
			((JComponent)((JSplitPane)c).getLeftComponent() ).setBorder(null);
			((JComponent)((JSplitPane)c).getRightComponent()).setBorder(null);
		}
		if( c instanceof JScrollPane){
			((JScrollPane)c).setBorder(null);
			((JScrollPane)c).setOpaque(false);
			try{
				((JScrollPane)c).setViewportBorder(null);
				((JScrollPane)c).getViewport().setOpaque(false);
			}catch(Throwable e){}
			try{
				((JScrollPane)c).getColumnHeader().setOpaque(false);
			}catch(Throwable e){}
		}

		if(c instanceof Container){
			int count =((Container)c).getComponentCount();
			for(int i=0;i<count;++i){
				removeBorder(((Container)c).getComponent(i));
			}
		}
	}
	public void removeBorder(java.awt.Window w){
		java.awt.Window[] list = w.getOwnedWindows();
		removeBorder((java.awt.Component)w);
		for(int i=0;i<list.length;++i) removeBorder(list[i]);
	}

	public void updateUI(Color c,java.awt.Window w){
		w.setBackground(c);
		javax.swing.SwingUtilities.updateComponentTreeUI(w);
		java.awt.Window[] list = w.getOwnedWindows();
		for(int i=0;i<list.length;++i) updateUI(c,list[i]);
	}
	public boolean setLF(String name){
		try{
			if(!name.equals(old_lf)){
				if(!isWindows() && name.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")){
					if(win_lf==null) win_lf = new WinLF();
					UIManager.setLookAndFeel(win_lf);
				}else{
					UIManager.setLookAndFeel(name);
				}
				App.logger.finer("setLF "+name);
				old_lf=name;
			}

			{
				Color c = UIManager.getColor("control");
				java.awt.Frame[] frames = java.awt.Frame.getFrames();
				for(int i=0;i<frames.length;++i){
					updateUI(c,frames[i]);
				}
			}

			if( App.getApp()!=null  && App.main_window!=null ) App.main_window.updateOpaque();

			{
				java.awt.Frame[] frames = java.awt.Frame.getFrames();
				for(int i=0;i<frames.length;++i){
					removeBorder(frames[i]);
				}
			}

		}catch(Throwable e){
			logger.log(java.util.logging.Level.SEVERE,"setLookAndFeel failed ("+name+")",e);
		}
		return false;
	}
}
