// UTF-8 ☀☁☂☃

/*
	・selectのブロックに付き合う
*/
package bluntirc; 
import java.util.logging.*;


public class SelectThread
extends Thread
{
	private static Logger logger = Logger.getLogger("bluntirc.selectthread");
	static{ logger.setLevel(null); }

	private static ThreadGroup  tg = new ThreadGroup("SelectThread"){
		public void uncaughtException(Thread t,Throwable e)
		{
			logger.log(
				Level.SEVERE
				,"uncaughtException in SelectThread"
				,e
			);
		}
	};

	public SelectThread(){ super(tg,"SelectThread"); }


	private static volatile boolean isExit;

	public void run(){
		logger.fine("SelectThread start.");
		App.selector.setCheckThreadInfo();
		// selectのループ
		while(!isExit){
			Throwable e=App.selector.check();
			if(e!=null){
				logger.log(java.util.logging.Level.WARNING,"App.selector.check",e);
				javax.swing.SwingUtilities.invokeLater(new Runnable(){public void run(){ App.getApp().AppExit("selector error");}});
				break;
			}
		}
		// 例外で落ちた場合、AppExitからkillが呼ばれるのを待つ
		while(!isExit) try{ Thread.sleep(100); }catch(InterruptedException ee){}
		logger.fine("System.exit");
		System.exit(0);
	}

	public static void kill()
	{ isExit=true; App.selector.wakeup(); }
}
