package buffer;
import gui.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.datatransfer.*;
/*
import java.awt.font.FontRenderContext; // 不要だと思うが…
import java.awt.geom.Rectangle2D;
*/
// LogDocumwntを表示するコントロール
public class LogView
extends JPanel
implements java.awt.datatransfer.Transferable
{
	public LogView(boolean trans){
		// UI配置
		super();
		setLayout(new BorderLayout());
		setFont(new Font("Dialog",Font.PLAIN,12));
		scroll_bar= new MyScrollBar(MyScrollBar.VERTICAL,trans);
		add(scroll_bar,BorderLayout.EAST);

		// スクロールバー
		scroll_bar.addAdjustmentListener(new AdjustmentListener(){
			public void adjustmentValueChanged(AdjustmentEvent e)
			{ scrollTo(e.getValue()); }
		});

		// キーボード
		addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent e){
				if(doc==null) return;
				switch(e.getKeyCode() ){
				case KeyEvent.VK_UP  : case KeyEvent.VK_KP_UP  : scrollLines(-1);break;
				case KeyEvent.VK_DOWN: case KeyEvent.VK_KP_DOWN: scrollLines( 1);break;
				case KeyEvent.VK_PAGE_UP  : scrollTo( doc.getScrollY() - getHeight() );break;
				case KeyEvent.VK_PAGE_DOWN: scrollTo( doc.getScrollY() + getHeight() );break;
				}
			}
		});

		// マウス
		addMouseListener(new MouseAdapter(){
			public void mouseExited(MouseEvent e){
				if(doc!=null) doc.mouseExited(e);
			}
			public void mouseClicked(MouseEvent e){ 
				requestFocus();
				if(doc!=null) doc.mouseClicked(e);
			}
			public void mousePressed(MouseEvent e){
				requestFocus(); 
				if(doc==null) return;
				if(!e.isPopupTrigger() ){ doc.mousePressed(e); return;}
			}
			public void mouseReleased(MouseEvent e){
				if(doc!=null) doc.mouseReleased(e);
			}
		});

		// マウスモーション
		addMouseMotionListener(new MouseMotionListener(){
			public void mouseMoved(MouseEvent e){
				if(doc!=null) doc.mouseMoved(e);
			}
			public void mouseDragged(MouseEvent e){
				if(doc==null) return;
				// ドラッグ中に上下には乱した場合のスクロール
				int y=e.getY();
				if(y<0){
					 scrollTo(doc.getScrollY() +(y>>2) );
				}else{
					y-=getHeight();
					if(y>0) scrollTo(doc.getScrollY() +(y>>2) );
				}
				// ハイライトの消去と範囲選択の継続
				doc.mouseDragged(e);
			}
		});
		// リサイズ
		addComponentListener(new ComponentAdapter(){
			public void componentResized(ComponentEvent e)
			{ OnResize(); repaint(100); }
		});
		// マウスホイール (JDK1.4 or later)
		addMouseWheelListener(new MouseWheelListener(){
			public void mouseWheelMoved(MouseWheelEvent e){ 
				if(doc==null) return;
				scrollLines(e.getUnitsToScroll());
			}
		});

		//DnD
	//	setDragEnabled(true);
		setTransferHandler(new MyTransferHandler(this));
	}

	ActionListener LogSweepListener=null;
	public void addLogSweepListener(ActionListener a){
		LogSweepListener =a;
	}
	void onLogSweep(){
		OnResize();
		repaint(100);
		if(LogSweepListener!=null)
			LogSweepListener.actionPerformed(new ActionEvent(
				this,0,"onLogSweep"
			));
	}

	// 文書
	private LogDocument doc;
	public LogDocument getDocument(){ return doc;}
	public void setDocument( LogDocument a_doc ){
		if(doc!=a_doc){
			if(doc!=null){ doc.addView_byLogView(null); }
			doc=a_doc;
			if(doc!=null){
				doc.addView_byLogView(this);
				doc.ReloadSetting(this);
				// スクロールバーの再設定
				int sy = doc.getScrollY();
				scroll_bar.setVisibleAmount( getHeight() );
				scroll_bar.setMaximum( doc.getHeight() );
				scroll_bar.setValue(doc.setScrollY(sy)); //todo: これでいいのか？
			}
			OnResize();
			repaint(100);
		}
	}

	// 描画
	public void paint(Graphics g){
		Rectangle rec=g.getClipBounds();
		int w= getWidth()-scroll_bar.getWidth();
		if( isOpaque() ){
			g.setColor( getBackground() );
			g.fillRect(rec.x,rec.y,rec.width,rec.height);
		}
		if(doc==null){
			g.setColor( getForeground() );
			g.drawString("ドキュメントが指定されてない",0,getFontMetrics(getFont()).getAscent() );
		}else{
			doc.paint(g,this,getWidth()-scroll_bar.getWidth());
		}
		super.paintBorder(g);
		super.paintChildren(g);
	}

	// スクロール
	JScrollBar scroll_bar;

	public void onAddText(int height){
		int old_max    = scroll_bar.getMaximum();
		int old_scroll = scroll_bar.getValue();

		scroll_bar.setMaximum(doc.getHeight());

		// ドキュメントの方が小さい
		if( doc.getHeight() <=getHeight() ){
			scrollTo(0);
			// 更新された範囲を再描画
			repaint(100,0,old_max ,getWidth()-scroll_bar.getWidth(),height); 
			return;
		}
		// 元々終端にいたならその状態を維持する
		if( old_scroll > old_max-getHeight()-height ){
			scrollTo(doc.getHeight() -getHeight() );
			return;
		}
		// 追加された領域が画面内にある
		if( old_scroll >= old_max-getHeight() ){
			// 更新された範囲を再描画
			repaint(100,0,old_max ,getWidth()-scroll_bar.getWidth(),height); 
			return;
		}
	}

	public int getLineHeight()
	{ return getFontMetrics(getFont()).getHeight(); }

	void scrollLines(int lines){
		if(doc==null)return;
		scrollTo( doc.getScrollY() + lines * getLineHeight() );
	}
	void scrollTo(int new_y){
		if(doc==null)return;
		int height = getHeight();
		int max =doc.getHeight()-height;
		// max<0の場合におかしくなった new_y=(new_y<0?0:new_y>max?max:new_y);
		if(new_y>max) new_y=max;
		if(new_y<  0) new_y=0;

		scroll_bar.setMaximum( doc.getHeight() );
		scroll_bar.setVisibleAmount(height);

		if( doc.getScrollY() == new_y ) return;
		doc.setScrollY(new_y);
		if( doc.getScrollY() != scroll_bar.getValue() ){
			scroll_bar.setValue( doc.getScrollY() );
		}
		repaint(100);
	}
	void OnResize(){
		int old_height = scroll_bar.getVisibleAmount();
		int old_max = scroll_bar.getMaximum();
		int old_scrolly = scroll_bar.getValue();
		{
			if(doc==null){
				scroll_bar.setMaximum(0);
				scroll_bar.setValue(0);
			}else{
				int w= getWidth() - scroll_bar.getWidth();
				doc.setWidth(this,w,getHeight());
				scroll_bar.setMaximum(doc.getHeight());
			}
			scroll_bar.setMinimum(0);
			scroll_bar.setBlockIncrement(getHeight());
			scroll_bar.setVisibleAmount (getHeight());
			scroll_bar.setUnitIncrement(getLineHeight());
		}
		if(doc!=null){
			int under = old_max -(old_scrolly + old_height);
			if(under < getFontMetrics(getFont()).getHeight()) under =0;
			scrollTo( doc.getHeight() -under - getHeight());
		}
	}

	/////////////////////////////////////
	// クリップボード
/*
	public void copy(){
		if(doc==null) return;
		String s= doc.getSelectedText();
		if(s.length()!=0) App.Copy(s);
	}
*/
	public String getSelectedText(){
		if(doc==null) return "";
		return doc.getSelectedText();
	}
	public void selectAll(){
		if(doc!=null) doc.selectAll();
	}
	//////////////////////////////////////////
	// implements java.awt.datatransfer.Transferable
	static DataFlavor[] my_DataFlavor = new DataFlavor[]
	{ DataFlavor.getTextPlainUnicodeFlavor(), };
	public DataFlavor[] getTransferDataFlavors()
	{ return my_DataFlavor; }
	public boolean isDataFlavorSupported(DataFlavor flavor)
	{ return my_DataFlavor[0].equals(flavor); }
	public Object getTransferData(DataFlavor flavor)
	throws UnsupportedFlavorException,java.io.IOException
	{return getSelectedText();}
}


