package buffer;
import java.awt.*;
import base.*;
import gui.*;
import java.util.*;
public abstract class StyleID{
	public abstract FontInfo2 findBaseStyle(String name);
	public abstract Color4 findCTCPColor(int fg,int bg);

	/////////////////////////
	// LbVNA
	public void clear(){
		for(int i=0;i<basestyle_cache.length;++i) basestyle_cache[i]=null;
		for(int i=0;i<pfm_color_cache.length;++i) pfm_color_cache[i]=null;
		font_cache.clear();
	}

	//////////////////////////////////////////
	// x[XX^C
	// X^C̖O64ʂoĂȂƂO
	// ƁAid 0g邱Ƃ͂Ȃ

	ByteMap     basestyle_nametoindex  = new ByteMap();
	FontInfo2[] basestyle_cache = new FontInfo2[64];
	public int setBaseStyle(String name){ 
		if(name==null) return -1;
		return basestyle_nametoindex.put(name);
	}
	public FontInfo2 getBaseStyle(int index){
		if(index<0) return null;
		FontInfo2   f=basestyle_cache[index];
		if(f==null) f=basestyle_cache[index]= findBaseStyle((String)basestyle_nametoindex.get(index));
		return f;
	}

	/////////////////////////////////////////////
	// ǉX^C

	// PFMFByteMapg
	ByteMap PFMColorMap=new ByteMap();
	Color4[] pfm_color_cache =new Color4[256];
	public int setPFMColor(Color c){ return PFMColorMap.put(c); }
	public Color4 getPFMColor (int i){
		Color4 f= pfm_color_cache[i];
		if(f==null) f=pfm_color_cache[i]=new Color4((Color)PFMColorMap.get(i));
		return f;
	}

	// CTCPF1oCgŕ\ł
	public int setCTCPColor1(int c1){ return c1; }
	public int setCTCPColor2(int c1,int c2){ return ((c2&15)<<4)|(c1&15); }

	public Color4 getCTCPColor1(int value)
	{ return findCTCPColor( (value&15) ,-1); }

	public Color4 getCTCPColor2(int value)
	{ return findCTCPColor( (value&15) ,((value>>4)&15) ); }



	// X^C̓oCgŕ\ł͈͂ɂ
	public int setFontStyle(int c ){ return c;}
	public int getFontStyle(int c ){ return c;}

	/////////////////////////////////////////////
	// 
	public static final int OPTION_STYLE     =0;
	public static final int OPTION_CTCPCOLOR1=1;
	public static final int OPTION_CTCPCOLOR2=2;
	public static final int OPTION_PFMCOLOR  =3;
	public static final int STYLE_TYPES=4; // vf

	public static int getOptionIDCount(){return STYLE_TYPES;}

	public int getFontStyle(PackedStyle ps){
		if( ps.optionid[OPTION_STYLE]!=-1) return getFontStyle(ps.optionid[OPTION_STYLE]);
		return getBaseStyle(ps.baseid).getFontStyle();
	}
	public String getFontName(PackedStyle ps){
		return getBaseStyle(ps.baseid).getFontName();
	}
	public int getFontSize(PackedStyle ps){
		return getBaseStyle(ps.baseid).getFontSize();
	}
	public Color4 getColor(PackedStyle ps){
		int b;
/*
		System.err.println(
			"c2="+ps.optionid[OPTION_CTCPCOLOR2]
			+" c1="+ps.optionid[OPTION_CTCPCOLOR1]
			+" pfm="+ps.optionid[OPTION_PFMCOLOR  ]
		);
*/
//			System.err.println(key+" fg="+fi.color.fg+" bg="+fi.color.bg);
		if((b=ps.optionid[OPTION_CTCPCOLOR2])!=-1) return getCTCPColor2(b);
		if((b=ps.optionid[OPTION_CTCPCOLOR1])!=-1) return getCTCPColor1(b);
		if((b=ps.optionid[OPTION_PFMCOLOR  ])!=-1) return getPFMColor(b);
		return getBaseStyle(ps.baseid).color;
	}

	/////////////////////////////////////////////
	LinkedList font_cache = new LinkedList();

	public Font getFont(PackedStyle ps){
		String name =getFontName  (ps);
		int    size =getFontSize  (ps);
		int    style=getFontStyle (ps)&FontInfo2.BASIC_MASK;
		long now = System.currentTimeMillis();
		FontCacheNode node;

		// ėpłȂ炻
		for(Iterator it=font_cache.iterator();it.hasNext();){
			node =(FontCacheNode)it.next();
			if( node.name.equals(name)
			&&  node.size==size
			&&  node.style== style
			){
				it.remove();
				node.ctime = now;
				font_cache.addFirst(node);
				return node.font;
			}
		}

		// Â̂x̂Ă
		while(font_cache.size()>20){
			node =(FontCacheNode)font_cache.getLast();
			if(now - node.ctime < 1000*60*3) break;
			font_cache.removeLast();
		}

		// V̂ǉ
		node=new FontCacheNode();
		node.name=name;
		node.size=size;
		node.style=style;
		node.font=new Font(name,style,size);
		node.ctime=now;
		font_cache.addFirst(node);
		return node.font;
	}

}

// tHgLbV
class FontCacheNode{
	String name;
	int size;
	int style;
	Font font;
	long ctime;
}

