// UTF-8 ☀☁☂☃
package dialog;
import bluntirc.*;
import irc.*;
import base.*;
import gui.*;
import java.io.File;
import java.awt.*;
import javax.swing.*;
import action.*;
import java.util.*;


////////////////////////////////////////////////////////////////////
// アプリケーションの環境設定ダイアログ
public class AppConfDialog extends DialogBase{
	public AppConfDialog(App node){
		super();
		setup(node,item_list);
	}
	String getSettingName(){ return App.config_AppName;}
	protected ConnTreeNode createNode(){ return null; } // 呼ばれない
	protected void CheckInputs_ok(){
		setTitle( getSettingName()+"の設定" );
	}
/*
	public void setBrowserFileName(String s){
		for(int i=0;i<items.length;++i){
			if(items[i].getCaption().equals("ブラウザ")){
				((JTextField)items_value[i]).setText(s);
				break;
			}
		}
	}
	public String getBrowserFileName(){
		for(int i=0;i<items.length;++i){
			if(items[i].getCaption().equals("ブラウザ")){
				return ((JTextField)items_value[i]).getText();
			}
		}
		return null;
	}
*/
	DialogEditItem[] item_list = new DialogEditItem[]{
		new DialogEditItem_TabSeparator("プログラム"),
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "UseMRJToOpenURL";}
			public String getCaption(){ return "URLを開くのにMRJFileUtils.openURLを使う";}
		},
		new DialogEditItem_FilePath(){
			public String getPropertyKey(){ return "BrowserName";}
			public String getCaption(){ return "ブラウザ";}
			public String getDesc(){ return "URLを開くのに使う";}
		},
		new DialogEditItem_FilePath(){
			public String getPropertyKey(){ return "TextEditorPath";}
			public String getCaption(){ return "エディタ";}
			public String getDesc(){ return "テキストを編集するのに使う";}
		},
		new DialogEditItem_FilePath(){
			public String getPropertyKey(){ return "FolderViewerPath";}
			public String getCaption(){ return "フォルダビューア";}
			public String getDesc(){ return "フォルダを開くのに使う";}
		},

		new DialogEditItem_FilePath(){
			public String getPropertyKey(){ return "PathDownloader";}
			public String getCaption(){ return "ダウンローダ";}
			public String getDesc(){ return "保存するのに使う";}
		},
		new DialogEditItem_FilePath(){
			public String getPropertyKey(){ return "PathWinamp";}
			public String getCaption(){ return "Winamp";}
			public String getDesc(){ return "末尾に /add を付けるのを推奨";}
		},
		new DialogEditItem_FilePath(){
			public String getPropertyKey(){ return "PathMediaPlayer";}
			public String getCaption(){ return "Media Player";}
			public String getDesc(){ return "ストリーミングを受信するのに使う";}
		},


		new DialogEditItem_TabSeparator("オプション"),
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "CommandSlash";}
			public String getCaption(){ return "コマンド開始文字";}
			public String getDesc(){ return "'/' が一般的";}
			public void checkValue(Component c) throws Exception {
				String s = ((JTextField)c).getText();
				if( s.length() != 1 )
					throw new Exception("コマンド開始文字は1文字でないといけない");
			}
		},
		new DialogEditItem_Button(){
			public String getCaption(){ return "自動op...";}
			public void actionPerformed(java.awt.event.ActionEvent e){
				ConnTreeNode node = getNode();
				if(node==null) return;
				node.property.setDefaultObject("autoOpWildcard",new LinkedList());
				new PropertyInspector(node.property,node.GetCaption()+"の自動op設定","autoOpWildcard",true,false,false);
				CheckInputs();
			}
		},


		new DialogEditItem_TabSeparator("ログファイル"),
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "LogFileEncoding";}
			public String getCaption(){ return "文字コード";}
			public String getDesc(){ return "UTF-8,MS932,MacTEC,EUC-JP 等";}
			public void checkValue(Component c) throws Exception {
				String enc = ((JTextField)c).getText();
				if( enc.length()==0) throw new Exception("ログの文字コードが指定されていない");
				try{
					String pre   ="～";
					String after =new String(pre.getBytes(enc),enc);
					if(!pre.equals(after)) throw new Exception("ログの文字コードは \"～\" をうまく変換できません");
				}catch(java.io.UnsupportedEncodingException ee){
					throw new Exception("ログの文字コードはこのシステムでは動きません");
				}
			}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "LogCRLF";}
			public String getCaption(){ return "ログファイルの改行コードをLFではなくCRLFにする";}
		},

		new DialogEditItem_TabSeparator("バッファ"),
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "LogSweepMax";}
			public String getCaption(){ return "バッファ行数";}
			public String getDesc(){ return "";}
			public void checkValue(Component c) throws Exception {
				if(((JTextField)c)	.getText().length()==0) throw new Exception("バッファ行数が記入されていない");
				int i;
				try{
					i= Integer.parseInt(((JTextField)c).getText());
				}catch(Exception ee){
					throw new Exception("バッファ行数を数値に変換できない");
				}
				if(i<1) throw new Exception("バッファ行数が小さすぎる");
			}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "ActivateBufferOnCreate";}
			public String getCaption(){ return "バッファが作成されたらアクティブにする";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "AllLog_ChocoaStingy";}
			public String getCaption(){ return "現在のバッファと同じメッセージを全てのメッセージに記録しない";}
		},

		////////////////////////////
		new DialogEditItem_TabSeparator("Look&Feel"),
		new DialogEditItem_ComboBox(){
			UIManager.LookAndFeelInfo[] list = UIManager.getInstalledLookAndFeels();
			public String getPropertyKey(){ return "LookAndFeel";}
			public String getCaption(){ return "Lool&Feel";}
			public String getDesc(){ return "UI部品の外見を変更します";}
			public boolean isEditable(){return false;}

			public String[] getCaptionList(){
				String[] r = new String[list.length];
				for(int i=0;i<r.length;++i){
					r[i]=list[i].getName();
				}
				return r;
			}
			public int getFirstSelected(Object prop_value){
				for(int i=0;i<list.length;++i){
					if(list[i].getClassName().equals(prop_value)) return i;
				}
				return -1;
			}
			public Object getListValue(int index){
				return list[index].getClassName();
			}
			public void checkValue(Component c) throws Exception {
				int index =((JComboBox)c).getSelectedIndex();
				if(index==-1){
					String s =((JTextField)((JComboBox)c).getEditor().getEditorComponent()).getText();
					for(int i=0;i<list.length;++i){
						if(list[i].getClassName().equals(s)) return;
					}
					throw new Exception("指定したLool&Feelはインストールされていない");
				}
			}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "TransparentSplitPaneUI";}
			public String getCaption(){ return "スプリッタを透明にする(要再起動)";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "TransparentScrollBarUI";}
			public String getCaption(){ return "スクロールバーを透明にする(要再起動)";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "UseMemberListIcon";}
			public String getCaption(){ return "チャンネルメンバ一覧にアイコンを表示する";}
		},

		new DialogEditItem_TabSeparator("ペイン配置(要再起動)"),

		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "AlloLogInMain";}
			public String getCaption(){ return "全てのメッセージを主ウィンドウの中に表示する";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "alllog_top";}
			public String getCaption(){ return "全てのメッセージを上に表示する ↑が有効な場合のみ";}
		},

		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "RightTree";}
			public String getCaption(){ return "バッファ一覧と参加者一覧を右に表示する";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "HorizontalLayout";}
			public String getCaption(){ return "バッファ一覧と参加者一覧を横に並べる";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "TopTree";}
			public String getCaption(){ return "バッファ一覧を参加者一覧の左(または上)に置く";}
		},
	};
}
