// UTF-8 ☀☁☂☃
package dialog;
import bluntirc.*;
import irc.*;
import base.*;
import gui.*;
import java.io.File;
import java.awt.*;
import javax.swing.*;
import action.*;
import java.util.*;


//================================================================================
// 接続先の設定ダイアログ
public class ConnDialog extends DialogBase{
	public ConnDialog(ConnTreeNode node){
		super();
		setup(node,item_list);
	}
	String getSettingName(){
		String name=null;
		for(int i=0;i<items.length;++i){
			if(items[i].getCaption().equals("設定の名前")){
				name = ((JTextField)items_value[i]).getText();
			}
		}
		if(name==null) name="(oops)";
		return name;
	}
	protected void CheckInputs_ok(){
		setTitle( getSettingName()+"の設定" );
	}
	protected ConnTreeNode createNode(){
		return ActionUtility.createConn(getSettingName());
	}

	DialogEditItem[] item_list = new DialogEditItem[]{
		new DialogEditItem_TabSeparator("接続先とユーザ情報"),
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "Name";}
			public String getCaption(){ return "設定の名前";}
			public String getDesc(){ return "バッファ一覧に表示される名前";}
			public void checkValue(Component c) throws Exception{
				if(((JTextField)c).getText().length()==0) throw new Exception("設定の名前が記入されていない");
			}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "Server";}
			public String getCaption(){ return "IRCサーバのアドレス";}
			public String getDesc(){ return "接続先のIRCサーバのホスト名";}
			public void checkValue(Component c) throws Exception{
				if(((JTextField)c).getText().length()==0) throw new Exception("サーバホスト名が記入されていない");
				if(ContainSpace(((JTextField)c).getText())) throw new Exception("サーバホスト名に空白が含まれている");
			}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "Port";}
			public String getDefaultValue(){ return "6667";}
			public String getCaption(){ return "IRCサーバのポート番号";}
			public String getDesc(){ return "接続先のIRCサーバのポート番号";}
			public void checkValue(Component c) throws Exception{
				if(((JTextField)c)	.getText().length()==0) throw new Exception("サーバポート番号が記入されていない");
				int i;
				try{
					i= Integer.parseInt(((JTextField)c).getText());
				}catch(Exception ee){
					throw new Exception("サーバのポート番号を数値に変換できない");
				}
				if(i<=0) throw new Exception("サーバのポート番号の値がおかしい");
			}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "Nick";}
			public String getCaption(){ return "ニックネーム";}
			public String getDesc(){ return "あなたのニックネーム";}

			public void checkValue(Component c) throws Exception{
				if(((JTextField)c).getText().length()==0)   throw new Exception("ニックネームが記入されていない");
				if(ContainSpace(((JTextField)c).getText())) throw new Exception("ニックネームに空白が含まれている");
			}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "Password";}
			public String getCaption(){ return "パスワード";}
			public String getDesc(){ return "あなたのパスワード";}

			public void checkValue(Component c) throws Exception {
				if(ContainSpace(((JTextField)c).getText())) throw new Exception("パスワードに空白が含まれている");
			}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "UserName";}
			public String getCaption(){ return "UserName";}
			public String getDesc(){ return "prefixに表示される名前";}

			public String getDefaultValue(){ return App.config_AppName;}
			public void checkValue(Component c) throws Exception {
				if(((JTextField)c).getText().length()==0) throw new Exception("UserNameが記入されていない");
				if(ContainSpace(((JTextField)c).getText())) throw new Exception("UserNameに空白が含まれている");
			}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "RealName";}
			public String getCaption(){ return "RealName";}
			public String getDesc(){ return "/whoすると表示される名前";}

			public String getDefaultValue(){ return App.config_AppName;}
			public void checkValue(Component c) throws Exception {
				if(((JTextField)c).getText().length()==0) throw new Exception("RealNameが記入されていない");
			}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "UserMode";}
			public String getCaption(){ return "ユーザモード";}
			public String getDesc(){ return "無記入 または +i";}
		},

		new DialogEditItem_TabSeparator("オプション"),

		new DialogEditItem_String(){
			public String getPropertyKey(){ return "QuitMessage";}
			public String getCaption(){ return "切断メッセージ";}
			public String getDesc(){ return "";}
			public String getDefaultValue(){ return App.config_AppName+"終了";}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "PartMessage";}
			public String getCaption(){ return "退出メッセージ";}
			public String getDesc(){ return "チャンネル退出時に使用";}
			public String getDefaultValue(){ return "so long";}
		},

		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "ConnectOnStartUp";}
			public String getCaption(){ return "起動時に接続開始する";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "dumpRecvLine";}
			public String getCaption(){ return "stderrに生の通信を出力する";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "AllowEmptyTalk";}
			public String getCaption(){ return "空の発言でもサーバに送る";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "IgnoreInvite";}
			public String getCaption(){ return "招待を無視する";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "IgnoreCTCP";}
			public String getCaption(){ return "CTCPに応答しない";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "IgnoreDCC";}
			public String getCaption(){ return "DCCに応答しない";}
		},

		new DialogEditItem_TabSeparator("切断対策"),
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "AutoReconnect";}
			public String getCaption(){ return "自動再接続";}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "SoTimeout";}
			public String getDefaultValue(){ return "360000";}
			public String getCaption(){ return "無通信タイムアウト";}
			public String getDesc(){ return "単位はミリ秒 0=タイムアウトなし";}
			public void checkValue(Component c) throws Exception {
				if(((JTextField)c)	.getText().length()==0) throw new Exception("無通信タイムアウトが記入されていない");
				int i;
				try{
					i= Integer.parseInt(((JTextField)c).getText());
				}catch(Exception ee){
					throw new Exception("無通信タイムアウトを数値に変換できない");
				}
				if(i<0) throw new Exception("無通信タイムアウトの指定が0より小さい");
			}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "ForcePongToServer";}
			public String getCaption(){ return "PONG送信間隔";}
			public String getDefaultValue(){ return "120";}
			public String getDesc(){ return "指定した秒数ごとにサーバにPONGを送る <=0で無効";}
			public void checkValue(Component c) throws Exception {
				if(((JTextField)c)	.getText().length()==0) throw new Exception("PONG送信間隔が記入されていない");
				int i=0;
				try{
					i= Integer.parseInt(((JTextField)c).getText());
				}catch(Throwable ee){
					throw new Exception("PONG送信間隔を数値に変換できない");
				}
				if(i>0 && i<10) throw new Exception("PONG送信間隔はFlood防止のため0か10秒以上にしてください");
			}
		},


		new DialogEditItem_TabSeparator("管理"),
		new DialogEditItem_Button(){
			public String getCaption(){ return "自動op...";}
			public void actionPerformed(java.awt.event.ActionEvent e){
				ConnTreeNode node = getNode();
				if(node==null) return;
				node.property.setDefaultObject("autoOpWildcard",new LinkedList());
				new PropertyInspector(node.property,node.GetCaption()+"の自動op設定","autoOpWildcard",true,false,false);
				CheckInputs();
			}
		},

	};
}
