package gui;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
//import java.beans.*;
//import javax.swing.tree.*;
//import com.smilemark.util.*;
//import com.smilemark.IRC.*;
import gui.*;

public class ImagePanel extends JLabel{
	ImageIcon icon;
	Color c;
	double wx,wy; // 画像を右下に寄せる度合い 1で完全に右下
	public int mode=1;
/*
	ImagePanel(Color bg,ImageIcon _i){
		super(_i);
		setBackground(bg);
		icon=_i;
		wx = 1;
		wy = 1;
	}
*/
	Component root;
	public ImagePanel(Component root){
		super();
		this.root = root;
		setOpaque(true);
		setBackground(SystemColor.window);
		wx = 1;
		wy = 1;
	}
	public void reloadBGInfo(BGInfo bg){
		setBackground(bg.color);
		icon=bg.image;
		repaint();
	}
	public void paint(Graphics g){
		Dimension sz = getSize();
		if(sz.width < 1 || sz.height <1) return;
		g.setColor(getBackground());
		if(icon==null){
			g.fillRect(0,0,sz.width,sz.height);
		}else{
			switch(mode){
			case 0: // 拡大する
				{
					double szw = sz.width;
					double szh = sz.height;
					double ih = icon.getIconHeight();
					double iw = icon.getIconWidth();
					int tw,th;
					int loop,amari;
					if( (iw/ih) > (szw/szh) ){
						th =(int)( ih*(szw/iw));
						tw = sz.width;
						loop  = sz.height / th;
						amari = sz.height % th;
						if(th > 0){
							int ys = (int)(amari*wy);
							int yl = amari-ys;
							if(ys >0) g.fillRect(0,0,sz.width,ys);
							while(loop-- >0){
								g.drawImage(icon.getImage(),0,ys,tw,th,this);
								ys += th;
							}
							if(yl>0) g.fillRect(0,sz.height-yl,sz.width,yl);
						}
					}else{
						tw = (int)(iw*(szh/ih));
						th = sz.height;
						loop  = sz.width / tw;
						amari = sz.width % tw;
						if(tw > 0){
							int xs = (int)(amari*wx);
							int xl = amari-xs;
							if(xs >0) g.fillRect(0,0,xs,sz.height);
							while(loop-->0){
								g.drawImage(icon.getImage(),xs,0,tw,th,this);
								xs += tw;
							}
							if(xl>0) g.fillRect(sz.width-xl,0,xl,sz.height);
						}
					}
				}
				break;
			case 1:
				if(root==null){
					int szw = sz.width;
					int szh = sz.height;
					int ih = icon.getIconHeight();
					int iw = icon.getIconWidth();
					for(int y=0;y<szh;y+=ih)
					for(int x=0;x<szw;x+=iw)
					{
						int tx = szw -x ; if(tx > iw ) tx = iw;
						int ty = szh -y ; if(ty > ih ) ty = ih;
						g.drawImage(icon.getImage()
							,x,y
						//	,tx,ty
						//	,0,0,tx-1,ty-1
							,getBackground()
							,this
						);
					}
				}else{
				//	Point areaStart = SwingUtilities.convertPoint(this,0,0,root);

					Rectangle clip=SwingUtilities.convertRectangle(this,g.getClipBounds(),root);
					if(clip.width<1 || clip.height<1) return;
					int szw = sz.width;
					int szh = sz.height;
					int ih = icon.getIconHeight();
					int iw = icon.getIconWidth();
					int xs=0; while(xs+iw <= clip.x) xs+=iw;
					int ys=0; while(ys+ih <= clip.y) ys+=ih;
					int xe=clip.x+clip.width;
					int ye=clip.y+clip.height;
					for(int x=xs;x<xe;x+=iw)
					for(int y=ys;y<ye;y+=ih)
					{
					//	int tx = szw -x ; if(tx > iw ) tx = iw;
					//	int ty = szh -y ; if(ty > ih ) ty = ih;
						Point drawStart = SwingUtilities.convertPoint(root,x,y,this);
						g.drawImage(icon.getImage()
							,drawStart.x,drawStart.y
						//	,tx,ty
						//	,0,0,tx-1,ty-1
							,getBackground()
							,this
						);
					}
				}
			}
		}
		paintChildren(g);
	}
	public Dimension getPreferredSize(){
		return getComponent(0).getPreferredSize();
	}
	public Dimension getMaximumSize(){
		return getComponent(0).getMaximumSize();
	}
	public Dimension getMinimumSize(){
		return getComponent(0).getMinimumSize();
	}
}
