// UTF-8 ☀☁☂☃
package irc;
import java.io.*;
import java.util.*;
import java.net.*;
import java.text.*;
import base.*;

// CTCPで定義されている、メッセージ中の特殊文字のクォート
public class CTCPQuote{

	// クォートして書き込む
	public static void encodeParam(
		ByteArrayOutputStream bao // 出力先
		,byte[] src,int start,int end // 入力
		,boolean noEscapeSpace // 空白を 0x10 +'@' にしないなら真
	){
		for(int i=0;i<src.length;++i){
			switch(src[i]){
			case 0x10: bao.write(0x10);bao.write(0x10);continue;
			case 0: bao.write(0x10);bao.write((byte)'0');continue;
			case '\n': bao.write(0x10);bao.write((byte)'n');continue;
			case '\r': bao.write(0x10);bao.write((byte)'r');continue;
			}
			if(src[i]==' ' && !noEscapeSpace ){
				bao.write(0x10);
				bao.write((byte)'@');
				continue;
			}
			if(src[i]==1){
				bao.write(0x10);
				bao.write((byte)'1');
				continue;
			}
			bao.write(src[i]);
		}
	}

	// クォートされたものを元に戻す
	public static void decodeParam(
		ByteArrayOutputStream bao     // 出力先
		,byte[] ba,int start,int end  // 入力
	){
		boolean escapeP=false;
		for(int j=start;j<end;++j){
			byte c=ba[j];
			if(!escapeP){
				if(c==0x10){
					escapeP=true;
					continue;
				}
			}else{
				escapeP=false;
			//	System.err.println("escape "+(char)c);
				switch(c){
				case '0':  c=0;    break;
				case '1':  c=1;    break;
				case 'n':  c='\n'; break;
				case 'r':  c='\r'; break;
				case '@':  c=' '; break;
				case 0x10: c=0x10; break;
				default: bao.write(0x10);break;
				}
			}
			bao.write(c);
		}
	}

/*
	public static String unQuoteString(byte[] ba,int start,int end){
		ByteArrayOutputStream bao=new ByteArrayOutputStream();
		writeUnQuote(bao,ba,start,end);
		byte[] b= bao.toByteArray();
		return Util.fromJIS(b);
	}
*/

}
