// UTF-8 ☀☁☂☃
package irc;
import java.util.TimeZone;

// イベントリスナー
public interface IRCConnectionListener{
	// パラメータの指定
	public TimeZone getTimeZone(IRCConnection conn); //TimeZone.getTimeZone("JST");
	public String getServerHost(IRCConnection conn);
	public int    getServerPort(IRCConnection conn);
	public String getLocalHost(IRCConnection conn);
	public int    getLocalPort(IRCConnection conn);
	public int    getSoTimeout(IRCConnection conn); // デフォルト0かな

	public String getNickName(IRCConnection conn,boolean isFirst); //isFirstでないなら呼ばれる度に違うnickを返すこと
	public String getPassword(IRCConnection conn); //isFirstでないなら呼ばれる度に違うnickを返すこと
	public String getUserName(IRCConnection conn);
	public String getRealName(IRCConnection conn);
	public String getMyUserMode(IRCMessage m); // 接続直後にユーザモードを指定するなら "+i"のように。指定しないならnull

	public String getConnectionName(IRCConnection conn); // 接続の名称
	public String getCTCPReplyVersion(IRCMessage m); // CTCP Version への応答
	public String getCTCPReplyFinger(IRCMessage m);
	public String getCTCPReplyUserInfo(IRCMessage m);

	public boolean isAutoReconnect(IRCConnection conn);
	public boolean isDumpRecvLine(IRCConnection conn);
	public boolean isDumpRecvCTCP(IRCConnection conn);
	public boolean isDontParseCTCP(IRCConnection conn);
	public boolean isQuoteAllParam(IRCConnection conn); // false推奨 送受信ともにすべての引数をクォート/デクォートする
	public boolean isQuoteSpace(IRCConnection conn); //false推奨  メッセージ送信時に引数の中の空白をクォートする
	public boolean isQuoteSpaceAtCTCPArg(IRCConnection conn);//false推奨 CTCP送信時に引数の間の空白をクォートする
	public boolean isQuote001(IRCConnection conn); //true推奨


	public base.SelectorRun getSelector();

	// チャンネルのイベント
	public void onChannelKicked(IRCMessage m); // grep RejoinOnKicked

	// CTCP応答キューの制限
	// TimeExpire 秒に LimitInTime 個までしかCTCPに応答しない
	// また、1つのメッセージに埋め込まれたCTCPの個数が MaxInLine 以上になると応答しない
	public int getCTCPSendCueTimeExpire(IRCConnection c); // 60
	public int getCTCPSendCueLimitInTime(IRCConnection c); // 20 
	public int getCTCPSendCueMaxInLine(IRCConnection c); //4

	// フック
	public IRCMessage rewriteIRCMessage1(IRCMessage message);
	public IRCMessage rewriteIRCMessage2(IRCMessage message);
	// rewriteIRCMessage1の時点では出力コンテキストは決まっていない
	// (実際にはCTCPの場合は既にあるのだが、利用しないほうがいい)

	//ログ表示
	public void OnLogEvent(IRCMessage m,Object to,IRCLogContext buffer_id);

	// 接続とチャンネルの状態変化
	public void OnConnectRequest(IRCConnection conn);
	public void OnConnectAuthorized(IRCMessage m);
	public void OnConnectMOTDEnd(IRCMessage m);

	public void OnDisconnect	(IRCConnection conn);
	public void initIRCChannel		(IRCConnection conn,IRCChannel c);
	public void RemoveChannel	(IRCConnection conn,IRCChannel c);
	// ユーザ自身のチャンネルの出入り
	public void ChangeChannelJoin(IRCConnection conn,IRCChannel c,boolean is_in);
	public void ChangeNickMyself (IRCMessage m);

	// チャンネル内のユーザリストの変化
//ChangeUserInfo のfromがnullで 	public void AddUserList		(IRCConnection conn,IRCChannel c,IRCChannelMember who);
	public void RemoveUserList	(IRCConnection conn,IRCChannel c,IRCChannelMember who);
	public void ChangeUserInfo	(IRCConnection conn,IRCChannel c,byte[] fromNick,IRCChannelMember to);

	// ユーザの情報
	public void onChangePrefix(IRCConnection conn,IRCUser who,int i);
	public void OnWhoReply(IRCMessage m,IRCChannel c,IRCUser who);

	// チャンネルのトピック設定
	public void ChangeTopic(IRCMessage m,IRCChannel c);
	public void SetChannelMode(IRCMessage m,IRCChannel c);

	// CTCP PING のリプライを読む
	public void checkCTCPPingReply(IRCMessage ctcp);

	// DCC リクエストを読む
	public void checkDCC(IRCMessage ctcp);
}
