// UTF-8 ☀☁☂☃
package irc;
import java.io.*;
import java.util.*;
import base.*;

// サーバから受け取ったメッセージ
public class IRCMessage{
	//---------------------------------------------
	// サーバから受け取った内容(解析前)
	public GregorianCalendar time;
	public String getTimeStr(){ return Util.GetTimeStr(time); }
	public String getDateStr(){ return Util.getDateStr(time); }

	public IRCConnection conn;
	public byte[] line;
	public IRCUser from;
	public String cmd;
//	int num=-1; // コマンドの数値
	public Vector ctcp; // CTCP

	public String params_str; // パラメータ全体を何も考えずに文字列にしたもの
	protected Vector params;
	public byte[] getParam(int index){return (byte[])params.get(index);}
	public int    size(){return params.size();}
	public void checkSize(int need)throws IndexOutOfBoundsException{
		if(size()<need) throw new IndexOutOfBoundsException(
			"server returns command with too few args : cmd="+cmd
			+" need="+need+" now="+size()
			+" plain_line="+Util.fromJIS(line)
		);
	}

	// 内部で捏造する場合につかう
	public IRCMessage(IRCConnection conn,String cmd,String log_msg){
		this.conn =conn;
		this.from = conn.findUser(Util.AsciiToByteArray("*local*"));
		this.time=new GregorianCalendar(conn.getListener().getTimeZone(conn));
		this.cmd = cmd;
		this.params_str = this.log_msg =log_msg ;
	}

	// サーバから受け取ったならこちら
	public IRCMessage(IRCConnection conn,byte[] ba){
		this.conn =conn;
		this.time=new GregorianCalendar(conn.getListener().getTimeZone(conn));
		readFromBytes(ba);
	}

	// CTCPを作成する場合
	boolean ctcp_is_request; //要求か応答か
	protected IRCMessage(IRCMessage src,byte[] ba,int index){
		this.conn =src.conn;
		this.time = src.time;
		this.line = ba;
		this.from = src.from;
		this.ctcp_index = index;
		this.log_from =  src.log_from;
		this.log_to =    src.log_to;
		this.log_context = src.log_context;
		this.target = new Vector(0);
		this.ctcp_is_request = (0==src.cmd.indexOf("PRIVMSG"));

		// cmd,params,params_str を用意する
		int end=0;
		// タグを読む
		int start=end;while(end<ba.length && ba[end] !=' ') ++end;
		cmd = "CTCP_"+Util.fromJIS(ba,start,end);
		while(end<ba.length && ba[end] ==' ') ++end;
		// CTCPの場合、残りは単一の引数とみなす
		params =new Vector();
		params.add(Util.ByteSubString(ba,end,ba.length));
		log_msg=params_str=Util.fromJIS(getParam(0));
		// ここまで、クォートかかったまま受信している
	}


	// toStringする際に各引数の手前に配列インデクスを表記するか
	boolean config_checkParamsCount =true;

	// 主にデバッグ用
	public String toString(){
		StringBuffer pb = new StringBuffer();
		pb.append(Util.GetTimeStr(time));
		pb.append(' ');


		// サーバからのメッセージはfromを表示しない
		if(from!=null){
			if( conn.fromServer != null 
			&& 	conn.fromServer.equals(from)
			){
			}else{
				pb.append(from.getNick());
			}
		}
		pb.append(">");
		pb.append(cmd);
		if(params!=null){
			int start =0;
			// 最初の引数が自分のニックと同じなら表示しない
			if( conn.myself !=null
			&& size() >0
			&&  conn.myself.equals( getParam(start) )
			){
				++start;
				pb.append("*");
			}else{
				pb.append(" ");
			}
			for(int i=start;i<size();++i){
				if(config_checkParamsCount){
					pb.append("("+i+")");
				}else if(i!=start){
					pb.append(' ');
				}
				pb.append(Util.fromJIS(getParam(i)));
			}
		}
		return new String(pb);
	}



	// 受け取ったバイト列の行を区切る
	public void readFromBytes(byte[] ba){
		// 生の受信行を記憶しておく
		this.line = ba;

		int total=ba.length;
		int p = 0;
		int start;
		// prefix を読む
		if(ba[p] == ':'){
			start = ++p;
			while( p<total && ba[p] != ' ') ++p;
			byte[] prefix_bytes = Util.ByteSubString(ba,start,p);
			while( p<total && ba[p] == ' ') ++p;
			// 最初のprefixを覚えておく
			if( conn.FirstPrefix==null) conn.FirstPrefix= prefix_bytes;
			from = conn.findUser(prefix_bytes);
		}else{
			from=conn.findUser(conn.FirstPrefix!=null?conn.FirstPrefix:Util.AsciiToByteArray("*server*"));
		}

		// コマンドを読む
		{
			start = p;
			while( p<total && ba[p] != ' ') ++p;
			cmd = Util.fromJIS(ba,start,p);
			while( p<total && ba[p] == ' ') ++p;
		}
		// numeric なら手前の 0 を取り除く
		{
			boolean isNumeric = true;
			for(int i=0;i<cmd.length();++i){
				if(!Character.isDigit(cmd.charAt(i)) ){
					isNumeric=false;
					break;
				}
			}
			if(isNumeric) cmd = Integer.toString(Integer.parseInt(cmd));
		}

		// 残りの部分は引数
		int params_start =p;
		params_str = Util.fromJIS(ba,params_start,total);
		params=new Vector();

		// CTCPの関係があるキーワードかどうか
		if(cmd.equals("PRIVMSG")
		|| cmd.equals("NOTICE")
		){
			//引数は2つと決まっている
			start = p;
			while( p<total && ba[p] != ' ') ++p;
			// 出力先のクォートの解除は推奨しない…
			if(conn.getListener().isQuoteAllParam(conn)){
				ByteArrayOutputStream bao=new ByteArrayOutputStream();
				CTCPQuote.decodeParam(bao,ba,start,p);
				byte[] b= bao.toByteArray();
			}else{
				params.add( Util.ByteSubString(ba,start,p));
			}

			while( p<total && ba[p] == ' ') ++p;
			if(p<total && ba[p] == ':') ++p;
			// 2つめの引数からCTCPを分離する
			{
				ByteArrayOutputStream bao=new ByteArrayOutputStream();
				for(int i=p;i<total;++i){
					// CTCPでない部分
					start=i;while(i<ba.length && ba[i]!=1)++i;
					if(i>start) CTCPQuote.decodeParam(bao,ba,start,i);
					// %01 を読み飛ばす
					if(++i<total){
						// CTCPの部分
						start=i;while(i<ba.length && ba[i]!=1)++i;
						if(i>start){
							if(this.ctcp==null) this.ctcp=new Vector();
							this.ctcp.add(Util.ByteSubString(ba,start,i));
						}
					}
				}
				params.add(bao.toByteArray());
			}
		}else{
			// 残りの引数を読む
			for(;;){
				while( p<total && ba[p] == ' ') ++p;
				if( p>=total ) break;
				start=p;
				if( ba[p] == ':' ){
					++start;
					p=total;
				}else{
					while( p<total && ba[p] != ' ') ++p;
				}

				if(conn.getListener().isQuoteAllParam(conn)){
					//クォートの解除を行う。推奨しない。
					ByteArrayOutputStream bao=new ByteArrayOutputStream();
					CTCPQuote.decodeParam(bao,ba,start,p);
					byte[] b= bao.toByteArray();
				}else{
					// クォートを解除しない。
					params.add( Util.ByteSubString(ba,start,p));
				}
			}
		}
	}

	//------------------------------------
	// CTCPを取り出す
	int ctcp_index;
	public IRCMessage[] getCTCP(){
		if(ctcp==null) return null;
		IRCMessage[] result = new IRCMessage[ctcp.size()];
		for(int i=0;i<ctcp.size();++i){
			byte[] ba= (byte[])ctcp.get(i);
			result[i] =new IRCMessage(this,ba,i);
		}
		return result;
	}


	//---------------------------------------------
	// ログ出力に使うパラメータ
	public Object                 log_context =null; // 主な出力先
	public IRCChannelNameOrPrefix log_from; // 送信者
	public IRCChannelNameOrPrefix log_to;   // for NICK and priv
	public String                 log_msg; //表示するメッセージ

	public boolean hideMessage =false;
	//---------------------------------------------
	public String getTrail(int index){
		StringBuffer sb = new StringBuffer();
		for(;index<size();++index){
			sb.append( Util.fromJIS(getParam(index)));
			if(index!=size()-1) sb.append(' ');
		}
		return new String(sb);
	}

	//------------------------------------
	// メッセージの出力先を登録する
	public Vector target=new Vector();  // IRCChannelか IRCChannelNameか IRCUser か IRCConnection
	public IRCMessage addContext(Object t){
		if(t!=null){
			target.add(t);
		}
		return this;
	}
	// チャンネル宛のメッセージであることを示す
	public IRCChannel setChannelContext(byte[] name){
		IRCChannel chan = conn.FindChannel(name,true);
		log_context = chan;
		log_to = chan.getCName();
		addContext(chan);
		return chan;
	}

	public boolean log_dupForAllLog =false; // toごとに全ログに表示するなら真

	// メッセージのログをIRCConnectionListener、つまりIRC*の利用者に伝える
	public void sendLogToListener(){
		if(hideMessage) return;
		int t = target.size();
		if(t==0){
			conn.getListener().OnLogEvent(this,conn,IRCLogContext.LB_All);
			conn.getListener().OnLogEvent(this,conn,IRCLogContext.LB_Conn);
			conn.getListener().OnLogEvent(this,conn,IRCLogContext.LF_Conn);
			conn.getListener().OnLogEvent(this,conn,IRCLogContext.LB_Dump);
			conn.getListener().OnLogEvent(this,conn,IRCLogContext.LF_Dump);
			return;
		}

		Object to=target.get(0);
		if(log_context!=null){
			log_dupForAllLog=false;
			to = log_context;
		}

		if(!log_dupForAllLog){
			conn.getListener().OnLogEvent(this,to,IRCLogContext.LB_Dump);
			conn.getListener().OnLogEvent(this,to,IRCLogContext.LF_Dump);
			conn.getListener().OnLogEvent(this,to,IRCLogContext.LB_All);
		}

		for(int i=0;i<t;++i){
			to = target.get(i);
			if(log_dupForAllLog){
				conn.getListener().OnLogEvent(this,to,IRCLogContext.LB_Dump);
				conn.getListener().OnLogEvent(this,to,IRCLogContext.LF_Dump);
				conn.getListener().OnLogEvent(this,to,IRCLogContext.LB_All);
			}

			if(to instanceof IRCConnection){
				conn.getListener().OnLogEvent(this,to,IRCLogContext.LB_Conn);
				conn.getListener().OnLogEvent(this,to,IRCLogContext.LF_Conn);
			}else if(to instanceof IRCChannel){
				IRCChannel chan=(IRCChannel)to;
				if(chan.isChannel()){
					conn.getListener().OnLogEvent(this,to,IRCLogContext.LB_Chan);
					conn.getListener().OnLogEvent(this,to,IRCLogContext.LF_Chan);
				}else{
					conn.getListener().OnLogEvent(this,to,IRCLogContext.LB_Priv);
					conn.getListener().OnLogEvent(this,to,IRCLogContext.LF_Priv);
				}
			}
		}
	}
}

