// UTF-8 ☀☁☂☃
package irc;
import java.io.*;
import java.util.*;
import base.*;

// メッセージごとの処理

public abstract class IRCMessageReader{
	public static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("irc.ircmessagereader");
	static{ logger.setLevel(null); }

	// イベントハンドラ
	abstract public void 
	dispach(IRCMessage message)
	throws IndexOutOfBoundsException;

	//--------------------------------------------------------
	// static な部分でハンドラの集合を取り扱う
	protected static Map map=new HashMap();

	// メッセージを処理する
	public static int checkMessage(IRCMessage m){
		m.log_from = m.from;
		int count = 0;
			LinkedList v=(LinkedList)map.get(m.cmd);
			if(v==null) return 0;
			for(int i=0;i<v.size();++i){
				IRCMessageReader r=(IRCMessageReader)v.get(i);
				try{
					r.dispach(m);
				}catch(IndexOutOfBoundsException e){
					m.conn.Log("OnError",e.getMessage());
					break;
				}
				++count;
			}
		return count;
	}


	// 指定した位置に追加
	public static void add(String key,IRCMessageReader r,int index){
			LinkedList v=(LinkedList)map.get(key);
			if(v==null) map.put(key,v=new LinkedList());
			for(int i=0;i<v.size();++i){
				if(r==v.get(i)){
					v.remove(i);
					break;
				}
			}
			if(index<0) index += v.size()+1;
			if(index<0)  index=0;
			if(index >=v.size()){
				v.add(r);
			}else{
				v.add(index,r);
			}
	}
	public static void remove(String key,IRCMessageReader r){
			LinkedList v=(LinkedList)map.get(key);
			if(v==null) map.put(key,v=new LinkedList());
			for(int i=0;i<v.size();++i){
				if(r==v.get(i)){
					v.remove(i);
					break;
				}
			}
	}

	public static Vector DivString(String key){
		Vector r=new Vector();
		StreamTokenizer in = new StreamTokenizer(new StringReader(key));
		in.resetSyntax();
		in.wordChars('0', '9');
		in.wordChars('a', 'z');
		in.wordChars('A', 'Z');
		in.wordChars('_', '_');
		in.whitespaceChars(' ', ' ');
		in.whitespaceChars('\t', '\t');
		in.whitespaceChars('\n', '\n');
		in.whitespaceChars('\r', '\r');
		in.parseNumbers();
		in.eolIsSignificant(true);
		in.slashStarComments(true);
		in.slashSlashComments(true);
		for(;;){
			try{
				int type= in.nextToken();
				if(type== StreamTokenizer.TT_EOF) break;
				switch(type){
				case StreamTokenizer.TT_NUMBER:
					r.add(""+(int)in.nval);
					break;
				case StreamTokenizer.TT_WORD:
					r.add(in.sval);
					break;
				}
			}catch(IOException e){
				logger.log(java.util.logging.Level.SEVERE,"parse error in DivString key="+key,e);
			}
		}
		return r;
	}

	// 複数のキーにまとめて追加
	static StringBuffer log_sb = new StringBuffer();
	public static void add(String key,IRCMessageReader r){
		Vector keys = DivString(key);
		for(int i=0;i<keys.size();++i){
			key = (String)keys.get(i);
			log_sb.append(" "+key);
			add(key,r,-1);
		}
	}

	// メッセージごとの処理を登録する
	public static void init(){
		log_sb.append("entry IRCMessageReader: ");
		//  "Welcome to the Internet Relay Network <nick>!<user>@<host>"
		IRCMessageReader.add("1",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.conn.fromServer=m.from;
				m.checkSize(1);
				byte[] text = m.getParam(m.size()-1);
				int s=text.length;
				while(s>0 && text[s-1]!= ' ') --s;
				m.conn.myself = m.conn.findUser( Util.ByteSubString(text,s,text.length) );
				m.conn.getListener().ChangeNickMyself(m);
				m.conn.host001 = Util.fromJIS(m.conn.myself.getHostBytes());
				m.addContext(m.conn);
				m.conn.ConnAuthorized(m);
			}
		});
		//"Your host is <servername>, running version <ver>" 
		IRCMessageReader.add("2",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.log_msg = m.getTrail(1);
				String key = "Your host is ";
				int start = m.log_msg.indexOf(key);
				if(start!=-1){
					start += key.length();
					int i=start;
					while(i<m.log_msg.length() && -1==" ,".indexOf(m.log_msg.charAt(i))) ++i;
					if(i>start){
						m.conn.fromServer= m.conn.findUser(Util.AsciiToByteArray(m.log_msg.substring(start,i)));
						m.conn.Log("OnServerName",m.conn.fromServer.getEscapedName());
					}
				}
			}
		});
		// 464 Password incorrect
		IRCMessageReader.add("464",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.log_msg = m.getTrail(1);
				if(m.conn.myself == null){
					m.conn.fAutoReconnect =false;
					m.params_str +="(認証に失敗したようです。自動再接続を無効にします。)";
				}
			}
		});

		//"This server was created <date>" 
		//"<servername> <version> <available user modes> <available channel modes>" 
		IRCMessageReader.add("3,4",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
			}
		});

		// end of motd , no motd
		IRCMessageReader.add("376,422",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.conn.SendToServer(m.conn.encodeString("WHO "+m.conn.myself.getName()));
				m.conn.getListener().OnConnectMOTDEnd(m);
			}
		});

		// nick conflict
		IRCMessageReader.add("433",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				if(m.conn.myself==null){
					m.conn.SetNick( m.conn.getListener().getNickName(m.conn,false));
				}
			}
		});

		// who reply
		IRCMessageReader.add("352",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.checkSize(6);

				byte[] sender    = m.getParam(0);
				byte[] channel   = m.getParam(1);
				byte[] loginname = m.getParam(2);
				byte[] host      = m.getParam(3);
				byte[] server    = m.getParam(4);
				byte[] nick      = m.getParam(5);
				byte[] homegone  = m.getParam(6); // Home/Gone,チャンネルに対してwhoした場合は@または+がつく場合もある
				String RealName;
				if(homegone[0] >='A' && homegone[0] <='Z' ){
					RealName =  m.getTrail(7);
				}else{
					homegone=new byte[]{'?'};
					RealName =  m.getTrail(6);
				}
				// RealName とhopcount を分離する
				int hopcount = -1;
				int pos = RealName.indexOf(' ');
				if(pos!=-1 && pos >0 ){
					for(int i=0;i<pos;++i){
						char c=RealName.charAt(i);
						if(c<'0'|| c>'9'){
							hopcount=-2;
							break;
						}
					}
					if(hopcount==-1){
						hopcount= Integer.parseInt( RealName.substring(0,pos));
						RealName = RealName.substring(pos+1);
					}
				}
				// nick,loginname,host からprefixを組む
				IRCUser user;
				try{
					ByteArrayOutputStream ba=new ByteArrayOutputStream();
					ba.write(nick);
					ba.write((byte)'!');
					ba.write(loginname);
					ba.write((byte)'@');
					ba.write(host);
					user = m.conn.findUser(ba.toByteArray());
				}catch(Exception e){
					logger.log(java.util.logging.Level.WARNING,"paese who reply",e);
					user = m.conn.findUser(nick);
				}
				// prefixに情報を書いておく
				user.setWhoReply(server,hopcount,RealName,homegone);

				m.log_msg = "server="+Util.fromJIS(server)+" hop="+hopcount+" realname="+RealName;
				m.log_to  = user;

				boolean found=false;

				IRCChannel chan = m.conn.FindChannel(channel,false);
				// 知っているチャンネル宛だった
				if(chan!=null && chan.OnWhoReply(m,user) ){
					m.log_context = chan;
					m.conn.getListener().OnWhoReply(m,chan,user);
				}else{
					m.conn.getListener().OnWhoReply(m,null,user);
				}
			}
		});

		// names
		IRCMessageReader.add("353",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				if(m.size() <2) return;
				byte[] channel_type = m.getParam(1);
				IRCChannel chan = m.setChannelContext(m.getParam(2));

				m.log_msg = m.getTrail(0);
				for(int i=3;i<m.size();++i){
					byte[] left = m.getParam(i);
					int start = 0;
					int p=0;
					for(;;){
						while(p<left.length && ' ' ==  left[p] ) ++p;
						if(p>=left.length) break;
						String mode="";
						while(-1 != "@+".indexOf(left[p]) ){
							mode = mode + (char)left[p];
							++p;
						}
						start = p;while(p<left.length && left[p]!=' ') ++p;
						if(start==p) break;
						IRCUser user = m.conn.findUser(Util.ByteSubString(left,start,p));
						if( m.conn.myself.equals(user) ){
							if( chan.OnJoinMyself() ){
								m.conn.getListener().ChangeChannelJoin(m.conn,chan,true);
							}
							chan.AddUser(m,m.conn.myself,mode);
						}else{
							chan.AddUser(m,user,mode);
						}
					}
				}
			}
		});

		// トピック
		IRCMessageReader.add("331,332",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.checkSize(2);
				IRCChannel chan = m.setChannelContext(m.getParam(1));
				chan.setTopic( m.log_msg = m.getTrail(2));
				m.conn.getListener().ChangeTopic(m,chan);
			}
		});
		// TOPIC
		IRCMessageReader.add("TOPIC",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.checkSize(2);
				IRCChannel chan = m.setChannelContext(m.getParam(0));
				chan.setTopic( m.log_msg = m.getTrail(1));
				m.conn.getListener().ChangeTopic(m,chan);
			}
		});


		//サーバからのPINGに応答する
		IRCMessageReader.add("PING",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.conn.SendToServer(m.conn.encodeString("PONG "+ m.params_str),true,true);
				m.log_msg = m.getTrail(0);
				m.addContext(m.conn);
			}
		});

		//切断
		IRCMessageReader.add("QUIT",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.log_msg = m.getTrail(0);
				boolean IsIn;
				List channels = m.conn.getChannels();
				if(m.from.equals( m.conn.myself ) ){
					for(Iterator it = channels.iterator();it.hasNext();){
						IRCChannel chan=(IRCChannel)it.next();
						if( chan.OnPartMyself() ){
							m.addContext(chan);
							m.conn.getListener().ChangeChannelJoin(m.conn,chan,false);
						}
						chan.RemoveUserAll(m.conn);
					}
					m.conn.removeUserAll();
				}else{
					for(Iterator it =channels.iterator();it.hasNext();){
						IRCChannel chan=(IRCChannel)it.next();
						if( chan.RemoveUser(m,m.from) ) m.addContext(chan);
					}
					m.conn.removeUser(m.from);
				}
			}
		});


		// 発言
		IRCMessageReader.add("PRIVMSG,NOTICE",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.checkSize(2);
				byte[] msg_target = m.getParam(0);
				m.log_msg = m.getTrail(1);//CTCPはmの中に残る

				// plum対策：発言者が自分でしかもテキストが空ならなにもしない
				if( m.from.equals( m.conn.myself )
				&&  m.log_msg.length()==0
				){
					m.hideMessage=true;
					return;
				}
				// CTCPのみのメッセージの場合、表示しない
				if( m.ctcp!=null && m.ctcp.size()!=0
				&& m.log_msg.length()==0
				){
					m.hideMessage=true;
					m.log_to=new IRCChannelName(msg_target);
					return ;
				}

				// チャンネル宛
				if( IRCChannelName.isChannelName( msg_target ) ){
					m.setChannelContext(msg_target);
					return;
				}

				IRCUser to = m.conn.findUser(msg_target);
				m.log_to = to;

				// サーバ宛
				if(-1 != Util.ByteIndexOf(msg_target,'.') ){
					m.addContext(m.conn);
					return;
				}

				// ユーザ宛
				IRCChannel chan;
				m.cmd += "_u";
				if(to == m.conn.myself ){
					chan = m.conn.FindChannel( m.from ,true );
				}else{
					chan = m.conn.FindChannel( to   ,true );
				}
				m.log_context = chan;
				m.addContext(chan);
			}
		});
		// 入室退室
		IRCMessageReader.add("JOIN",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.checkSize(1);
				Vector channels  = new Vector();
				{
					byte[] ba = m.getParam(0);
					for(int i=0;i<ba.length;++i){
						int start=i; i=ba.length; // ircd-jp対応  while(i<ba.length && ba[i]!= ',') ++i;
						byte[] b= Util.ByteSubString(ba,start,i);
						channels.add(b);
					}
				}
				for(int c=0;c<channels.size();++c){
					byte[] cname = (byte[]) channels.get(c);
					int div = Util.ByteIndexOf(cname,0x07);
					IRCChannel chan = m.conn.FindChannel(cname,true);

					m.addContext(chan);
					m.log_dupForAllLog =true;
					if(m.from.equals( m.conn.myself )){
						if(chan.OnJoinMyself()){
								m.conn.getListener().ChangeChannelJoin(m.conn,chan,true);
						}
					}
					chan.AddUser(m,m.from,"");
					if(div!=-1){
						char toggle='+';
						for(int i=div+1;i<cname.length;++i){
							char moji = (char)cname[i];
							switch(moji){
							case 'O':
							case 'o':
							case 'v':
							case 'k':
							case 'l':
							case 'b':
							case 'e':
							case 'I':
								chan.SetChannelMode(m,toggle,moji,m.from);
								break;
							}
						}
					}
				}
			}
		});
		// partはチャンネルからの退出
		IRCMessageReader.add("PART",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.checkSize(1);
				Vector channels = new Vector();
				{
					byte[] ba = m.getParam(0);
					for(int i=0;i<ba.length;++i){
						int start=i; i=ba.length; // ircd-jp対応 while(i<ba.length && ba[i]!= ',') ++i;
						channels.add(new IRCChannelName(Util.ByteSubString(ba,start,i)));
					}
				}
				m.log_msg = m.getTrail(1);
				m.log_dupForAllLog =true;
				for(int i=0;i<channels.size();++i){
					IRCChannel chan = m.conn.FindChannel((IRCChannelName)channels.get(i),true);
					m.addContext(chan);
					if(m.from == m.conn.myself ){
						if( chan.OnPartMyself() ) m.conn.getListener().ChangeChannelJoin(m.conn,chan,false);
						chan.RemoveUserAll(m.conn);
					}else{
						chan.RemoveUser(m,m.from);
					}
				}
			}
		});
		// ニックネーム変更
		IRCMessageReader.add("NICK",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.checkSize(1);
				byte[] from_nick = m.from.getNickBytes();
				m.log_to  = new IRCChannelName(from_nick);

				m.from =m.conn.changeUserNick(m.from,m.getParam(0));
				m.log_msg = m.getTrail(2);

				// ここからは .mfromは変更後の情報になる
				boolean isMyself=false;
				if( m.from == m.conn.myself ){
					isMyself=true;
					m.addContext(m.conn);
					m.conn.getListener().ChangeNickMyself(m);
				}
				// 各チャンネルに通知する
				List channels = m.conn.getChannels();
				for(int i=0;i<channels.size();++i){
					((IRCChannel)channels.get(i)).OnChangeNick(m,from_nick,m.from,isMyself);
				}
			}
		});

		IRCMessageReader.add("KICK",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.checkSize(2);
				IRCChannel chan = m.setChannelContext(m.getParam(0));
				IRCUser user = m.conn.findUser( m.getParam(1) );
				m.log_to  = user;
				m.log_msg = m.getTrail(2);
				if(user.equals( m.conn.myself )){
					if(chan.OnPartMyself()) m.conn.getListener().ChangeChannelJoin(m.conn,chan,false);
					chan.RemoveUserAll(m.conn);
					m.conn.getListener().onChannelKicked(m);
				}else{
					chan.RemoveUser(m,user);
				}
			}
		});

		// モードリプライ
		IRCMessageReader.add("324",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.checkSize(3);
				IRCChannel chan = m.setChannelContext(m.getParam(1));
				m.log_msg = m.getTrail(2);
				chan.FixChannelMode(m,m.getParam(2));
			}
		});

		IRCMessageReader.add("MODE",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				m.checkSize(2);
				byte[] c_or_u = m.getParam(0);
				byte[] modebytes = m.getParam(1);
				// チャンネルモードの変更
				if(IRCChannelName.isChannelName(c_or_u)){
					IRCChannel chan = m.setChannelContext(c_or_u);
					m.log_msg = m.getTrail(0);

					char toggle='/';
					int p_index =2;

					for(int i=0;i<modebytes.length;++i){
						char c = (char) modebytes[i];
						switch(c){
						case '-': case '+': case '/':
							toggle = c;
							break;
						case 'a': case 'i': case 'm':
						case 'n': case 'p': case 'q':
						case 'r': case 's': case 't':
							chan.SetChannelMode(m,toggle,c);
							break;
						case 'O': case 'o': case 'v':
						case 'k': case 'l': case 'b':
						case 'e': case 'I': 
							chan.SetChannelMode(m,toggle,c,m.conn.findUser( m.getParam(p_index++) ) );
							break;
						}
					}
				}
			}
		});

		IRCMessageReader.add("CTCP_ACTION",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				// チャンネル宛
				if( IRCChannelName.isChannelName( m.log_to.getRawBytes() ) ){
					m.setChannelContext(m.log_to.getRawBytes());
					return;
				}
				// サーバ宛
				if(-1 != Util.ByteIndexOf(m.log_to.getRawBytes(),'.') ){
					m.addContext(m.conn);
					return;
				}
				// ユーザ宛
				IRCUser to = m.conn.findUser(m.log_to.getRawBytes() );
				IRCChannel chan;
				m.cmd += "_u";
				if(to.equals(m.conn.myself)){
					chan = m.conn.FindChannel( m.from ,true );
				}else{
					chan = m.conn.FindChannel( to   ,true );
				}
				m.log_context = chan;
				m.addContext(chan);
			}
		});
		IRCMessageReader.add("CTCP_FINGER",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				if(m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn)
				&& m.ctcp_is_request
				){
					Vector v=new Vector();
					v.add("FINGER");
					v.add(":"+m.conn.getListener().getCTCPReplyFinger(m));
					m.conn.SendCTCPReplyIfAvail(m.time,m.from,v);
				}
			}
		});
		IRCMessageReader.add("CTCP_VERSION",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				if(m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn)
				&& m.ctcp_is_request
				){
					Vector v=new Vector();
					v.add("VERSION");
					v.add(m.conn.getListener().getCTCPReplyVersion(m));
					m.conn.SendCTCPReplyIfAvail(m.time,m.from,v);
				}
			}
		});
		IRCMessageReader.add("CTCP_SOURCE",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				if(m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn)
				&& m.ctcp_is_request
				){
					Vector v=new Vector();
					v.add("SOURCE");
					v.add("http://tate.undef.jp/pub/BluntIRC/BluntIRC.html");
					m.conn.SendCTCPReplyIfAvail(m.time,m.from,v);
				}
			}
		});
		IRCMessageReader.add("CTCP_USERINFO",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				if(m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn)
				&& m.ctcp_is_request
				){
					Vector v=new Vector();
					v.add("USERINFO");
					v.add(":"+m.conn.getListener().getCTCPReplyUserInfo(m));
					m.conn.SendCTCPReplyIfAvail(m.time,m.from,v);
				}
			}
		});
		IRCMessageReader.add("CTCP_CLIENTINFO",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				if(m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn)
				&& m.ctcp_is_request
				){
					String s=":ACTION USERINFO SOURCE VERSION FINGER CLIENTINFO DCC PING TIME";
					Vector v=new Vector();
					v.add("CLIENTINFO");
					v.add(s);
					m.conn.SendCTCPReplyIfAvail(m.time,m.from,v);
				}
			}
		});
		IRCMessageReader.add("CTCP_PING",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				if(m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn)
				&& m.ctcp_is_request
				){
					Vector v=new Vector();
					v.add("PING");
					v.add(m.getParam(0));
					m.conn.SendCTCPReplyIfAvail(m.time,m.from,v);
					return;
				}
				if(!m.ctcp_is_request ){
					m.conn.getListener().checkCTCPPingReply(m);
				}
			}
		});
		IRCMessageReader.add("CTCP_TIME",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				if(m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn)
				&& m.ctcp_is_request
				){
					Vector v=new Vector();
					v.add("TIME");
					v.add(":"+m.getDateStr() + " "+m.getTimeStr()+" "+m.time.getTimeZone().getDisplayName(Locale.US) );
					m.conn.SendCTCPReplyIfAvail(m.time,m.from,v);
					return;
				}
			}
		});
		IRCMessageReader.add("CTCP_DCC",new IRCMessageReader(){
			public void dispach(IRCMessage m) throws IndexOutOfBoundsException{
				if(m.ctcp_index < m.conn.getListener().getCTCPSendCueMaxInLine(m.conn)
				&& m.ctcp_is_request
				){
					m.conn.getListener().checkDCC(m);
				}
			}
		});

		logger.info(log_sb.toString());
		log_sb=null;
	}
}

