// UTF-8 ☀☁☂☃
package irc;
import java.util.*;
import java.util.zip.Adler32;

class IRCNicknameHashKey implements Comparable{
	private byte[] key;
	private int hash_code;
	public  int hashCode(){ return hash_code;}

	public IRCNicknameHashKey(byte[] _key){
		key=_key;
		Adler32 check = new Adler32();
		check.update(IRCChannelName.RawToLow(key));
		long value = check.getValue();
		if(value > Integer.MAX_VALUE) value -= 0x100000000L;
		hash_code= (int)value;
	}

	public boolean equals(Object obj){
		if( hash_code  != ((IRCNicknameHashKey)obj).hash_code
		||  key.length != ((IRCNicknameHashKey)obj).key.length
		||  compareTo( obj)!=0
		) return false;
		return true;
	}
	public int compareTo(Object obj){
		byte[] a = key;
		byte[] b = ((IRCNicknameHashKey)obj).key;
		int minlength =(a.length<b.length?a.length:b.length);
		for(int i=0;i<minlength;++i){
			int r = IRCUser.tolower((int)a[i]) - IRCUser.tolower((int)b[i]);
			if(r!=0) return r;
		}
		return a.length - b.length;
	}
}

public class IRCNicknameHash{
	HashMap map = new HashMap();
	public Object get(byte[] nick_bytes)
	{ return map.get(new IRCNicknameHashKey(nick_bytes)); }

	public Object get(IRCUser who)
	{ return map.get(new IRCNicknameHashKey(who.getNickBytes())); }

	public void put(byte[] nick_bytes,Object value)
	{  map.put(new IRCNicknameHashKey(nick_bytes),value); }

	public void put(IRCUser who,Object value)
	{  map.put(new IRCNicknameHashKey(who.getNickBytes()),value); }

	public Object remove(byte[] nick)
	{  return map.remove(new IRCNicknameHashKey(nick)); }

	public Object remove(IRCUser who)
	{  return map.remove(new IRCNicknameHashKey(who.getNickBytes())); }

	public int size(){ return map.size();}
	public Collection values(){ return map.values();}
	public void clear(){ map.clear();}
}
