// UTF-8 ☀☁☂☃
package irc;
import java.io.*;
import java.util.*;
import java.net.*;
import java.nio.channels.*;
import java.nio.ByteBuffer;
import java.net.*;
import java.io.IOException;

interface IRCSocketReaderListener{
	void onConnect();
	void onDisconnect(String reason);
	void onRecvLine(byte[] ba);

	void onMessageError(Throwable e);
	void onConnectionError(Throwable e);
};

class IRCSocketReader implements base.SelectorItem{
	public static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("irc.ircsocketreader");
	static{ logger.setLevel(null); }

	protected ByteBuffer read_buffer  =ByteBuffer.allocate(4096);
	protected ByteBuffer write_buffer =ByteBuffer.allocate(4096);
	protected IRCSocketReaderListener listener;
	protected SelectionKey key;
	protected SocketChannel channel;
	protected static final byte[] byte_crlf = new byte[]{ '\r','\n' };

	public Socket getSocket(){ return channel==null?null:channel.socket();}

	public IRCSocketReader(
		 base.SelectorRun selector
		,String r_host,int r_port
		,String l_host,int l_port
		,int timeout
		,IRCSocketReaderListener _listener
	)
	throws IOException
	{
		write_buffer.flip();
		this.listener = _listener;
		// アドレスの解決
		InetSocketAddress remote = new InetSocketAddress(InetAddress.getByName(r_host),r_port);
		InetSocketAddress local=null;
		if( null!=l_host &&  0!=l_host.length() )
			local=new InetSocketAddress(InetAddress.getByName(l_host),l_port);
		else local=new InetSocketAddress(0);
		// ソケットの作成
		channel =SocketChannel.open();
		if(local!=null) channel.socket().bind(local);
		channel.socket().setSoTimeout(timeout);
		channel.socket().setTcpNoDelay(true);
		channel.socket().setReuseAddress(true);
		// 非同期にしてセレクタに登録
		channel.configureBlocking(false);
		interest_ops_for_write=SelectionKey.OP_WRITE+SelectionKey.OP_READ|SelectionKey.OP_CONNECT;
		key = selector.register(this,channel);
		channel.connect(remote);
	}

	///////////////////////////////////////////////////////////////////////
	// implements SelectorItem

	public boolean onAcceptable (SelectableChannel which){ return true;}

	public boolean onConnectable(SelectableChannel which){
		try{
			if(channel.finishConnect()){
				// 接続した
				interest_ops_for_write=SelectionKey.OP_WRITE|SelectionKey.OP_READ;
				try{ key.interestOps(interest_ops_for_write); }catch(CancelledKeyException e){}

				try{ listener.onConnect();}catch(Throwable e){ listener.onMessageError(e); }
				return false;
			}
			return false;
		}catch(IOException e){ return closeByError(e,"connectionError"); }
	}
	public boolean onWritable(SelectableChannel which){
		for(;;){
			if( !write_buffer.hasRemaining() ){
				charge_write_buffer();
				if( !write_buffer.hasRemaining() ) break;
			}
			try{ channel.write(write_buffer); }
			catch(IOException e){ return closeByError(e,"writeError"); }
			if(write_buffer.hasRemaining()){
				logger.finer("onWritable: wait next writable");
				return false;
			}
		}
		// キューが空？
		if( cue[0].isEmpty() && cue[1].isEmpty() ){
			// 終了フラグが立ってれば終了
			if(disconnect_reason!=null) return close(disconnect_reason);
		}
		// flood protection かもしれない

		// バッファが空なら onWritable が呼ばれないようにする
		// (そうしないと受信ができない?)
		try{ key.interestOps(SelectionKey.OP_READ); }catch(CancelledKeyException e){}
		return true;
	}

	public void onTimer(SelectableChannel which){
		// 書けるようにキーを設定する
		try{ key.interestOps(interest_ops_for_write); }catch(CancelledKeyException e){}
	}

	public boolean onReadable(SelectableChannel which){
		for(;;){
			read_buffer.clear();
			try{
				int r= channel.read(read_buffer);
				if(r==-1) return close("end of input stream");
				if(r<= 0) return false;
			}catch(IOException e){ return closeByError(e,"readError");}
			boolean full = ! read_buffer.hasRemaining();
			read_buffer.flip();
			flush_read_buffer();
			if(!full) break;
		}
		return false;
	}
	public void onSelectorExit(SelectableChannel which){
	}
	///////////////////////////////////////////////////

	protected boolean closeByError(Throwable e,String reason){
		listener.onConnectionError(e);
		return close(reason);
	}
	protected boolean close(String reason){
		if(channel!=null){
			try{
				channel.close();
			}catch(Throwable e){
				if( e.toString().indexOf("Descriptor not a socket") == -1
				&&  e.toString().indexOf("socket was closed")       == -1
				){
					listener.onConnectionError(e);
				}
			}
			channel=null;
			try{ listener.onDisconnect(reason);}
			catch(Throwable e){ listener.onMessageError(e); }
		}
		return true;
	}

	///////////////////////////////////////////////////////////////////////
	// 送信キュー
	LinkedList[] cue = new LinkedList[]{ new LinkedList(),new LinkedList()};
	String disconnect_reason; // null以外になったら送信バッファが空になった時点で終了
	protected void addCue(byte[] ba,int type){
		cue[type].addLast(ba);
		try{ key.interestOps(interest_ops_for_write); }catch(CancelledKeyException e){}
	}
	public void WriteFast(byte[] ba){ addCue(ba,0);}
	public void Write    (byte[] ba){ addCue(ba,1);}
	public void WriteQuit(byte[] ba,String reason){
		disconnect_reason=reason;
		addCue(ba,0);
	}

	// バッファの有無で設定するop
	protected int interest_ops_for_write;


	// TODO: flood protection
	long block_end =0;
	void charge_write_buffer(){
		write_buffer.clear();
		long now = System.currentTimeMillis();
		if(block_end < now) block_end =now;
		// 0が優先キュー、1が通常キュー
		APPEND: for(int type=0;type<2;++type){
			while(cue[type].size()>0 ){
				byte[] ba = (byte[])cue[type].getFirst();
				if(ba.length+2 > write_buffer.limit() ){
					// 拡張してしまう
					if(write_buffer.position()==0){
						write_buffer = ByteBuffer.allocate(ba.length+20);
						write_buffer.clear();
					}else{
						// キューが空くまで待つ
						break;
					}
				}
				// flood protection 
				if( type == 1 
				&&  disconnect_reason==null 
				&&  now+10 < block_end 
				)   break APPEND;
				// 書き込む
				if( ba.length+2 <= write_buffer.remaining() ){
					write_buffer.put(ba);
					write_buffer.put(byte_crlf);
					cue[type].removeFirst();
					block_end += 1000 + ba.length*(1000/30);
					continue;
				}
				break APPEND;
			}
		}
		write_buffer.flip();
	}

	protected ByteArrayOutputStream line=new ByteArrayOutputStream(1000);
	public void flush_read_buffer(){
		while(read_buffer.hasRemaining() ){
			byte b= read_buffer.get();
			if(b=='\r'||b=='\n'){
				if(line.size()>0){
					try{ listener.onRecvLine(line.toByteArray()); }
					catch(Throwable e){ listener.onMessageError(e); }
					line.reset();
				}
				continue;
			}
			line.write(b);
		}
	}
};
