package bluntirc;
// UTF-8 このファイルはUTF-8で書かれています。
import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import gui.*;
import javax.swing.ComponentInputMap;

public class AllLogWindow 
extends JFrame
{
	Container RootPane;
	public buffer.LogView log_view;
	public buffer.LogDocument doc;
	public ImagePanel image_panel;
	boolean is_window;
	boolean isWindow(){return is_window;}

	public AllLogWindow(boolean is_window){
		super("全てのメッセージ - "+App.config_AppName);
		this.is_window=is_window;

		if(is_window){
			RootPane = getContentPane();
			setIconImage( App.icon_app.getImage() );
		}
		////////////////////////////
		log_view=new buffer.LogView(App.root_property.setDefaultBoolean("TransparentScrollBarUI",false));
		log_view.addLogSweepListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				App.getApp().updateTopic();
			}
		});
		log_view.addMouseListener(new MouseAdapter(){
			public void mousePressed(MouseEvent e){ checkPopup(e);}
			public void mouseReleased(MouseEvent e){checkPopup(e);}
			void checkPopup(MouseEvent e){
				if( e.isPopupTrigger() 
				&&  e.getComponent() instanceof buffer.LogView
				){
					buffer.LogView lv = (buffer.LogView)e.getComponent();
					buffer.LogDocument doc = lv.getDocument();
					if(doc==null) return;
					lv.requestFocus();
					App.menu_conf.showPopupMenu(e,doc.getMenuListener(),doc);
				}
			}
		});
		////////////////////////////
		doc = new buffer.LogDocument(App.style_manager);
		log_view.setDocument(doc);
		////////////////////////////
		JComponent fore =log_view;
		fore.setOpaque(false);
		image_panel = new ImagePanel(RootPane);
		image_panel.mode=1;
		if(is_window){
			BorderLayout bl=new BorderLayout();
			bl.setVgap(0);
			bl.setHgap(0);
			image_panel.setLayout(bl);
			image_panel.add(fore,BorderLayout.CENTER);
			RootPane.add(image_panel);
		}
	}
	public void show(){
		if(is_window){
			super.show();
			super.setState(Frame.NORMAL);

			ActionMap actionmap = log_view.getActionMap();
			InputMap inputmap = log_view.getInputMap();
			{
				String[] keyaction=new String[]{
					"edit-selectall",
					"edit-cut",
					"edit-copy",
					"edit-paste",
					"buffer-find-dialog",
					"buffer-find-next",
					"buffer-find-prev",
				};
				for(int i=0;i<keyaction.length;++i){
					String name=keyaction[i];
					Action a = App.action_manager.find(name);
					KeyStroke k = App.menu_conf.findAccelerator(name);
					if(a!=null && k!=null){
						actionmap.put(name,a);
						inputmap.put(k,name);
					}
				}
			}
			log_view.setActionMap(actionmap);
			log_view.setInputMap(JComponent.WHEN_FOCUSED, inputmap);
		}
	}
	public void hide(){
		if(is_window){
			super.hide();
		}
	}
	public Rectangle getBounds(){
		if(is_window) return super.getBounds();
		return new Rectangle(0,0,log_view.getWidth(),log_view.getHeight());
	}
	public boolean isShowing  (){
		if(is_window)  return super.isShowing();
		return true;
	}
	public void setBounds(Rectangle r){
		if(is_window) super.setBounds(r);
	}

	public JComponent getComponent(){
		return log_view;
	}
	public void setSize(int x,int y){
		if(is_window) super.setSize(x,y);
	}
}
