package bluntirc;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
//import java.beans.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.text.ParseException;
import irc.*;
import base.*;

// 接続ツリーのノードの基底クラス
abstract public class ConnTreeNode
implements Comparable
{
	//----------------------------------------------------
	// ツリーの扱い
	protected ConnTreeNode parent;
	protected LinkedList child=new LinkedList();
	public final ConnTreeNode getParent(){ return parent;}
	public final Iterator getChilds(){ return ((LinkedList)child.clone()).iterator();}
	public final int getChildCount(){ return child.size();}

	public final void insertNodeInto(ConnTreeNode node){
		if(node==null) throw new NullPointerException();
		node.parent=this;
		child.addFirst(node);
		App.buf_list.addItem(node,this,App.root_property.setDefaultBoolean("ActivateBufferOnCreate",false) );
	}
	public final void removeChildAll(){
		for(Iterator it=getChilds();it.hasNext();) 
			removeNode( ((ConnTreeNode)it.next()) );
	}
	public final void removeNode(ConnTreeNode node){
		// 子を削除
		node.removeChildAll();
		// 自分を削除
		node.PreRemove();
		node.parent=null;child.remove(node);
		// 表示も削除
		App.buf_list.removeItem(node);
	}
	//----------------------------------------------------
	// バッファ
	buffer.LogDocument doc;
	ConnTreeNode(buffer.LogDocument doc){
		if(doc==null) doc= new buffer.LogDocument(App.style_manager);
		this.doc = doc;
	}
	public buffer.LogDocument getLogDocument(){return doc;}
	public void addMidoku(buffer.PackedLineWriter tsi,Object main_context){
		 doc.addText(App.main_window,tsi,main_context);
		 // 選択中のバッファなら行数の変更を表示に反映する
		if(App.getSelected()==this) App.getApp().updateTopic();
	 }
	public String getBufferInfo(){ return Integer.toString(getLogDocument().getLineCount())+"行"; }
	//----------------------------------------------------
	// プロパティ
	public PropertyManager property=new PropertyManager(this);
	abstract public Object getPropertyExtra();
	//----------------------------------------------------
	// 参加者リスト
	public ChannelMemberList getUserList(){ return null;}
	//----------------------------------------------------
	// 関連するノード
	public CTN_Conn getConnNode		(){return null;}
	public CTN_Chan getChannelNode	(){return null;}
	public CTN_Priv getPrivNode		(){return null;}
	//----------------------------------------------------
	// 表示
	public abstract String getTitle();
	public abstract String getPopupName();
	public String  GetCaption(){ return "ConnTreeNode"; }
	public ImageIcon getImageIcon(){ return App.icon_app;}

	public abstract int getListLevel();
	public int getListOffset(){
		CTN_Conn cn = getConnNode();
		return ((cn==null||cn==this)?0:1);
	}
	public String getListLabel1(){ return GetCaption(); }
	public String getListLabel2(){
		CTN_Conn cn = getConnNode();
		return ((cn==null||cn==this)?"":cn.GetCaption());
	}
	//----------------------------------------------------
	// バッファ一覧のソート
	public static int sort_type;
	public int getOrderInList(){
		return property.getInt("order_in_list",0);
	}
	public int order_in_list;
	public int compareTo(Object o){
		ConnTreeNode b=(ConnTreeNode)o;
		// 記憶された順序でソート
		if(sort_type==1){
			return getOrderInList() - b.getOrderInList();
		}
		return getSortString().compareTo(b.getSortString());
	}
	private String getSortString(){
		ConnTreeNode l1 = getConnNode();
		if(l1==null) return "";
		ConnTreeNode l2 = getChannelNode();
		if(l2!=null) return l1.GetCaption()+"\n\n"+l2.GetCaption();
		l2 = getPrivNode();
		if(l2!=null) return l1.GetCaption()+"\n"+l2.GetCaption();
		return l1.GetCaption();
	}

	//----------------------------------------------------
	// バッファ一覧のマウスイベント
	public void OnDoubleClick(MouseEvent e){}
	public void OnMiddleClick(MouseEvent e){}
	public void OnSelect(){}
	public void onClick(MouseEvent e){
		if(0!= (e.getModifiers()&InputEvent.BUTTON1_MASK)){
			if( e.getClickCount() >1 ) OnDoubleClick(e);
		}else if (0!=(e.getModifiers()&InputEvent.BUTTON2_MASK) ){
			OnMiddleClick(e);
		}
	}
	//----------------------------------------------------
	static String[] TypeStr=new String[]{"PRIVMSG","TOPIC","NOTICE","PRIVMSG"};
	public boolean SendFromUserInput(String a,int type){
		IRCConnection conn = getConnNode().conn;
		if(conn==null) return false;
		IRCChannel to=null;
		if(getPropertyExtra() instanceof IRCChannel)
			to = (IRCChannel)getPropertyExtra();
		if(! conn.isConnected() ) return false;
		for(int i=0;i<a.length(); i+=((i<a.length() && a.charAt(i) == '\n')?1:0) ){
			int start=i; while(i<a.length() && a.charAt(i) != '\n') ++i;
			if(i>start){
				if( a.charAt(start)==App.root_property.getString("CommandSlash").charAt(0) ){
					String cmd= a.substring(start+1,i);
					if(!App.action_manager.fireUserCommand(cmd)){
						conn.SendToServer(conn.encodeUserCommand(cmd));
					}
				}else{
					Vector v = new Vector();
					if(type==3){
						v.add( Util.toJIS("ACTION") );
						v.add( Util.toJIS(a,start,i) );
						conn.SendToServer(conn.encodeCTCP(to.getCName().getRawBytes(),v,"PRIVMSG"));
					}else{
						conn.SendToServer(conn.encodeUserTalk(TypeStr[type],to.getCName().getRawBytes(),Util.toJIS(a,start,i) ));
					}
					// local_log_to に送る
					if(type==1) continue;
					IRCMessage m=new IRCMessage(conn,TypeStr[type],a.substring(start,i)); 
					if(type==3) m.cmd = "CTCP_ACTION";
					if(!to.isChannel()) m.cmd += "_u";
					m.log_to = to;
					m.log_from = m.from = conn.myself;
					m.addContext(m.log_context = to);
					m.sendLogToListener();
				}
			}
		}
		return true;
	}
	//----------------------------------------------------
	// その他抽象メソッド
	abstract public void PreRemove();
	abstract public void onHashLoad();
	abstract public void onHashSave();
	abstract public void onPropertyChanged(String name,Object value);

	abstract public java.util.List getCreateParam();
};

