package bluntirc;
// UTF-8 ☀☁☂☃

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.text.ParseException;
import base.*;

public class MenuConf
implements MenuListener,PopupMenuListener
{
	// 設定ファイルを読む
	public void load(){
		String fname="menu.conf";
		try{
			Reader r = new InputStreamReader(Util.OpenFile(fname),"UTF-8");
			try{
				MyStreamTokenizer in = new MyStreamTokenizer(r,fname,false);
				menus =readMenu(in);
				action_to_stroke.clear();
				stroke_to_menu.clear();
				popup_cache = new HashMap();
				App.Log(fname+"を読み終わりました");
				return;
			}catch(java.io.IOException e){
				App.Log(fname+"を読めません:"+e.getMessage());
			}finally{
				r.close();
			}
		}catch(FileNotFoundException e){
			App.Log(e.getMessage());
		}catch(IOException e){
			App.Log(fname +":"+e.toString()+" "+e.getMessage());
		}
	}

	// メニューの集まりを読む
	protected static LinkedList readMenu(MyStreamTokenizer in)
	throws IOException
	{
		LinkedList result = new LinkedList();
		Loop: for(;;){
			try{
				in.skipToStartOfStatement();
				// ファイル末尾なら終了
				if( in.ttype==in.TT_EOF ) break;
				// end行なら終了
				if( in.ttype==in.TT_WORD && in.sval.equals("end") ){
					in.nextToken();
					break Loop;
				}
				// 行末まで読む
				HashMap node = in.readOptions("オプション指定",true);
				// サブメニューならサブメニューを読む
				if(null!=node.get("menu")) node.put("=submenu",readMenu(in));
				result.addLast(node);
			}catch(java.text.ParseException e){
				App.Log(in.fname+" "+in.lineno()+"行: "+e.getMessage() );
				// 行末または;まで読み飛ばす
				in.skipToEndOfStatement();
			}
		}
		return result;
	}

	/////////////////////////////////////////////////////////////////////

	static HashMap findMenuInfo(LinkedList menu,String key){
		for(Iterator it= menu.iterator();it.hasNext();){
			HashMap node = (HashMap)it.next();
			Object value= node.get("menu");
			if(value==null) continue;
			if(key.equals((String)value)) return node;
			node = findMenuInfo((LinkedList)node.get("=submenu"),key);
			if(node!=null) return node;
		}
		return null;
	}

	LinkedList menus;
	HashMap findMenuInfo(String key){
		HashMap node= findMenuInfo(menus,key);
		if(node==null) App.Log("menu.conf に menu="+key+"がありません");
		return node;
	}

	public void setJMenuBar(JFrame window){
		HashMap node= findMenuInfo("MenuBar");
		if(node==null) return;

		JMenuBar menu = window.getJMenuBar();
		if(menu==null){
			// 初回は普通にaddするだけでいい
			menu = new JMenuBar();
			for(Iterator it = ((LinkedList)node.get("=submenu")).iterator();it.hasNext();){
				HashMap item = (HashMap)it.next();
				if(null!=item.get("menu")) menu.add( createJMenu(item) );
			}
			menu.setBorder(null);
		//	menu.setOpaque(false);
			window.setJMenuBar(menu);
			return;
		}
		// 2回目以降がどうもうまくいかない
		menu.setSelected(null);
		LinkedList  tm = new LinkedList();
		for(Iterator it = ((LinkedList)node.get("=submenu")).iterator();it.hasNext();){
			HashMap item = (HashMap)it.next();
			if(null!=item.get("menu")){
				JMenu m = createJMenu(item);
				tm.addLast(m);
			}
		}
		for(int i=0;i<menu.getMenuCount();++i){
			JMenu old = menu.getMenu(i);
			old.setText("");
			old.removeAll();
			old.setMnemonic(-1);
			old.setEnabled(false);
		}
		JMenu neo;
		for(int i=0;i<menu.getMenuCount();++i){
			JMenu old = menu.getMenu(i);
			if(tm.size() >0){
				neo =(JMenu) tm.removeFirst() ;
				while(neo.getItemCount() >0){
					JMenuItem item =  neo.getItem(0);neo.remove(0);
					if(item==null){
						old.addSeparator() ;
					}else{
						old.add(item);
					}
				}
				old.setText(neo.getText());
				int c = neo.getMnemonic();
				old.setMnemonic(c);
				old.setEnabled(neo.isEnabled());
			}
		}
		while(tm.size() >0){
			menu.add( (JMenu) tm.removeFirst() );
		}
	}


	HashMap popup_cache;
	public JPopupMenu getMenu(String name){
		JPopupMenu pm = (JPopupMenu) popup_cache.get(name);
		if(pm!=null) return pm;
		HashMap node= findMenuInfo(name);
		if(node==null) return null;
		pm = new JPopupMenu(name){
			public void setVisible(boolean b){
				super.setVisible(b);
				if(b) setSelected(null);
			}
		};
		pm.addPopupMenuListener(this);
		for(Iterator it = ((LinkedList)node.get("=submenu")).iterator();it.hasNext();){
			HashMap item = (HashMap)it.next();
			if(null!=item.get("menu")){ pm.add( createJMenu(item) ); }
			if(null!=item.get("separator")){ pm.addSeparator(); }
			if(null!=item.get("action")){ pm.add( createJMenuItem(item)); }
		}
		popup_cache.put(name,pm);
		return pm;
	}
	JMenu createJMenu( HashMap node){
		Object o;

		JMenu menu=null;
		if(node.get("secret")!=null){
			menu = new JMenu("");
			menu.setEnabled(false);
		}else{
			o = node.get("caption");
			if(o==null) o = node.get("menu");
			menu = new JMenu((String)o);
			o=node.get("mnemonic");
			if(o!=null) menu.setMnemonic(((String)o).charAt(0));
		}
		menu.addMenuListener(this);

		if(node.get("invoker")!=null){
			menu.putClientProperty("action_invoker",node.get("invoker"));
		}


		for(Iterator it = ((LinkedList)node.get("=submenu")).iterator();it.hasNext();){
			HashMap item = (HashMap)it.next();
			if(null!=item.get("menu")     ){ menu.add( createJMenu(item) ); }
			if(null!=item.get("separator")){ menu.addSeparator(); }
			if(null!=item.get("action")   ){ menu.add( createJMenuItem(item)); }
		}
		return menu;
	}

	HashMap action_to_stroke = new HashMap();
	HashMap stroke_to_menu = new HashMap();
	
	public KeyStroke findAccelerator(String action_name){
		return (KeyStroke)action_to_stroke.get(action_name);
	}
	public JMenuItem findMenuItem(KeyStroke stroke){
		return (JMenuItem)stroke_to_menu.get(stroke);
	}

	JMenuItem createJMenuItem( HashMap node){
		String action_name = (String)node.get("action");
		if(action_name==null || action_name.length()<=1 )
			return new JMenuItem("action is not specified");

		Action action = App.action_manager.find(action_name);
		String name = (String)node.get("caption");
		if(name==null && action!=null) name = (String)action.getValue(Action.NAME);
		if(name==null) name = action_name;

		JMenuItem menu = new JMenuItem(new RefAction(action,action_name));
		menu.setText(name);

		Object o;
		o=node.get("accelerator");
		if(o!=null){
			KeyStroke k =KeyStroke.getKeyStroke((String)o);
			if(k!=null){
				menu.setAccelerator(k);
				stroke_to_menu.put(k,menu);
				action_to_stroke.put(action_name,k);
			}
			else App.Log( ((String)o)+"は有効なキーストローク指定ではありません");
		}

		o=node.get("mnemonic");
		if(o!=null) menu.setMnemonic(((String)o).charAt(0));

		o=node.get("command");
		if(o!=null) menu.setActionCommand((String)o);

		return menu;
	}

	/////////////////////////////////////////
	// MenuListener ,PopupMenuListener

	public void checkMenu(MenuElement[] me_ary,boolean rec){
		for(int i=0;i<me_ary.length;++i){
			if(me_ary[i] instanceof JPopupMenu){
				JPopupMenu m= (JPopupMenu)me_ary[i];
				checkMenu(m.getSubElements(),false);
			}else if(me_ary[i] instanceof JMenu){
				JMenu m= (JMenu)me_ary[i];
				//再帰的に掘る必要はない checkMenu(m.getSubElements(),true,m.getText());
			}else if(me_ary[i] instanceof JMenuItem){
				JMenuItem mi= (JMenuItem)me_ary[i];
				//	App.Log(mi.getText());
				if(mi!=null){
					boolean b =false;
					Action a = mi.getAction();
					if(a!=null) b = a.isEnabled();
					mi.setEnabled(b);
				}
			}else if(me_ary[i] ==null){
			}else{
				App.Log(" MenuElement is "+me_ary[i].getClass().getName());
			}
		}
	}

	public void menuDeselected(MenuEvent e){}
	public void menuCanceled(MenuEvent e){}
	public void popupMenuCanceled(PopupMenuEvent e){}
	public void popupMenuWillBecomeInvisible(PopupMenuEvent e){}

	public void menuSelected(MenuEvent e){
		App.recordPreFocus("menuSelected ");
		JMenu m = (JMenu)e.getSource();
		checkMenu( m.getSubElements()[0].getSubElements(),false);
	}
	public void popupMenuWillBecomeVisible(PopupMenuEvent e){
		App.recordPreFocus("popupMenuWillBecomeVisible ");
		checkMenu( ((JPopupMenu)e.getSource()).getSubElements(),false);
	}

	//////////////////////////////////////////////////
	// ポップアップメニューの表示位置
	public void showPopupMenu(MouseEvent e,String menu_name){
		showPopupMenu(e,menu_name,null);
	}

	public void showPopupMenu(MouseEvent e,String menu_name,PopupMenuListener listener){
		JPopupMenu pm = getMenu(menu_name);
		if(pm==null) return;
		// 引数で指定されたリスナーを追加する。
		// 削除はリスナー自身が行うこと
		if(listener!=null) pm.addPopupMenuListener(listener);
		Point     screenStart = new Point(0,0);
		SwingUtilities.convertPointFromScreen(screenStart,e.getComponent());
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		int x=e.getX()+1;
		int y=e.getY()+1;
		int w=pm.getWidth();
		int h=pm.getHeight();
		if(x> screenStart.x+screenSize.width-w)  x=screenStart.x+screenSize.width-w;
		if(y> screenStart.y+screenSize.height-h) y=screenStart.y+screenSize.height-h;
		if(x<screenStart.x)x=screenStart.x;
		if(y<screenStart.y)y=screenStart.y;
		pm.show(e.getComponent(),x,y);
	}
}

	class RefAction extends AbstractAction{
		String action_name;
		public RefAction(Action a,String action_name){
			this.action_name = action_name;
		}
		public Object getValue(String key){
			Action action = App.action_manager.find(action_name);
			if(key.equals(NAME) && action==null) return "404 "+action_name;
			if(action!=null) return action.getValue(key);
			return null;
		}
		public void putValue(String key, Object value){
			Action action = App.action_manager.find(action_name);
			if(action!=null) action.putValue(key,value);
		}
		public void setEnabled(boolean b){
			Action action = App.action_manager.find(action_name);
			if(action!=null) action.setEnabled(b);
		}
		public boolean isEnabled(){
			Action action = App.action_manager.find(action_name);
			if(action!=null) return action.isEnabled();
			return false;
		}
		public void actionPerformed(ActionEvent e){
			Action action = App.action_manager.find(action_name);
			if(action!=null)  action.actionPerformed(e);
		}
	};
