package buffer;
import java.io.*;
public class PackedLineWriter extends PackedStyle{
	public CharArrayWriter       text;
	public ByteArrayOutputStream style;
//	public int getTextSize (){ return text.size();}
//	public int getStyleSize(){ return style.size();}

	public PackedLineWriter(StyleID sid,String basestyle_name){
		super(sid,basestyle_name);
		text =new CharArrayWriter();
		style=new ByteArrayOutputStream();
	}

	public void appendStyle(PackedStyle newstyle){
		if(newstyle==null) return;
		if( baseid != newstyle.baseid ){
			baseid = newstyle.baseid;
			if(baseid==0){
				System.err.println("PackedLineWriter : bad baseid 0!");
				style.write(BASESTYLE_START + (1&BASESTYLE_MASK));
			}else{
				style.write(BASESTYLE_START + (baseid&BASESTYLE_MASK));
			}
		}
		for(int i=0;i<optionid.length;++i){
			if( optionid[i] != newstyle.optionid[i] ){
				optionid[i] = newstyle.optionid[i];
				if(optionid[i] !=-1){
					style.write(OPTIONSTYLE_START+i);
					style.write(optionid[i]);
				}else{
					style.write(OPTIONREMOVE_START+i);
				}
			}
		}
	}
	public void appendSaveIndent(PackedStyle newstyle){
		appendStyle(newstyle);
		style.write(SAVEINDENT);
	}
	// liststart`last܂ł̗vfeLXgɒǉB
	// ̒OnewstyleŎX^Cݒ肷B
	public void appendText(
		java.util.List list,int start,int last //litexts
		,PackedStyle newstyle
	){
		int length = text.size();
		try{
			for(int i=start;i<=last;++i) text.write((String)list.get(i));
		}catch(IOException e){}
		length = text.size() -length; // ǉđTCY
		if(length<0) return;
		appendStyle(newstyle);
		while(length>=TEXT_LONG){  style.write(TEXT_LONG); length-=TEXT_LONG; }
		style.write(length);
	}
}
