// UTF-8 ☀☁☂☃
package dialog;
import bluntirc.*;
import irc.*;
import base.*;
import gui.*;
import java.io.File;
import java.awt.*;
import javax.swing.*;
import action.*;
import java.util.*;


public class ChannelDialog extends DialogBase{
	public ChannelDialog(CTN_Chan node){
		super();
		node.property.setString("PrintableName",node.GetChannel().getPrintableName());
		node.property.setString("ShortName",node.GetChannel().getShortName());
		node.property.setString("EscapedName",node.GetChannel().getEscapedName());
		setup(node,item_list);
	}
	String getSettingName(){
		String name=null;
		for(int i=0;i<items.length;++i){
			if(items[i].getCaption().equals("短い名前")){
				name = ((JTextField)items_value[i]).getText();
			}
		}
		if(name==null) name="(oops)";
		return name;
	}
	protected void CheckInputs_ok(){
		setTitle( getSettingName()+"の設定" );
	}
	protected ConnTreeNode createNode(){ return null; } // 呼ばれない

	DialogEditItem[] item_list = new DialogEditItem[]{
		new DialogEditItem_TabSeparator("チャンネル名とパスワード"),
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "ShortName";}
			public String getCaption(){ return "短い名前";}
			public String getDesc(){ return "!で始まる場合などの短い名前";}
			public boolean isEditable(){return false;}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "PrintableName";}
			public String getCaption(){ return "表示名";}
			public String getDesc(){ return "一般的な名前。正確ではないかも";}
			public boolean isEditable(){return false;}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "EscapedName";}
			public String getCaption(){ return "EscapedName";}
			public String getDesc(){ return "正確さのためにエスケープした名前";}
			public boolean isEditable(){return false;}
		},
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "Password";}
			public String getCaption(){ return "パスワード";}
			public String getDesc(){ return "参加する際に必要かも。";}
			public void checkValue(Component c) throws Exception{
				if(ContainSpace(((JTextField)c).getText())) throw new Exception("パスワードに空白が含まれている");
			}
		},
		new DialogEditItem_TabSeparator("オプション"),
		new DialogEditItem_String(){
			public String getPropertyKey(){ return "PartMessage";}
			public String getCaption(){ return "退出メッセージ";}
			public String getDesc(){ return "省略するとサーバの設定から参照";}
			public String getDefaultValue(){ return "";}
		},

		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "AutoJoin";}
			public String getCaption(){ return "接続時に自動join";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "RejoinOnKicked";}
			public String getCaption(){ return "蹴られたら再joinを試みる";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "AutoWho";}
			public String getCaption(){ return "join時にwhoクエリ";}
		},
		new DialogEditItem_Boolean(){
			public String getPropertyKey(){ return "AutoModeQuery";}
			public String getCaption(){ return "join時にmodeクエリ";}
		},

		new DialogEditItem_TabSeparator("管理"),
		new DialogEditItem_Button(){
			public String getCaption(){ return "自動op...";}
			public void actionPerformed(java.awt.event.ActionEvent e){
				ConnTreeNode node = getNode();
				if(node==null) return;
				node.property.setDefaultObject("autoOpWildcard",new LinkedList());
				new PropertyInspector(node.property,node.GetCaption()+"の自動op設定","autoOpWildcard",true,false,false);
				CheckInputs();
			}
		},
	};
}
