package gui;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import java.awt.Rectangle;
import javax.swing.*;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.*;
import javax.swing.event.*;

public class MyScrollPane
extends JScrollPane
{
	boolean trans;
    protected class ScrollBar extends JScrollBar implements UIResource
	{
		boolean trans;
		public ScrollBar(int o,boolean trans){
			super(o);
			this.trans=trans;
			setUI( (ScrollBarUI)UIManager.getUI(this) );
		}
		public void setUI(ScrollBarUI newUI){
			if(trans){
				super.setUI(new MyScrollBarUI());
				setOpaque(false);
			}else{
				super.setUI(newUI);
			//	setOpaque(trans);
			}
		}
		public void setVisibleAmount(int extent){
			super.setVisibleAmount(extent);
		}
		private boolean blockIncrementSet;
		private boolean unitIncrementSet;

		public void setUnitIncrement(int unitIncrement) { 
			unitIncrementSet = true;
			super.setUnitIncrement(unitIncrement);
		}
		public int getUnitIncrement(int direction) {
			JViewport vp = getViewport();
			if(!unitIncrementSet 
			&& (vp != null) 
			&&(vp.getView() instanceof Scrollable)
			){
                Scrollable view = (Scrollable)(vp.getView());
                Rectangle vr = vp.getViewRect();
                return view.getScrollableUnitIncrement(vr, getOrientation(), direction);
            }
			return super.getUnitIncrement(direction);
		}
		public void setBlockIncrement(int blockIncrement) { 
			blockIncrementSet = true;
			super.setBlockIncrement(blockIncrement);
		}
		public int getBlockIncrement(int direction) {
        	JViewport vp = getViewport();
			if( blockIncrementSet || vp == null ) return super.getBlockIncrement(direction);
            if( vp.getView() instanceof Scrollable){
                Scrollable view = (Scrollable)(vp.getView());
                Rectangle vr = vp.getViewRect();
                return view.getScrollableBlockIncrement(vr, getOrientation(), direction);
            }
			return (getOrientation() == VERTICAL)?(vp.getExtentSize().height):vp.getExtentSize().width;
		}
	}


	public MyScrollPane(Component view,boolean trans){
		super(view);
		setHorizontalScrollBar(new ScrollBar(ScrollBar.HORIZONTAL,trans));
		setVerticalScrollBar(new ScrollBar(ScrollBar.VERTICAL,trans));
	}
}
