package gui;
import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.TableHeaderUI;
import java.util.Enumeration;

///////////////////////////////////////////////////////////////////
// 透明なUIにできるテーブル

public class MyTable 
extends JTable
{
	boolean trans;
	public MyTable(TableModel m,boolean trans){
		super(m);
		super.setTableHeader(new MyTableHeader(super.getTableHeader().getColumnModel(),trans));
		this.trans=true;
		updateUI();
	}
    public void updateUI() {
		// Update the UIs of the cell renderers, cell editors and header renderers.
		TableColumnModel cm = getColumnModel();
		for(int column = 0; column < cm.getColumnCount(); column++ ){
			TableColumn aColumn = cm.getColumn(column);
			updateSubComponentUI(aColumn.getCellRenderer());
			updateSubComponentUI(aColumn.getCellEditor());
			updateSubComponentUI(aColumn.getHeaderRenderer());
		}
		// Update the UIs of all the default renderers.
		Enumeration defaultRenderers = defaultRenderersByColumnClass.elements();
		while( defaultRenderers.hasMoreElements() )
		{ updateSubComponentUI(defaultRenderers.nextElement()); }

		// Update the UIs of all the default editors.
		Enumeration defaultEditors = defaultEditorsByColumnClass.elements();
		while( defaultEditors.hasMoreElements() )
		{ updateSubComponentUI(defaultEditors.nextElement()); }

		if(trans){
			setUI(new MyTableUI());
			setOpaque(false);
		}else{
			setUI((TableUI)UIManager.getUI(this));
		}
        resizeAndRepaint();
    }

    private void updateSubComponentUI(Object componentShell){
        if(componentShell == null) return;
        Component component = null;
        if( componentShell instanceof Component ) component = (Component)componentShell;
        if( componentShell instanceof DefaultCellEditor) component = ((DefaultCellEditor)componentShell).getComponent();
        if( component != null && component instanceof JComponent) ((JComponent)component).updateUI();
    }
    // 
	public void configureEnclosingScrollPane_()
	{ super.configureEnclosingScrollPane(); }
}
class MyTableUI
extends javax.swing.plaf.basic.BasicTableUI
{
    public void update(Graphics g, JComponent c) {
		paint(g, c);
    }
    public void paint(Graphics g, JComponent c) {
		if (table.getRowCount() <= 0 || table.getColumnCount() <= 0) {
			return;
		}
		Rectangle clip = g.getClipBounds();
		Point upperLeft = clip.getLocation();
		Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
		int rMin = table.rowAtPoint(upperLeft);
		int rMax = table.rowAtPoint(lowerRight);
		// This should never happen.
		if (rMin == -1) {
			rMin = 0;
		}
		// If the table does not have enough rows to fill the view we'll get -1.
		// Replace this with the index of the last row.
		if (rMax == -1) {
			rMax = table.getRowCount()-1;
		}
		boolean ltr = table.getComponentOrientation().isLeftToRight();
		int cMin = table.columnAtPoint(ltr ? upperLeft : lowerRight); 
		int cMax = table.columnAtPoint(ltr ? lowerRight : upperLeft);		 
		// This should never happen.
		if (cMin == -1) {
			cMin = 0;
		}
		// If the table does not have enough columns to fill the view we'll get -1.
		// Replace this with the index of the last column.
		if (cMax == -1) {
			cMax = table.getColumnCount()-1;
		}
		// Paint the grid.
		paintGrid(g, rMin, rMax, cMin, cMax);
		// Paint the cells.
		paintCells(g, rMin, rMax, cMin, cMax);
    }
	private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax){
		g.setColor(table.getGridColor());
		Rectangle minCell = table.getCellRect(rMin, cMin, true);
		Rectangle maxCell = table.getCellRect(rMax, cMax, true);
		Rectangle damagedArea = minCell.union( maxCell );

		if( table.getShowHorizontalLines() ){
			int tableWidth = damagedArea.x + damagedArea.width;
			int y = damagedArea.y;
			for (int row = rMin; row <= rMax; row++) {
				y += table.getRowHeight(row);
				g.drawLine(damagedArea.x, y - 1, tableWidth - 1, y - 1);
			}
		}
		if (table.getShowVerticalLines()) {
			TableColumnModel cm = table.getColumnModel();
			int tableHeight = damagedArea.y + damagedArea.height;
			int x;
			if (table.getComponentOrientation().isLeftToRight()) {
				x = damagedArea.x;
				for (int column = cMin; column <= cMax; column++) {
					int w = cm.getColumn(column).getWidth();
					x += w;
					g.drawLine(x - 1, 0, x - 1, tableHeight - 1);
				}
			} else {
				x = damagedArea.x + damagedArea.width;
				for (int column = cMin; column < cMax; column++) {
					int w = cm.getColumn(column).getWidth();
					x -= w;
					g.drawLine(x - 1, 0, x - 1, tableHeight - 1);
				}
				x -= cm.getColumn(cMax).getWidth();
				g.drawLine(x, 0, x, tableHeight - 1);
			}
		}

    }
    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
		JTableHeader header = table.getTableHeader();
		TableColumn draggedColumn = (header == null) ? null : header.getDraggedColumn();

		TableColumnModel cm = table.getColumnModel();
		int columnMargin = cm.getColumnMargin();

		Rectangle cellRect;
		TableColumn aColumn;
		int columnWidth;
		if (table.getComponentOrientation().isLeftToRight()) {
			for(int row = rMin; row <= rMax; row++) {
			cellRect = table.getCellRect(row, cMin, false);
				for(int column = cMin; column <= cMax; column++) {
					aColumn = cm.getColumn(column);
					columnWidth = aColumn.getWidth();
					cellRect.width = columnWidth - columnMargin;
					if (aColumn != draggedColumn) {
						paintCell(g, cellRect, row, column);
					}
					cellRect.x += columnWidth;
				}
			}
		} else {
			for(int row = rMin; row <= rMax; row++) {
				cellRect = table.getCellRect(row, cMin, false);
				aColumn = cm.getColumn(cMin);
				if (aColumn != draggedColumn) {
					columnWidth = aColumn.getWidth();
					cellRect.width = columnWidth - columnMargin;
					paintCell(g, cellRect, row, cMin);
				}
				for(int column = cMin+1; column <= cMax; column++) {
					aColumn = cm.getColumn(column);
					columnWidth = aColumn.getWidth();
					cellRect.width = columnWidth - columnMargin;
					cellRect.x -= columnWidth;
					if (aColumn != draggedColumn) {
						paintCell(g, cellRect, row, column);
					}
				}
			}
		}

		// Paint the dragged column if we are dragging.
		if (draggedColumn != null) {
			paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
		}
		// Remove any renderers that may be left in the rendererPane.
		rendererPane.removeAll();
	}

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance){
		int draggedColumnIndex = viewIndexForColumn(draggedColumn);

		Rectangle minCell = table.getCellRect(rMin, draggedColumnIndex, true);
		Rectangle maxCell = table.getCellRect(rMax, draggedColumnIndex, true);

		Rectangle vacatedColumnRect = minCell.union(maxCell);

		// Paint a gray well in place of the moving column.
		g.setColor(table.getParent().getBackground());
	//	g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y,	   vacatedColumnRect.width, vacatedColumnRect.height);

		// Move to the where the cell has been dragged.
		vacatedColumnRect.x += distance;

		// Fill the background.
		g.setColor(table.getBackground());
	//	g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y,   vacatedColumnRect.width, vacatedColumnRect.height);

		// Paint the vertical grid lines if necessary.
		if (table.getShowVerticalLines()) {
			g.setColor(table.getGridColor());
			int x1 = vacatedColumnRect.x;
			int y1 = vacatedColumnRect.y;
			int x2 = x1 + vacatedColumnRect.width - 1;
			int y2 = y1 + vacatedColumnRect.height - 1;
			// Left
			g.drawLine(x1-1, y1, x1-1, y2);
			// Right
			g.drawLine(x2, y1, x2, y2);
		}

		for(int row = rMin; row <= rMax; row++) {
			// Render the cell value
			Rectangle r = table.getCellRect(row, draggedColumnIndex, false);
			r.x += distance;
			paintCell(g, r, row, draggedColumnIndex);
			// Paint the (lower) horizontal grid line if necessary.
			if (table.getShowHorizontalLines()) {
				g.setColor(table.getGridColor());
				Rectangle rcr = table.getCellRect(row, draggedColumnIndex, true);
				rcr.x += distance;
				int x1 = rcr.x;
				int y1 = rcr.y;
				int x2 = x1 + rcr.width - 1;
				int y2 = y1 + rcr.height - 1;
				g.drawLine(x1, y2, x2, y2);
			}
		}
	}

	private int viewIndexForColumn(TableColumn aColumn) {
		TableColumnModel cm = table.getColumnModel();
		for (int column = 0; column < cm.getColumnCount(); column++) {
			if (cm.getColumn(column) == aColumn) {
				return column;
			}
		}
		return -1;
	}
	private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
		if(table.isEditing() 
		&& table.getEditingRow()==row 
		&& table.getEditingColumn()==column
		){
			Component component = table.getEditorComponent();
			component.setBounds(cellRect);
			component.validate();
		}else{
			TableCellRenderer renderer = table.getCellRenderer(row, column);
			Component component = table.prepareRenderer(renderer, row, column);
			rendererPane.paintComponent(g, component, table, cellRect.x, cellRect.y,cellRect.width, cellRect.height, true);
		}
	}
}

///////////////////////////////////////////////////////////////////
// 透明なUIにできるヘッダ

class MyTableHeader 
extends javax.swing.table.JTableHeader
{
	boolean trans;
	public MyTableHeader (TableColumnModel m,boolean trans){
		super(m);
		this.trans=trans;
		updateUI();
	}
    public void updateUI(){
		if(trans){
			setUI(new MyTableHeaderUI());
			setOpaque(false);
		}else{
			setUI((TableHeaderUI)UIManager.getUI(this));
		}
		resizeAndRepaint();
		invalidate();
    }
}
class MyTableHeaderUI 
extends javax.swing.plaf.basic.BasicTableHeaderUI
{
    public void update(Graphics g, JComponent c){ paint(g, c); }
	public void paint(Graphics g, JComponent c) {
		if( header.getColumnModel().getColumnCount()<=0 ) return; 
		boolean ltr = header.getComponentOrientation().isLeftToRight();

		Rectangle clip = g.getClipBounds(); 
		Point left = clip.getLocation();
		Point right = new Point( clip.x + clip.width - 1, clip.y );
		TableColumnModel cm = header.getColumnModel(); 
		int cMin = header.columnAtPoint( ltr ? left : right );
		int cMax = header.columnAtPoint( ltr ? right : left );
		if(cMin == -1) cMin = 0;
		if(cMax == -1) cMax = cm.getColumnCount()-1;

		TableColumn draggedColumn = header.getDraggedColumn(); 
		int columnWidth;
		int columnMargin = cm.getColumnMargin();
		Rectangle cellRect = header.getHeaderRect(cMin); 
		TableColumn aColumn;
		if( ltr ){
			for(int column = cMin; column <= cMax ; column++) { 
				aColumn = cm.getColumn(column); 
				columnWidth = aColumn.getWidth();
				cellRect.width = columnWidth - columnMargin;
				if( aColumn != draggedColumn ){ paintCell(g, cellRect, column); } 
				cellRect.x += columnWidth;
			}
		}else{
			aColumn = cm.getColumn(cMin);
			if (aColumn != draggedColumn) {
				columnWidth = aColumn.getWidth();
				cellRect.width = columnWidth - columnMargin;
				cellRect.x += columnMargin;
				paintCell(g, cellRect, cMin);
			}
			for(int column = cMin+1; column <= cMax; column++) {
				aColumn = cm.getColumn(column);
				columnWidth = aColumn.getWidth();
				cellRect.width = columnWidth - columnMargin;
				cellRect.x -= columnWidth;
				if (aColumn != draggedColumn) {
					paintCell(g, cellRect, column);
				}
			}
		} 

		// Paint the dragged column if we are dragging. 
		if (draggedColumn != null) { 
			int draggedColumnIndex = viewIndexForColumn(draggedColumn); 
			Rectangle draggedCellRect = header.getHeaderRect(draggedColumnIndex); 
			
			// Draw a gray well in place of the moving column. 
			g.setColor(header.getParent().getBackground());
//			g.fillRect(draggedCellRect.x, draggedCellRect.y,draggedCellRect.width, draggedCellRect.height);

			draggedCellRect.x += header.getDraggedDistance();

			// Fill the background. 
			g.setColor(header.getBackground());
//			g.fillRect(draggedCellRect.x, draggedCellRect.y,draggedCellRect.width, draggedCellRect.height);
 
			paintCell(g, draggedCellRect, draggedColumnIndex);
		}

		// Remove all components in the rendererPane. 
		rendererPane.removeAll(); 
	}

	private Component getHeaderRenderer(int columnIndex) { 
		TableColumn aColumn = header.getColumnModel().getColumn(columnIndex); 
		TableCellRenderer renderer = aColumn.getHeaderRenderer(); 
		if( renderer == null ) renderer = header.getDefaultRenderer(); 
		return renderer.getTableCellRendererComponent
		(header.getTable(),aColumn.getHeaderValue(), false, false, -1, columnIndex);
	}
	private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
		Component component = getHeaderRenderer(columnIndex); 
		rendererPane.paintComponent(g, component, header, cellRect.x, cellRect.y,cellRect.width, cellRect.height, true);
	}
	private int viewIndexForColumn(TableColumn aColumn) {
		TableColumnModel cm = header.getColumnModel();
		for (int column = 0; column < cm.getColumnCount(); column++)
		{ if( cm.getColumn(column) == aColumn) return column; }
		return -1;
	}
}
