// UTF-8 ☀☁☂☃
package irc;

public class IRCChannelMember{
	public IRCChannelMember(IRCUser _user,String _mode)
	{ user=_user; setOp(_mode); }

	private IRCUser user;
		public IRCUser getUser(){return user;}
		public String  getName(){return user.getName();}

	// '@+' 文字列の管理
	private String mode;
		public void setOp(String _mode){ mode=base.Util.RecycleString(_mode); }
		public String OpString(){ return mode; }

	private int findOp(char key){ return mode.indexOf(key); }
	public boolean hasOp(char key){ return -1 != findOp(key); }
	public boolean addOp(char key){
		if(-1 != findOp(key)) return false;
		setOp(mode+key);
		return true;
	}
	public boolean removeOp(char key){
		int j=findOp(key);
		if(j==-1) return false;
		StringBuffer after = new StringBuffer();
		for(int i=0;i<mode.length();++i){
			if(i!=j) after.append(mode.charAt(i));
		}
		setOp( after.toString() );
		return true;
	}
}
