/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class CodeStringTable {
    char[] codes;
    String[] texts;
    int count;

    CodeStringTable() {
    }

    static int readChar(InputStream i) throws IOException {
        int a = i.read();
        int b = i.read();
        return ((a & 0xFF) << 8) + (b & 0xFF);
    }

    void load(String file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(Util.OpenFile(file));
        this.count = CodeStringTable.readChar(is);
        this.codes = new char[this.count];
        this.texts = new String[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.codes[i] = (char)CodeStringTable.readChar(is);
            int length = ((InputStream)is).read();
            byte[] tmp = new byte[length];
            int offset = 0;
            while (length > 0) {
                int delta = ((InputStream)is).read(tmp, offset, length);
                if (delta <= 0) continue;
                length -= delta;
                offset += delta;
            }
            this.texts[i] = new String(tmp, "UTF-8");
        }
        ((InputStream)is).close();
    }

    String find(int key) {
        int low = 0;
        int width = this.count;
        while (width > 0) {
            int mid = width >> 1;
            char sn = this.codes[low + mid];
            int r = key - sn;
            if (0 == r) {
                return this.texts[low + mid];
            }
            if (r < 0) {
                width = mid;
                continue;
            }
            low += ++mid;
            width -= mid;
        }
        return null;
    }
}

