/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.Util;
import bluntirc.App;
import bluntirc.CTN_Chan;
import bluntirc.ConnTreeNode;
import irc.IRCConnection;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CTN_Conn
extends ConnTreeNode {
    public IRCConnection conn;
    static ImageIcon icon_conn = Util.GetImageIconFromJAR("images/conn1.gif");
    static ImageIcon icon_connD = Util.GetImageIconFromJAR("images/conn2.gif");
    int nick_try_count;
    int pong_timer = 0;

    public String getName() {
        return this.property.getString("Name");
    }

    public String GetCaption() {
        return this.property.getString("Name");
    }

    public String getTitle() {
        return this.property.getString("Name");
    }

    public CTN_Conn getConnNode() {
        return this;
    }

    public ImageIcon getImageIcon() {
        return this.conn.isConnected() ? icon_conn : icon_connD;
    }

    public int getListLevel() {
        return 1;
    }

    public String getPopupName() {
        return "popup-conn";
    }

    public void OnDoubleClick(MouseEvent e) {
        if (!this.conn.isConnected()) {
            this.conn.Connect();
        }
    }

    public void cmd_list() {
        Vector<String> v = new Vector<String>();
        v.add(this.property.setDefaultString("ListDialog_Command", "LIST"));
        this.conn.SendToServer(v);
    }

    public String getNickName(boolean isFirst) {
        int end;
        String nick = this.property.getString("Nick");
        if (isFirst) {
            this.nick_try_count = 0;
            return nick;
        }
        ++this.nick_try_count;
        if (this.nick_try_count >= 100) {
            this.nick_try_count = 0;
        }
        if ((end = nick.length()) > 7) {
            end = 7;
        }
        String nn = "0" + this.nick_try_count;
        return nick.substring(0, end) + nn.substring(nn.length() - 2);
    }

    public boolean SendFromUserInput(String a, int type) {
        if (!this.conn.isConnected()) {
            return false;
        }
        for (int i = 0; i < a.length(); i += i < a.length() && a.charAt(i) == '\n' ? 1 : 0) {
            String cmd;
            int start = i;
            while (i < a.length() && a.charAt(i) != '\n') {
                ++i;
            }
            if (i == start) continue;
            if (a.charAt(start) == App.root_property.getString("CommandSlash").charAt(0)) {
                ++start;
            }
            if (App.action_manager.fireUserCommand(cmd = a.substring(start, i))) continue;
            this.conn.SendToServer(IRCConnection.encodeUserCommand(cmd));
        }
        return true;
    }

    public void onLoad() {
        if (this.property.getBoolean("ConnectOnStartUp", false)) {
            this.conn.Connect();
        }
    }

    public LinkedList getChannelNodes() {
        LinkedList<ConnTreeNode> result = new LinkedList<ConnTreeNode>();
        Iterator it = this.child.iterator();
        while (it.hasNext()) {
            ConnTreeNode o = (ConnTreeNode)it.next();
            if (!(o instanceof CTN_Chan)) continue;
            result.add(o);
        }
        return result;
    }

    public Object getPropertyExtra() {
        return this.conn;
    }

    public void onHashSave() {
    }

    public void onHashLoad() {
    }

    public void onPropertyChanged(String name, Object value) {
        if (name.equals("TimeZone")) {
            this.property.set("TimeZoneObject", (Object)TimeZone.getTimeZone((String)value));
        }
        if (name.equals("Name")) {
            App.updateBufferListItem(this);
        }
    }

    public void setDefaultOption() {
        this.property.setDefaultString("UserMode", "+i");
        this.property.setDefaultString("Server", "");
        this.property.setDefaultString("Port", "6667");
        this.property.setDefaultString("Nick", "");
        this.property.setDefaultString("Password", "");
        this.property.setDefaultString("UserName", App.config_AppName);
        this.property.setDefaultString("RealName", App.config_AppName);
        this.property.setDefaultString("SoTimeout", "3600000");
        this.property.setDefaultBoolean("AutoReconnect", false);
        this.property.setDefaultBoolean("SetPlusI", false);
        this.property.setDefaultBoolean("dumpRecvLine", false);
        this.property.setDefaultBoolean("ConnectOnStartUp", false);
        this.property.setDefaultInt("ForcePongToServer", 60);
    }

    public void onTimer() {
        int max = this.property.getInt("ForcePongToServer", 0);
        if (max <= 0) {
            return;
        }
        if (this.pong_timer > max) {
            this.pong_timer = max;
        }
        if (--this.pong_timer <= 0) {
            this.pong_timer = max;
            if (this.conn.isConnected() && this.conn.fromServer != null) {
                this.conn.SendToServer(IRCConnection.encodeString("PONG :" + this.conn.fromServer.getName()), true, true);
            }
        }
    }

    public List getCreateParam() {
        LinkedList<String> l = new LinkedList<String>();
        l.add(this.getName());
        return l;
    }

    public static ConnTreeNode createNode(ConnTreeNode parent, List param) {
        String name = (String)param.get(0);
        return new CTN_Conn(parent, name);
    }

    public CTN_Conn(ConnTreeNode parent, String name) {
        super(null);
        this.setDefaultOption();
        this.property.setString("Name", name);
        this.conn = new IRCConnection(App.conn_hook, App.connection_logger);
        this.conn.Extra = this;
        parent.insertNodeInto(this);
    }

    public void disconnect() {
        String message = (String)this.property.get("QuitMessage");
        if (message == null) {
            message = "Remove Connection";
        }
        this.conn.Disconnect(message);
    }

    public void PreRemove() {
        this.disconnect();
        this.conn.cleanup();
        this.conn = null;
    }
}

