/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

class MyFormatter
extends Formatter {
    private Calendar calendar = Calendar.getInstance();
    private static final char DATE_SEPARATOR = '/';
    private static final char TIME_SEPARATOR = ':';

    MyFormatter() {
    }

    public String format(LogRecord record) {
        int i;
        StringBuffer sb = new StringBuffer();
        this.calendar.setTimeInMillis(record.getMillis());
        Object[] list = new int[]{this.calendar.get(11), this.calendar.get(12), this.calendar.get(13)};
        for (i = 0; i < list.length; ++i) {
            if (list[i] < 10) {
                sb.append('0');
            }
            sb.append(Integer.toString(list[i]));
            if (i >= list.length - 1) continue;
            sb.append(':');
        }
        list = new String[]{" ", record.getSourceClassName(), "#", record.getSourceMethodName(), " <", record.getLevel().getName(), "> ", record.getMessage(), "\n"};
        for (i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            sb.append((String)list[i]);
        }
        Object[] o = record.getParameters();
        if (o != null) {
            for (i = 0; i < o.length; ++i) {
                if (o[i] == null) {
                    o[i] = "(null)";
                }
                sb.append("\tparam[" + i + "] ");
                sb.append(o[i].toString());
                sb.append("\n");
            }
        }
        Throwable t = record.getThrown();
        int ti = 0;
        while (t != null) {
            sb.append("\u4f8b\u5916[" + ti++ + "]");
            sb.append(t.toString().replace('\n', '\t'));
            sb.append('\n');
            StackTraceElement[] st = t.getStackTrace();
            if (st != null) {
                for (int i2 = 0; i2 < st.length; ++i2) {
                    if (st[i2] == null) continue;
                    sb.append("\tstack[");
                    sb.append(Integer.toString(st.length - i2 - 1));
                    sb.append("] ");
                    sb.append(st[i2].getClassName());
                    sb.append('#');
                    sb.append(st[i2].getMethodName());
                    if (st[i2].isNativeMethod()) {
                        sb.append(" (native method)");
                    } else if (st[i2].getFileName() != null || st[i2].getLineNumber() >= 0) {
                        sb.append(" (");
                        sb.append(st[i2].getFileName());
                        sb.append(':');
                        sb.append(Integer.toString(st[i2].getLineNumber()));
                        sb.append(')');
                    }
                    sb.append('\n');
                }
            }
            if ((t = t.getCause()) == null) continue;
            sb.append("<Cause> ");
        }
        return sb.toString();
    }
}

