/*
 * Decompiled with CFR 0.152.
 */
package buffer;

import base.ByteMap;
import buffer.FontCacheNode;
import buffer.PackedStyle;
import gui.Color4;
import gui.FontInfo2;
import java.awt.Color;
import java.awt.Font;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class StyleID {
    ByteMap basestyle_nametoindex = new ByteMap();
    FontInfo2[] basestyle_cache = new FontInfo2[64];
    ByteMap PFMColorMap = new ByteMap();
    Color4[] pfm_color_cache = new Color4[256];
    public static final int OPTION_STYLE = 0;
    public static final int OPTION_CTCPCOLOR1 = 1;
    public static final int OPTION_CTCPCOLOR2 = 2;
    public static final int OPTION_PFMCOLOR = 3;
    public static final int STYLE_TYPES = 4;
    LinkedList font_cache = new LinkedList();

    public abstract FontInfo2 findBaseStyle(String var1);

    public abstract Color4 findCTCPColor(int var1, int var2);

    public void clear() {
        int i;
        for (i = 0; i < this.basestyle_cache.length; ++i) {
            this.basestyle_cache[i] = null;
        }
        for (i = 0; i < this.pfm_color_cache.length; ++i) {
            this.pfm_color_cache[i] = null;
        }
        this.font_cache.clear();
    }

    public int setBaseStyle(String name) {
        if (name == null) {
            return -1;
        }
        return this.basestyle_nametoindex.put(name);
    }

    public FontInfo2 getBaseStyle(int index) {
        if (index < 0) {
            return null;
        }
        FontInfo2 f = this.basestyle_cache[index];
        if (f == null) {
            f = this.basestyle_cache[index] = this.findBaseStyle((String)this.basestyle_nametoindex.get(index));
        }
        return f;
    }

    public int setPFMColor(Color c) {
        return this.PFMColorMap.put(c);
    }

    public Color4 getPFMColor(int i) {
        Color4 f = this.pfm_color_cache[i];
        if (f == null) {
            f = this.pfm_color_cache[i] = new Color4((Color)this.PFMColorMap.get(i));
        }
        return f;
    }

    public int setCTCPColor1(int c1) {
        return c1;
    }

    public int setCTCPColor2(int c1, int c2) {
        return (c2 & 0xF) << 4 | c1 & 0xF;
    }

    public Color4 getCTCPColor1(int value) {
        return this.findCTCPColor(value & 0xF, -1);
    }

    public Color4 getCTCPColor2(int value) {
        return this.findCTCPColor(value & 0xF, value >> 4 & 0xF);
    }

    public int setFontStyle(int c) {
        return c;
    }

    public int getFontStyle(int c) {
        return c;
    }

    public static int getOptionIDCount() {
        return 4;
    }

    public int getFontStyle(PackedStyle ps) {
        if (ps.optionid[0] != -1) {
            return this.getFontStyle(ps.optionid[0]);
        }
        return this.getBaseStyle(ps.baseid).getFontStyle();
    }

    public String getFontName(PackedStyle ps) {
        return this.getBaseStyle(ps.baseid).getFontName();
    }

    public int getFontSize(PackedStyle ps) {
        return this.getBaseStyle(ps.baseid).getFontSize();
    }

    public Color4 getColor(PackedStyle ps) {
        int b = ps.optionid[2];
        if (b != -1) {
            return this.getCTCPColor2(b);
        }
        b = ps.optionid[1];
        if (b != -1) {
            return this.getCTCPColor1(b);
        }
        b = ps.optionid[3];
        if (b != -1) {
            return this.getPFMColor(b);
        }
        return this.getBaseStyle((int)ps.baseid).color;
    }

    public Font getFont(PackedStyle ps) {
        FontCacheNode node;
        String name = this.getFontName(ps);
        int size = this.getFontSize(ps);
        int style = this.getFontStyle(ps) & 3;
        long now = System.currentTimeMillis();
        Iterator it = this.font_cache.iterator();
        while (it.hasNext()) {
            node = (FontCacheNode)it.next();
            if (!node.name.equals(name) || node.size != size || node.style != style) continue;
            it.remove();
            node.ctime = now;
            this.font_cache.addFirst(node);
            return node.font;
        }
        while (this.font_cache.size() > 20) {
            node = (FontCacheNode)this.font_cache.getLast();
            if (now - node.ctime < 180000L) break;
            this.font_cache.removeLast();
        }
        node = new FontCacheNode();
        node.name = name;
        node.size = size;
        node.style = style;
        node.font = new Font(name, style, size);
        node.ctime = now;
        this.font_cache.addFirst(node);
        return node.font;
    }
}

