/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.BGInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class ImagePanel
extends JLabel {
    ImageIcon icon;
    Color c;
    double wx;
    double wy;
    public int mode = 1;
    Component root;

    public ImagePanel(Component root) {
        this.root = root;
        this.setOpaque(true);
        this.setBackground(SystemColor.window);
        this.wx = 1.0;
        this.wy = 1.0;
    }

    public void reloadBGInfo(BGInfo bg) {
        this.setBackground(bg.color);
        this.icon = bg.image;
        this.repaint();
    }

    public void paint(Graphics g) {
        Dimension sz = this.getSize();
        if (sz.width < 1 || sz.height < 1) {
            return;
        }
        g.setColor(this.getBackground());
        if (this.icon == null) {
            g.fillRect(0, 0, sz.width, sz.height);
        } else {
            switch (this.mode) {
                case 0: {
                    double szw = sz.width;
                    double szh = sz.height;
                    double ih = this.icon.getIconHeight();
                    double iw = this.icon.getIconWidth();
                    if (iw / ih > szw / szh) {
                        int th = (int)(ih * (szw / iw));
                        int tw = sz.width;
                        int loop = sz.height / th;
                        int amari = sz.height % th;
                        if (th <= 0) break;
                        int ys = (int)((double)amari * this.wy);
                        int yl = amari - ys;
                        if (ys > 0) {
                            g.fillRect(0, 0, sz.width, ys);
                        }
                        while (loop-- > 0) {
                            g.drawImage(this.icon.getImage(), 0, ys, tw, th, this);
                            ys += th;
                        }
                        if (yl <= 0) break;
                        g.fillRect(0, sz.height - yl, sz.width, yl);
                        break;
                    }
                    int tw = (int)(iw * (szh / ih));
                    int th = sz.height;
                    int loop = sz.width / tw;
                    int amari = sz.width % tw;
                    if (tw <= 0) break;
                    int xs = (int)((double)amari * this.wx);
                    int xl = amari - xs;
                    if (xs > 0) {
                        g.fillRect(0, 0, xs, sz.height);
                    }
                    while (loop-- > 0) {
                        g.drawImage(this.icon.getImage(), xs, 0, tw, th, this);
                        xs += tw;
                    }
                    if (xl <= 0) break;
                    g.fillRect(sz.width - xl, 0, xl, sz.height);
                    break;
                }
                case 1: {
                    if (this.root == null) {
                        int szw = sz.width;
                        int szh = sz.height;
                        int ih = this.icon.getIconHeight();
                        int iw = this.icon.getIconWidth();
                        for (int y = 0; y < szh; y += ih) {
                            for (int x = 0; x < szw; x += iw) {
                                int ty;
                                int tx = szw - x;
                                if (tx > iw) {
                                    tx = iw;
                                }
                                if ((ty = szh - y) > ih) {
                                    ty = ih;
                                }
                                g.drawImage(this.icon.getImage(), x, y, this.getBackground(), this);
                            }
                        }
                    } else {
                        Rectangle clip = SwingUtilities.convertRectangle(this, g.getClipBounds(), this.root);
                        if (clip.width < 1 || clip.height < 1) {
                            return;
                        }
                        int szw = sz.width;
                        int szh = sz.height;
                        int ih = this.icon.getIconHeight();
                        int iw = this.icon.getIconWidth();
                        int xs = 0;
                        while (xs + iw <= clip.x) {
                            xs += iw;
                        }
                        int ys = 0;
                        while (ys + ih <= clip.y) {
                            ys += ih;
                        }
                        int xe = clip.x + clip.width;
                        int ye = clip.y + clip.height;
                        for (int x = xs; x < xe; x += iw) {
                            for (int y = ys; y < ye; y += ih) {
                                Point drawStart = SwingUtilities.convertPoint(this.root, x, y, this);
                                g.drawImage(this.icon.getImage(), drawStart.x, drawStart.y, this.getBackground(), this);
                            }
                        }
                    }
                    break;
                }
            }
        }
        this.paintChildren(g);
    }

    public Dimension getPreferredSize() {
        return this.getComponent(0).getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getComponent(0).getMaximumSize();
    }

    public Dimension getMinimumSize() {
        return this.getComponent(0).getMinimumSize();
    }
}

