/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MyScrollBarUI;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.UIResource;

public class MyScrollPane
extends JScrollPane {
    boolean trans;

    public MyScrollPane(Component view, boolean trans) {
        super(view);
        this.setHorizontalScrollBar(new ScrollBar(0, trans));
        this.setVerticalScrollBar(new ScrollBar(1, trans));
    }

    protected class ScrollBar
    extends JScrollBar
    implements UIResource {
        boolean trans;
        private boolean blockIncrementSet;
        private boolean unitIncrementSet;

        public ScrollBar(int o, boolean trans) {
            super(o);
            this.trans = trans;
            this.setUI((ScrollBarUI)UIManager.getUI(this));
        }

        public void setUI(ScrollBarUI newUI) {
            if (this.trans) {
                super.setUI(new MyScrollBarUI());
                this.setOpaque(false);
            } else {
                super.setUI(newUI);
            }
        }

        public void setVisibleAmount(int extent) {
            super.setVisibleAmount(extent);
        }

        public void setUnitIncrement(int unitIncrement) {
            this.unitIncrementSet = true;
            super.setUnitIncrement(unitIncrement);
        }

        public int getUnitIncrement(int direction) {
            JViewport vp = MyScrollPane.this.getViewport();
            if (!this.unitIncrementSet && vp != null && vp.getView() instanceof Scrollable) {
                Scrollable view = (Scrollable)((Object)vp.getView());
                Rectangle vr = vp.getViewRect();
                return view.getScrollableUnitIncrement(vr, this.getOrientation(), direction);
            }
            return super.getUnitIncrement(direction);
        }

        public void setBlockIncrement(int blockIncrement) {
            this.blockIncrementSet = true;
            super.setBlockIncrement(blockIncrement);
        }

        public int getBlockIncrement(int direction) {
            JViewport vp = MyScrollPane.this.getViewport();
            if (this.blockIncrementSet || vp == null) {
                return super.getBlockIncrement(direction);
            }
            if (vp.getView() instanceof Scrollable) {
                Scrollable view = (Scrollable)((Object)vp.getView());
                Rectangle vr = vp.getViewRect();
                return view.getScrollableBlockIncrement(vr, this.getOrientation(), direction);
            }
            return this.getOrientation() == 1 ? vp.getExtentSize().height : vp.getExtentSize().width;
        }
    }
}

