/*
 * Decompiled with CFR 0.152.
 */
package irc;

import base.Util;
import irc.CTCPQuote;
import irc.IRCChannel;
import irc.IRCChannelNameOrPrefix;
import irc.IRCConnection;
import irc.IRCUser;
import java.io.ByteArrayOutputStream;
import java.util.GregorianCalendar;
import java.util.Vector;

public class IRCMessage {
    public GregorianCalendar time;
    public IRCConnection conn;
    public byte[] line;
    public IRCUser from;
    public String cmd;
    public Vector ctcp;
    public String params_str;
    protected Vector params;
    boolean ctcp_is_request;
    boolean config_checkParamsCount = true;
    int ctcp_index;
    public Object log_context = null;
    public IRCChannelNameOrPrefix log_from;
    public IRCChannelNameOrPrefix log_to;
    public String log_msg;
    public boolean hideMessage = false;
    public Vector target = new Vector();

    public String getTimeStr() {
        return Util.GetTimeStr(this.time);
    }

    public String getDateStr() {
        return Util.getDateStr(this.time);
    }

    public byte[] getParam(int index) {
        return (byte[])this.params.get(index);
    }

    public int size() {
        return this.params.size();
    }

    public void checkSize(int need) throws IndexOutOfBoundsException {
        if (this.size() < need) {
            throw new IndexOutOfBoundsException("server returns command with too few args : cmd=" + this.cmd + " need=" + need + " now=" + this.size() + " plain_line=" + Util.fromJIS(this.line));
        }
    }

    public IRCMessage(IRCConnection conn, String cmd, String log_msg) {
        this.conn = conn;
        this.from = conn.findUser(Util.AsciiToByteArray("*local*"));
        this.time = new GregorianCalendar(conn.getListener().getTimeZone(conn));
        this.cmd = cmd;
        this.params_str = this.log_msg = log_msg;
    }

    public IRCMessage(IRCConnection conn, byte[] ba) {
        this.conn = conn;
        this.time = new GregorianCalendar(conn.getListener().getTimeZone(conn));
        this.readFromBytes(ba);
    }

    protected IRCMessage(IRCMessage src, byte[] ba, int index) {
        int end;
        this.conn = src.conn;
        this.time = src.time;
        this.line = ba;
        this.from = src.from;
        this.ctcp_index = index;
        this.log_from = src.log_from;
        this.log_to = src.log_to;
        this.log_context = src.log_context;
        this.target = new Vector(0);
        this.ctcp_is_request = 0 == src.cmd.indexOf("PRIVMSG");
        int start = end = 0;
        while (end < ba.length && ba[end] != 32) {
            ++end;
        }
        this.cmd = "CTCP_" + Util.fromJIS(ba, start, end);
        while (end < ba.length && ba[end] == 32) {
            ++end;
        }
        this.params = new Vector();
        this.params.add(Util.ByteSubString(ba, end, ba.length));
        this.log_msg = this.params_str = Util.fromJIS(this.getParam(0));
    }

    public String toString() {
        StringBuffer pb = new StringBuffer();
        pb.append(Util.GetTimeStr(this.time));
        pb.append(' ');
        if (!(this.from == null || this.conn.fromServer != null && this.conn.fromServer.equals(this.from))) {
            pb.append(this.from.getNick());
        }
        pb.append(">");
        pb.append(this.cmd);
        if (this.params != null) {
            int start = 0;
            if (this.conn.myself != null && this.size() > 0 && this.conn.myself.equals(this.getParam(start))) {
                ++start;
                pb.append("*");
            } else {
                pb.append(" ");
            }
            for (int i = start; i < this.size(); ++i) {
                if (this.config_checkParamsCount) {
                    pb.append("(" + i + ")");
                } else if (i != start) {
                    pb.append(' ');
                }
                pb.append(Util.fromJIS(this.getParam(i)));
            }
        }
        return new String(pb);
    }

    public void readFromBytes(byte[] ba) {
        int start;
        this.line = ba;
        int total = ba.length;
        int p = 0;
        if (ba[p] == 58) {
            start = ++p;
            while (p < total && ba[p] != 32) {
                ++p;
            }
            byte[] prefix_bytes = Util.ByteSubString(ba, start, p);
            while (p < total && ba[p] == 32) {
                ++p;
            }
            if (this.conn.FirstPrefix == null) {
                this.conn.FirstPrefix = prefix_bytes;
            }
            this.from = this.conn.findUser(prefix_bytes);
        } else {
            this.from = this.conn.findUser(this.conn.FirstPrefix != null ? this.conn.FirstPrefix : Util.AsciiToByteArray("*server*"));
        }
        start = p;
        while (p < total && ba[p] != 32) {
            ++p;
        }
        this.cmd = Util.fromJIS(ba, start, p);
        while (p < total && ba[p] == 32) {
            ++p;
        }
        boolean isNumeric = true;
        for (int i = 0; i < this.cmd.length(); ++i) {
            if (Character.isDigit(this.cmd.charAt(i))) continue;
            isNumeric = false;
            break;
        }
        if (isNumeric) {
            this.cmd = Integer.toString(Integer.parseInt(this.cmd));
        }
        int params_start = p;
        this.params_str = Util.fromJIS(ba, params_start, total);
        this.params = new Vector();
        if (this.cmd.equals("PRIVMSG") || this.cmd.equals("NOTICE")) {
            start = p;
            while (p < total && ba[p] != 32) {
                ++p;
            }
            if (this.conn.getListener().isQuoteAllParam(this.conn)) {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                CTCPQuote.decodeParam(bao, ba, start, p);
                byte[] b = bao.toByteArray();
            } else {
                this.params.add(Util.ByteSubString(ba, start, p));
            }
            while (p < total && ba[p] == 32) {
                ++p;
            }
            if (p < total && ba[p] == 58) {
                ++p;
            }
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            for (int i = p; i < total; ++i) {
                start = i;
                while (i < ba.length && ba[i] != 1) {
                    ++i;
                }
                if (i > start) {
                    CTCPQuote.decodeParam(bao, ba, start, i);
                }
                if (++i >= total) continue;
                start = i;
                while (i < ba.length && ba[i] != 1) {
                    ++i;
                }
                if (i <= start) continue;
                if (this.ctcp == null) {
                    this.ctcp = new Vector();
                }
                this.ctcp.add(Util.ByteSubString(ba, start, i));
            }
            this.params.add(bao.toByteArray());
        } else {
            while (true) {
                if (p < total && ba[p] == 32) {
                    ++p;
                    continue;
                }
                if (p >= total) break;
                start = p;
                if (ba[p] == 58) {
                    ++start;
                    p = total;
                } else {
                    while (p < total && ba[p] != 32) {
                        ++p;
                    }
                }
                if (this.conn.getListener().isQuoteAllParam(this.conn)) {
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    CTCPQuote.decodeParam(bao, ba, start, p);
                    byte[] b = bao.toByteArray();
                    continue;
                }
                this.params.add(Util.ByteSubString(ba, start, p));
            }
        }
    }

    public IRCMessage[] getCTCP() {
        if (this.ctcp == null) {
            return null;
        }
        IRCMessage[] result = new IRCMessage[this.ctcp.size()];
        for (int i = 0; i < this.ctcp.size(); ++i) {
            byte[] ba = (byte[])this.ctcp.get(i);
            result[i] = new IRCMessage(this, ba, i);
        }
        return result;
    }

    public String getTrail(int index) {
        StringBuffer sb = new StringBuffer();
        while (index < this.size()) {
            sb.append(Util.fromJIS(this.getParam(index)));
            if (index != this.size() - 1) {
                sb.append(' ');
            }
            ++index;
        }
        return new String(sb);
    }

    public IRCMessage addContext(Object t) {
        if (t != null) {
            this.target.add(t);
        }
        return this;
    }

    public IRCChannel setChannelContext(byte[] name) {
        IRCChannel chan = this.conn.FindChannel(name, true);
        this.log_context = chan;
        this.log_to = chan.getCName();
        this.addContext(chan);
        return chan;
    }

    public void sendLogToListener() {
        if (!this.hideMessage) {
            this.conn.getListener().OnLogEvent(this);
        }
    }
}

